/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapred;

import java.io.IOException;
import java.util.Arrays;
import org.apache.accumulo.core.client.mapreduce.lib.util.FileOutputConfigurator;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.collections.map.LRUMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class AccumuloFileOutputFormat
extends FileOutputFormat<Key, Value> {
    private static final Class<?> CLASS = AccumuloFileOutputFormat.class;
    protected static final Logger log = Logger.getLogger(CLASS);

    protected static AccumuloConfiguration getAccumuloConfiguration(JobConf job) {
        return FileOutputConfigurator.getAccumuloConfiguration(CLASS, (Configuration)job);
    }

    public static void setCompressionType(JobConf job, String compressionType) {
        FileOutputConfigurator.setCompressionType(CLASS, (Configuration)job, compressionType);
    }

    public static void setDataBlockSize(JobConf job, long dataBlockSize) {
        FileOutputConfigurator.setDataBlockSize(CLASS, (Configuration)job, dataBlockSize);
    }

    public static void setFileBlockSize(JobConf job, long fileBlockSize) {
        FileOutputConfigurator.setFileBlockSize(CLASS, (Configuration)job, fileBlockSize);
    }

    public static void setIndexBlockSize(JobConf job, long indexBlockSize) {
        FileOutputConfigurator.setIndexBlockSize(CLASS, (Configuration)job, indexBlockSize);
    }

    public static void setReplication(JobConf job, int replication) {
        FileOutputConfigurator.setReplication(CLASS, (Configuration)job, replication);
    }

    public RecordWriter<Key, Value> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        JobConf conf = job;
        AccumuloConfiguration acuConf = AccumuloFileOutputFormat.getAccumuloConfiguration(job);
        String extension = acuConf.get(Property.TABLE_FILE_TYPE);
        final Path file = new Path(AccumuloFileOutputFormat.getWorkOutputPath((JobConf)job), AccumuloFileOutputFormat.getUniqueName((JobConf)job, (String)"part") + "." + extension);
        final LRUMap validVisibilities = new LRUMap(1000);
        return new RecordWriter<Key, Value>((Configuration)conf, acuConf){
            FileSKVWriter out = null;
            final /* synthetic */ Configuration val$conf;
            final /* synthetic */ AccumuloConfiguration val$acuConf;
            {
                this.val$conf = configuration;
                this.val$acuConf = accumuloConfiguration;
            }

            public void close(Reporter reporter) throws IOException {
                if (this.out != null) {
                    this.out.close();
                }
            }

            public void write(Key key, Value value) throws IOException {
                Boolean wasChecked = (Boolean)validVisibilities.get((Object)key.getColumnVisibilityData());
                if (wasChecked == null) {
                    byte[] cv = key.getColumnVisibilityData().toArray();
                    new ColumnVisibility(cv);
                    validVisibilities.put((Object)new ArrayByteSequence(Arrays.copyOf(cv, cv.length)), (Object)Boolean.TRUE);
                }
                if (this.out == null) {
                    this.out = FileOperations.getInstance().openWriter(file.toString(), file.getFileSystem(this.val$conf), this.val$conf, this.val$acuConf);
                    this.out.startDefaultLocalityGroup();
                }
                this.out.append(key, value);
            }
        };
    }
}

