/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.impl.AccumuloServerException;
import org.apache.accumulo.core.client.impl.IsolationException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.impl.TabletType;
import org.apache.accumulo.core.client.impl.Translator;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.KeyValue;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.InitialScan;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.data.thrift.ScanResult;
import org.apache.accumulo.core.data.thrift.TKeyValue;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.accumulo.trace.thrift.TInfo;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;

public class ThriftScanner {
    private static final Logger log = Logger.getLogger(ThriftScanner.class);
    public static final Map<TabletType, Set<String>> serversWaitedForWrites = new EnumMap<TabletType, Set<String>>(TabletType.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean getBatchFromServer(TCredentials credentials, Range range, KeyExtent extent, String server, SortedMap<Key, Value> results, SortedSet<Column> fetchedColumns, List<IterInfo> serverSideIteratorList, Map<String, Map<String, String>> serverSideIteratorOptions, int size, Authorizations authorizations, boolean retry, AccumuloConfiguration conf) throws AccumuloException, AccumuloSecurityException, NotServingTabletException {
        block11: {
            boolean bl;
            if (server == null) {
                throw new AccumuloException(new IOException());
            }
            TInfo tinfo = Tracer.traceInfo();
            TabletClientService.Client client = ThriftUtil.getTServerClient(server, conf);
            try {
                ScanState scanState = new ScanState(credentials, extent.getTableId(), authorizations, range, fetchedColumns, size, serverSideIteratorList, serverSideIteratorOptions, false);
                TabletType ttype = TabletType.type(extent);
                boolean waitForWrites = !serversWaitedForWrites.get((Object)ttype).contains(server);
                InitialScan isr = client.startScan(tinfo, scanState.credentials, extent.toThrift(), scanState.range.toThrift(), Translator.translate(scanState.columns, Translator.CT), scanState.size, scanState.serverSideIteratorList, scanState.serverSideIteratorOptions, scanState.authorizations.getAuthorizationsBB(), waitForWrites, scanState.isolated);
                if (waitForWrites) {
                    serversWaitedForWrites.get((Object)ttype).add(server);
                }
                Key.decompress(isr.result.results);
                for (TKeyValue kv : isr.result.results) {
                    results.put(new Key(kv.key), new Value(kv.value));
                }
                client.closeScan(tinfo, isr.scanID);
                bl = isr.result.more;
            }
            catch (Throwable throwable) {
                try {
                    ThriftUtil.returnClient(client);
                    throw throwable;
                }
                catch (TApplicationException tae) {
                    throw new AccumuloServerException(server, tae);
                }
                catch (TooManyFilesException e) {
                    log.debug((Object)("Tablet (" + extent + ") has too many files " + server + " : " + e));
                    break block11;
                }
                catch (ThriftSecurityException e) {
                    log.warn((Object)("Security Violation in scan request to " + server + ": " + e));
                    throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
                }
                catch (TException e) {
                    log.debug((Object)("Error getting transport to " + server + " : " + (Object)((Object)e)));
                }
            }
            ThriftUtil.returnClient(client);
            return bl;
        }
        throw new AccumuloException("getBatchFromServer: failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<KeyValue> scan(Instance instance, TCredentials credentials, ScanState scanState, int timeOut, AccumuloConfiguration conf) throws ScanTimedOutException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        TabletLocator.TabletLocation loc = null;
        long startTime = System.currentTimeMillis();
        String lastError = null;
        String error = null;
        int tooManyFilesCount = 0;
        List<KeyValue> results = null;
        Span span = Trace.start((String)"scan");
        try {
            while (results == null && !scanState.finished) {
                if ((double)(System.currentTimeMillis() - startTime) / 1000.0 > (double)timeOut) {
                    throw new ScanTimedOutException();
                }
                while (loc == null) {
                    long currentTime = System.currentTimeMillis();
                    if ((double)(currentTime - startTime) / 1000.0 > (double)timeOut) {
                        throw new ScanTimedOutException();
                    }
                    Span locateSpan = Trace.start((String)"scan:locateTablet");
                    try {
                        loc = TabletLocator.getInstance(instance, scanState.tableName).locateTablet(scanState.startRow, scanState.skipStartRow, false, credentials);
                        if (loc == null) {
                            if (!Tables.exists(instance, scanState.tableName.toString())) {
                                throw new TableDeletedException(scanState.tableName.toString());
                            }
                            if (Tables.getTableState(instance, scanState.tableName.toString()) == TableState.OFFLINE) {
                                throw new TableOfflineException(instance, scanState.tableName.toString());
                            }
                            error = "Failed to locate tablet for table : " + scanState.tableName + " row : " + scanState.startRow;
                            if (!error.equals(lastError)) {
                                log.debug((Object)error);
                            } else if (log.isTraceEnabled()) {
                                log.trace((Object)error);
                            }
                            lastError = error;
                            UtilWaitThread.sleep(100L);
                            continue;
                        }
                        Range dataRange = loc.tablet_extent.toDataRange();
                        if (scanState.range.getStartKey() != null && dataRange.afterEndKey(scanState.range.getStartKey())) {
                            scanState.startRow = loc.tablet_extent.getEndRow();
                            scanState.skipStartRow = true;
                            loc = null;
                            continue;
                        }
                        if (scanState.range.getEndKey() == null || !dataRange.beforeStartKey(scanState.range.getEndKey())) continue;
                        throw new RuntimeException("Unexpected tablet, extent : " + loc.tablet_extent + "  range : " + scanState.range + " startRow : " + scanState.startRow);
                    }
                    catch (AccumuloServerException e) {
                        log.debug((Object)("Scan failed, server side exception : " + e.getMessage()));
                        throw e;
                    }
                    catch (AccumuloException e) {
                        error = "exception from tablet loc " + e.getMessage();
                        if (!error.equals(lastError)) {
                            log.debug((Object)error);
                        } else if (log.isTraceEnabled()) {
                            log.trace((Object)error);
                        }
                        lastError = error;
                        UtilWaitThread.sleep(100L);
                    }
                    finally {
                        locateSpan.stop();
                    }
                }
                Span scanLocation = Trace.start((String)"scan:location");
                scanLocation.data("tserver", loc.tablet_location);
                try {
                    results = ThriftScanner.scan(loc, scanState, conf);
                }
                catch (AccumuloSecurityException e) {
                    Tables.clearCache(instance);
                    if (!Tables.exists(instance, scanState.tableName.toString())) {
                        throw new TableDeletedException(scanState.tableName.toString());
                    }
                    throw e;
                }
                catch (TApplicationException tae) {
                    throw new AccumuloServerException(loc.tablet_location, tae);
                }
                catch (NotServingTabletException e) {
                    error = "Scan failed, not serving tablet " + loc;
                    if (!error.equals(lastError)) {
                        log.debug((Object)error);
                    } else if (log.isTraceEnabled()) {
                        log.trace((Object)error);
                    }
                    lastError = error;
                    TabletLocator.getInstance(instance, scanState.tableName).invalidateCache(loc.tablet_extent);
                    loc = null;
                    scanState.scanID = null;
                    if (scanState.isolated) {
                        throw new IsolationException();
                    }
                    UtilWaitThread.sleep(100L);
                }
                catch (NoSuchScanIDException e) {
                    error = "Scan failed, no such scan id " + scanState.scanID + " " + loc;
                    if (!error.equals(lastError)) {
                        log.debug((Object)error);
                    } else if (log.isTraceEnabled()) {
                        log.trace((Object)error);
                    }
                    lastError = error;
                    if (scanState.isolated) {
                        throw new IsolationException();
                    }
                    scanState.scanID = null;
                }
                catch (TooManyFilesException e) {
                    error = "Tablet has too many files " + loc + " retrying...";
                    if (!error.equals(lastError)) {
                        log.debug((Object)error);
                        tooManyFilesCount = 0;
                    } else if (++tooManyFilesCount == 300) {
                        log.warn((Object)error);
                    } else if (log.isTraceEnabled()) {
                        log.trace((Object)error);
                    }
                    lastError = error;
                    scanState.scanID = null;
                    if (scanState.isolated) {
                        throw new IsolationException();
                    }
                    UtilWaitThread.sleep(100L);
                }
                catch (TException e) {
                    TabletLocator.getInstance(instance, scanState.tableName).invalidateCache(loc.tablet_location);
                    error = "Scan failed, thrift error " + ((Object)((Object)e)).getClass().getName() + "  " + e.getMessage() + " " + loc;
                    if (!error.equals(lastError)) {
                        log.debug((Object)error);
                    } else if (log.isTraceEnabled()) {
                        log.trace((Object)error);
                    }
                    lastError = error;
                    loc = null;
                    scanState.scanID = null;
                    if (scanState.isolated) {
                        throw new IsolationException();
                    }
                    UtilWaitThread.sleep(100L);
                }
                finally {
                    scanLocation.stop();
                }
            }
            if (results != null && results.size() == 0 && scanState.finished) {
                results = null;
            }
            List<KeyValue> list = results;
            return list;
        }
        finally {
            span.stop();
        }
    }

    private static List<KeyValue> scan(TabletLocator.TabletLocation loc, ScanState scanState, AccumuloConfiguration conf) throws AccumuloSecurityException, NotServingTabletException, TException, NoSuchScanIDException, TooManyFilesException {
        if (scanState.finished) {
            return null;
        }
        OpTimer opTimer = new OpTimer(log, Level.TRACE);
        TInfo tinfo = Tracer.traceInfo();
        TabletClientService.Client client = ThriftUtil.getTServerClient(loc.tablet_location, conf);
        String old = Thread.currentThread().getName();
        try {
            ScanResult sr;
            String msg;
            if (scanState.prevLoc != null && !scanState.prevLoc.equals(loc)) {
                scanState.scanID = null;
            }
            scanState.prevLoc = loc;
            if (scanState.scanID == null) {
                msg = "Starting scan tserver=" + loc.tablet_location + " tablet=" + loc.tablet_extent + " range=" + scanState.range + " ssil=" + scanState.serverSideIteratorList + " ssio=" + scanState.serverSideIteratorOptions;
                Thread.currentThread().setName(msg);
                opTimer.start(msg);
                TabletType ttype = TabletType.type(loc.tablet_extent);
                boolean waitForWrites = !serversWaitedForWrites.get((Object)ttype).contains(loc.tablet_location);
                InitialScan is = client.startScan(tinfo, scanState.credentials, loc.tablet_extent.toThrift(), scanState.range.toThrift(), Translator.translate(scanState.columns, Translator.CT), scanState.size, scanState.serverSideIteratorList, scanState.serverSideIteratorOptions, scanState.authorizations.getAuthorizationsBB(), waitForWrites, scanState.isolated);
                if (waitForWrites) {
                    serversWaitedForWrites.get((Object)ttype).add(loc.tablet_location);
                }
                sr = is.result;
                if (sr.more) {
                    scanState.scanID = is.scanID;
                } else {
                    client.closeScan(tinfo, is.scanID);
                }
            } else {
                msg = "Continuing scan tserver=" + loc.tablet_location + " scanid=" + scanState.scanID;
                Thread.currentThread().setName(msg);
                opTimer.start(msg);
                sr = client.continueScan(tinfo, scanState.scanID);
                if (!sr.more) {
                    client.closeScan(tinfo, scanState.scanID);
                    scanState.scanID = null;
                }
            }
            if (!sr.more) {
                if (loc.tablet_extent.getEndRow() == null) {
                    scanState.finished = true;
                    opTimer.stop("Completely finished scan in %DURATION% #results=" + sr.results.size());
                } else if (scanState.range.getEndKey() == null || !scanState.range.afterEndKey(new Key(loc.tablet_extent.getEndRow()).followingKey(PartialKey.ROW))) {
                    scanState.startRow = loc.tablet_extent.getEndRow();
                    scanState.skipStartRow = true;
                    opTimer.stop("Finished scanning tablet in %DURATION% #results=" + sr.results.size());
                } else {
                    scanState.finished = true;
                    opTimer.stop("Completely finished scan in %DURATION% #results=" + sr.results.size());
                }
            } else {
                opTimer.stop("Finished scan in %DURATION% #results=" + sr.results.size() + " scanid=" + scanState.scanID);
            }
            Key.decompress(sr.results);
            if (sr.results.size() > 0 && !scanState.finished) {
                scanState.range = new Range(new Key(sr.results.get((int)(sr.results.size() - 1)).key), false, scanState.range.getEndKey(), scanState.range.isEndKeyInclusive());
            }
            ArrayList<KeyValue> results = new ArrayList<KeyValue>(sr.results.size());
            for (TKeyValue tkv : sr.results) {
                results.add(new KeyValue(new Key(tkv.key), tkv.value));
            }
            ArrayList<KeyValue> arrayList = results;
            return arrayList;
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        finally {
            ThriftUtil.returnClient(client);
            Thread.currentThread().setName(old);
        }
    }

    static {
        for (TabletType ttype : TabletType.values()) {
            serversWaitedForWrites.put(ttype, Collections.synchronizedSet(new HashSet()));
        }
    }

    public static class ScanTimedOutException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }

    public static class ScanState {
        boolean isolated;
        Text tableName;
        Text startRow;
        boolean skipStartRow;
        Range range;
        int size;
        TCredentials credentials;
        Authorizations authorizations;
        List<Column> columns;
        TabletLocator.TabletLocation prevLoc;
        Long scanID;
        boolean finished = false;
        List<IterInfo> serverSideIteratorList;
        Map<String, Map<String, String>> serverSideIteratorOptions;

        public ScanState(TCredentials credentials, Text tableName, Authorizations authorizations, Range range, SortedSet<Column> fetchedColumns, int size, List<IterInfo> serverSideIteratorList, Map<String, Map<String, String>> serverSideIteratorOptions, boolean isolated) {
            this.credentials = credentials;
            this.authorizations = authorizations;
            this.columns = new ArrayList<Column>(fetchedColumns.size());
            for (Column column : fetchedColumns) {
                this.columns.add(column);
            }
            this.tableName = tableName;
            this.range = range;
            Key startKey = range.getStartKey();
            if (startKey == null) {
                startKey = new Key();
            }
            this.startRow = startKey.getRow();
            this.skipStartRow = false;
            this.size = size;
            this.serverSideIteratorList = serverSideIteratorList;
            this.serverSideIteratorOptions = serverSideIteratorOptions;
            this.isolated = isolated;
        }
    }
}

