/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.Vertex;

@InterfaceAudience.Public
public class VertexGroup {
    GroupInfo groupInfo;

    VertexGroup(String groupName, Vertex ... members) {
        if (members == null || members.length < 2) {
            throw new IllegalArgumentException("VertexGroup must have at least 2 members");
        }
        this.groupInfo = new GroupInfo(groupName, members);
    }

    public String getGroupName() {
        return this.groupInfo.groupName;
    }

    public VertexGroup addDataSink(String outputName, DataSinkDescriptor dataSinkDescriptor) {
        RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor> leafOutput = new RootInputLeafOutput<OutputDescriptor, OutputCommitterDescriptor>(outputName, dataSinkDescriptor.getOutputDescriptor(), dataSinkDescriptor.getOutputCommitterDescriptor());
        this.groupInfo.outputs.add(outputName);
        for (Vertex member : this.getMembers()) {
            member.addAdditionalDataSink(leafOutput);
        }
        return this;
    }

    public String toString() {
        return "[ VertexGroup: " + this.groupInfo.getGroupName() + "], members=" + this.groupInfo.members;
    }

    GroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    Set<Vertex> getMembers() {
        return this.groupInfo.members;
    }

    void addOutputVertex(Vertex outputVertex, GroupInputEdge edge) {
        this.groupInfo.edgeMergedInputs.put(outputVertex.getName(), edge.getMergedInput());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupInfo.groupName == null ? 0 : this.groupInfo.groupName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VertexGroup other = (VertexGroup)obj;
        return !(this.groupInfo.groupName == null ? other.groupInfo.groupName != null : !this.groupInfo.groupName.equals(other.groupInfo.groupName));
    }

    static class GroupInfo {
        String groupName;
        Set<Vertex> members = new HashSet<Vertex>();
        Set<String> outputs = new HashSet<String>();
        Map<String, InputDescriptor> edgeMergedInputs = Maps.newHashMap();

        GroupInfo(String groupName, Vertex ... vertices) {
            this.groupName = groupName;
            this.members = Sets.newHashSetWithExpectedSize((int)vertices.length);
            for (Vertex v : vertices) {
                this.members.add(v);
            }
        }

        String getGroupName() {
            return this.groupName;
        }

        Set<Vertex> getMembers() {
            return this.members;
        }

        Set<String> getOutputs() {
            return this.outputs;
        }
    }
}

