/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.thrift.InitialMultiScan;
import org.apache.accumulo.core.data.thrift.MultiScanResult;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.data.thrift.TRange;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.util.MetadataTable;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.accumulo.trace.thrift.TInfo;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;

public class VerifyTabletAssignments {
    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(VerifyTabletAssignments.class.getName(), args, new Object[0]);
        Connector conn = opts.getConnector();
        for (String table : conn.tableOperations().list()) {
            VerifyTabletAssignments.checkTable(opts, table, null);
        }
    }

    private static void checkTable(final Opts opts, String tableName, HashSet<KeyExtent> check) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, InterruptedException {
        if (check == null) {
            System.out.println("Checking table " + tableName);
        } else {
            System.out.println("Checking table " + tableName + " again, failures " + check.size());
        }
        TreeMap locations = new TreeMap();
        TreeSet tablets = new TreeSet();
        Connector conn = opts.getConnector();
        Instance inst = conn.getInstance();
        MetadataTable.getEntries((Instance)conn.getInstance(), (TCredentials)CredentialHelper.create((String)opts.principal, (AuthenticationToken)opts.getToken(), (String)opts.instance), (String)tableName, (boolean)false, locations, tablets);
        final HashSet<KeyExtent> failures = new HashSet<KeyExtent>();
        for (KeyExtent keyExtent : tablets) {
            if (!locations.containsKey(keyExtent)) {
                System.out.println(" Tablet " + keyExtent + " has no location");
                continue;
            }
            if (!opts.verbose) continue;
            System.out.println(" Tablet " + keyExtent + " is located at " + (String)locations.get(keyExtent));
        }
        TreeMap extentsPerServer = new TreeMap();
        for (Map.Entry entry : locations.entrySet()) {
            ArrayList extentList = (ArrayList)extentsPerServer.get(entry.getValue());
            if (extentList == null) {
                extentList = new ArrayList();
                extentsPerServer.put(entry.getValue(), extentList);
            }
            if (check != null && !check.contains(entry.getKey())) continue;
            extentList.add(entry.getKey());
        }
        ExecutorService tp = Executors.newFixedThreadPool(20);
        final ServerConfiguration conf = new ServerConfiguration(inst);
        for (final Map.Entry entry : extentsPerServer.entrySet()) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        VerifyTabletAssignments.checkTabletServer(conf.getConfiguration(), CredentialHelper.create((String)opts.principal, (AuthenticationToken)opts.getToken(), (String)opts.instance), entry, failures);
                    }
                    catch (Exception e) {
                        System.err.println("Failure on ts " + (String)entry.getKey() + " " + e.getMessage());
                        e.printStackTrace();
                        failures.addAll((Collection)entry.getValue());
                    }
                }
            };
            tp.execute(r);
        }
        tp.shutdown();
        while (!tp.awaitTermination(1L, TimeUnit.HOURS)) {
        }
        if (failures.size() > 0) {
            VerifyTabletAssignments.checkTable(opts, tableName, failures);
        }
    }

    private static void checkFailures(String server, HashSet<KeyExtent> failures, MultiScanResult scanResult) {
        for (TKeyExtent tke : scanResult.failures.keySet()) {
            KeyExtent ke = new KeyExtent(tke);
            System.out.println(" Tablet " + ke + " failed at " + server);
            failures.add(ke);
        }
    }

    private static void checkTabletServer(AccumuloConfiguration conf, TCredentials st, Map.Entry<String, List<KeyExtent>> entry, HashSet<KeyExtent> failures) throws ThriftSecurityException, TException, NoSuchScanIDException {
        TabletClientService.Client client = ThriftUtil.getTServerClient((String)entry.getKey(), (AccumuloConfiguration)conf);
        TreeMap<TKeyExtent, List<TRange>> batch = new TreeMap<TKeyExtent, List<TRange>>();
        for (KeyExtent keyExtent : entry.getValue()) {
            Text row = keyExtent.getEndRow();
            Text row2 = null;
            if (row == null) {
                row = keyExtent.getPrevEndRow();
                if (row != null) {
                    row = new Text(row);
                    row.append(new byte[]{97}, 0, 1);
                } else {
                    row = new Text("1234567890");
                }
                row2 = new Text(row);
                row2.append(new byte[]{33}, 0, 1);
            } else {
                row = new Text(row);
                row2 = new Text(row);
                row.getBytes()[row.getLength() - 1] = (byte)(row.getBytes()[row.getLength() - 1] - 1);
            }
            Range r = new Range(row, true, row2, false);
            batch.put(keyExtent.toThrift(), Collections.singletonList(r.toThrift()));
        }
        TInfo tinfo = Tracer.traceInfo();
        Map emptyMapSMapSS = Collections.emptyMap();
        List emptyListIterInfo = Collections.emptyList();
        List emptyListColumn = Collections.emptyList();
        InitialMultiScan is = client.startMultiScan(tinfo, st, batch, emptyListColumn, emptyListIterInfo, emptyMapSMapSS, Constants.NO_AUTHS.getAuthorizationsBB(), false);
        if (is.result.more) {
            MultiScanResult result = client.continueMultiScan(tinfo, is.scanID);
            VerifyTabletAssignments.checkFailures(entry.getKey(), failures, result);
            while (result.more) {
                result = client.continueMultiScan(tinfo, is.scanID);
                VerifyTabletAssignments.checkFailures(entry.getKey(), failures, result);
            }
        }
        client.closeMultiScan(tinfo, is.scanID);
        ThriftUtil.returnClient((TServiceClient)((TServiceClient)client));
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"-v", "--verbose"}, description="verbose mode (prints locations of tablets)")
        boolean verbose = false;

        Opts() {
        }
    }
}

