/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.impl.Writer;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.util.MetadataTable;
import org.apache.accumulo.server.util.OfflineMetadataScanner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;

public class CheckForMetadataProblems {
    private static boolean sawProblems = false;

    public static void checkTable(String tablename, TreeSet<KeyExtent> tablets, Opts opts) throws AccumuloSecurityException {
        if (tablets.size() == 0) {
            System.out.println("No entries found in metadata table for table " + tablename);
            sawProblems = true;
            return;
        }
        if (tablets.first().getPrevEndRow() != null) {
            System.out.println("First entry for table " + tablename + "- " + tablets.first() + " - has non null prev end row");
            sawProblems = true;
            return;
        }
        if (tablets.last().getEndRow() != null) {
            System.out.println("Last entry for table " + tablename + "- " + tablets.last() + " - has non null end row");
            sawProblems = true;
            return;
        }
        Iterator<KeyExtent> tabIter = tablets.iterator();
        Text lastEndRow = tabIter.next().getEndRow();
        boolean everythingLooksGood = true;
        while (tabIter.hasNext()) {
            KeyExtent tabke = tabIter.next();
            boolean broke = false;
            if (tabke.getPrevEndRow() == null) {
                System.out.println("Table " + tablename + " has null prev end row in middle of table " + tabke);
                broke = true;
            } else if (!tabke.getPrevEndRow().equals((Object)lastEndRow)) {
                System.out.println("Table " + tablename + " has a hole " + tabke.getPrevEndRow() + " != " + lastEndRow);
                broke = true;
            }
            if (broke) {
                everythingLooksGood = false;
            }
            if (broke && opts.fix) {
                KeyExtent ke = new KeyExtent(tabke);
                ke.setPrevEndRow(lastEndRow);
                MetadataTable.updateTabletPrevEndRow(ke, CredentialHelper.create((String)opts.principal, (AuthenticationToken)opts.getToken(), (String)opts.instance));
                System.out.println("KE " + tabke + " has been repaired to " + ke);
            }
            lastEndRow = tabke.getEndRow();
        }
        if (everythingLooksGood) {
            System.out.println("All is well for table " + tablename);
        } else {
            sawProblems = true;
        }
    }

    public static void checkMetadataTableEntries(Opts opts, FileSystem fs) throws Exception {
        HashMap tables = new HashMap();
        Scanner scanner = opts.offline ? new OfflineMetadataScanner(ServerConfiguration.getSystemConfiguration(opts.getInstance()), fs) : opts.getConnector().createScanner("!METADATA", Constants.NO_AUTHS);
        scanner.setRange(Constants.METADATA_KEYSPACE);
        Constants.METADATA_PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
        scanner.fetchColumnFamily(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY);
        Text colf = new Text();
        Text colq = new Text();
        boolean justLoc = false;
        int count = 0;
        for (Map.Entry entry : scanner) {
            colf = ((Key)entry.getKey()).getColumnFamily(colf);
            colq = ((Key)entry.getKey()).getColumnQualifier(colq);
            ++count;
            String tableName = new KeyExtent(((Key)entry.getKey()).getRow(), (Text)null).getTableId().toString();
            TreeSet<KeyExtent> tablets = (TreeSet<KeyExtent>)tables.get(tableName);
            if (tablets == null) {
                Set es = tables.entrySet();
                for (Map.Entry entry2 : es) {
                    CheckForMetadataProblems.checkTable((String)entry2.getKey(), (TreeSet)entry2.getValue(), opts);
                }
                tables.clear();
                tablets = new TreeSet<KeyExtent>();
                tables.put(tableName, tablets);
            }
            if (Constants.METADATA_PREV_ROW_COLUMN.equals(colf, colq)) {
                KeyExtent tabletKe = new KeyExtent(((Key)entry.getKey()).getRow(), (Value)entry.getValue());
                tablets.add(tabletKe);
                justLoc = false;
                continue;
            }
            if (!colf.equals((Object)Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY)) continue;
            if (justLoc) {
                System.out.println("Problem at key " + entry.getKey());
                sawProblems = true;
                if (opts.fix) {
                    Writer t = MetadataTable.getMetadataTable(CredentialHelper.create((String)opts.principal, (AuthenticationToken)opts.getToken(), (String)opts.instance));
                    Key k = (Key)entry.getKey();
                    Mutation m = new Mutation(k.getRow());
                    m.putDelete(k.getColumnFamily(), k.getColumnQualifier());
                    try {
                        t.update(m);
                        System.out.println("Deleted " + k);
                    }
                    catch (ConstraintViolationException e) {
                        e.printStackTrace();
                    }
                }
            }
            justLoc = true;
        }
        if (count == 0) {
            System.err.println("ERROR : !METADATA table is empty");
            sawProblems = true;
        }
        Set es = tables.entrySet();
        for (Map.Entry entry : es) {
            CheckForMetadataProblems.checkTable((String)entry.getKey(), (TreeSet)entry.getValue(), opts);
        }
    }

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(CheckForMetadataProblems.class.getName(), args, new Object[0]);
        FileSystem fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
        CheckForMetadataProblems.checkMetadataTableEntries(opts, fs);
        opts.stopTracing();
        if (sawProblems) {
            System.exit(-1);
        }
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"--fix"}, description="best-effort attempt to fix problems found")
        boolean fix = false;
        @Parameter(names={"--offline"}, description="perform the check on the files directly")
        boolean offline = false;

        Opts() {
        }
    }
}

