/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.monitor.servlets;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.accumulo.core.master.thrift.DeadServer;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.server.monitor.Monitor;
import org.apache.accumulo.server.monitor.servlets.BasicServlet;
import org.apache.accumulo.server.monitor.util.celltypes.TServerLinkType;

public class JSONServlet
extends BasicServlet {
    private static final long serialVersionUID = 1L;
    private Gson gson = new Gson();

    @Override
    protected String getTitle(HttpServletRequest req) {
        return "JSON Report";
    }

    @Override
    protected void pageStart(HttpServletRequest req, HttpServletResponse resp, StringBuilder sb) {
        resp.setContentType("application/json");
    }

    private static Map<String, Object> addServer(String ip, String hostname, double osload, double ingest, double query, double ingestMB, double queryMB, int scans, double scansessions, long holdtime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ip", ip);
        map.put("hostname", hostname);
        map.put("osload", osload);
        map.put("ingest", ingest);
        map.put("query", query);
        map.put("ingestMB", ingestMB);
        map.put("queryMB", queryMB);
        map.put("scans", scans);
        map.put("scanssessions", scansessions);
        map.put("holdtime", holdtime);
        return map;
    }

    @Override
    protected void pageBody(HttpServletRequest req, HttpServletResponse resp, StringBuilder sb) {
        if (Monitor.getMmi() == null || Monitor.getMmi().tableMap == null) {
            return;
        }
        HashMap results = new HashMap();
        ArrayList<Map<String, Object>> servers = new ArrayList<Map<String, Object>>();
        for (TabletServerStatus tabletServerStatus : Monitor.getMmi().tServerInfo) {
            TableInfo summary = Monitor.summarizeTableStats(tabletServerStatus);
            servers.add(JSONServlet.addServer(tabletServerStatus.name, TServerLinkType.displayName(tabletServerStatus.name), tabletServerStatus.osLoad, summary.ingestRate, summary.queryRate, summary.ingestByteRate / 1000000.0, summary.queryByteRate / 1000000.0, summary.scans.running + summary.scans.queued, Monitor.getLookupRate(), tabletServerStatus.holdTime));
        }
        for (Map.Entry entry : Monitor.getMmi().badTServers.entrySet()) {
            HashMap<String, Object> badServer = new HashMap<String, Object>();
            badServer.put("ip", entry.getKey());
            badServer.put("bad", true);
            servers.add(badServer);
        }
        for (DeadServer deadServer : Monitor.getMmi().deadTabletServers) {
            HashMap<String, Object> deadServer2 = new HashMap<String, Object>();
            deadServer2.put("ip", deadServer.server);
            deadServer2.put("dead", true);
            servers.add(deadServer2);
        }
        results.put("servers", servers);
        sb.append(this.gson.toJson(results));
    }

    @Override
    protected void pageEnd(HttpServletRequest req, HttpServletResponse resp, StringBuilder sb) {
    }
}

