/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metanalysis;

import com.beust.jcommander.Parameter;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.logger.LogFileValue;
import org.apache.hadoop.io.Text;

public class PrintEvents {
    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(PrintEvents.class.getName(), args, new Object[0]);
        Connector conn = opts.getConnector();
        PrintEvents.printEvents(conn, opts.tableId, opts.endRow, opts.time);
    }

    private static void printEvents(Connector conn, String tableId, String endRow, Long time) throws Exception {
        Scanner scanner = conn.createScanner("tabletEvents", new Authorizations());
        String metaRow = tableId + (endRow == null ? "<" : ";" + endRow);
        scanner.setRange(new Range(new Key((CharSequence)metaRow, (CharSequence)String.format("%020d", time)), true, new Key((CharSequence)metaRow).followingKey(PartialKey.ROW), false));
        int count = 0;
        String lastLog = null;
        block0: for (Map.Entry entry : scanner) {
            if (((Key)entry.getKey()).getColumnQualifier().toString().equals("log")) {
                if (lastLog == null || !lastLog.equals(((Value)entry.getValue()).toString())) {
                    System.out.println("Log : " + entry.getValue());
                }
                lastLog = ((Value)entry.getValue()).toString();
                continue;
            }
            if (!((Key)entry.getKey()).getColumnQualifier().toString().equals("mut")) continue;
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(((Value)entry.getValue()).get()));
            Mutation m = new Mutation();
            m.readFields((DataInput)dis);
            LogFileValue lfv = new LogFileValue();
            lfv.mutations = Collections.singletonList(m);
            System.out.println(LogFileValue.format(lfv, 1));
            List columnsUpdates = m.getUpdates();
            for (ColumnUpdate cu : columnsUpdates) {
                if (!Constants.METADATA_PREV_ROW_COLUMN.equals(new Text(cu.getColumnFamily()), new Text(cu.getColumnQualifier())) || count <= 0) continue;
                System.out.println("Saw change to prevrow, stopping printing events.");
                break block0;
            }
            ++count;
        }
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"-t", "--tableId"}, description="table id", required=true)
        String tableId;
        @Parameter(names={"-e", "--endRow"}, description="end row")
        String endRow;
        @Parameter(names={"-t", "--time"}, description="time, in milliseconds", required=true)
        long time;

        Opts() {
        }
    }
}

