/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.CurrentState;
import org.apache.accumulo.server.master.state.DistributedStoreException;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletStateStore;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.hadoop.io.Text;

public class MetaDataStateStore
extends TabletStateStore {
    private static final int THREADS = 4;
    private static final int LATENCY = 1000;
    private static final int MAX_MEMORY = 0xC800000;
    protected final Instance instance;
    protected final CurrentState state;
    protected final TCredentials auths;

    public MetaDataStateStore(Instance instance, TCredentials auths, CurrentState state) {
        this.instance = instance;
        this.state = state;
        this.auths = auths;
    }

    public MetaDataStateStore() {
        this(HdfsZooInstance.getInstance(), SecurityConstants.getSystemCredentials(), null);
    }

    @Override
    public Iterator<TabletLocationState> iterator() {
        return new MetaDataTableScanner(this.instance, this.auths, Constants.NON_ROOT_METADATA_KEYSPACE, this.state);
    }

    @Override
    public void setLocations(Collection<Assignment> assignments) throws DistributedStoreException {
        BatchWriter writer = this.createBatchWriter();
        try {
            for (Assignment assignment : assignments) {
                Mutation m = new Mutation(assignment.tablet.getMetadataEntry());
                Text cq = assignment.server.asColumnQualifier();
                m.put(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY, cq, assignment.server.asMutationValue());
                m.putDelete(Constants.METADATA_FUTURE_LOCATION_COLUMN_FAMILY, cq);
                writer.addMutation(m);
            }
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (MutationsRejectedException e) {
                throw new DistributedStoreException((Exception)((Object)e));
            }
        }
    }

    BatchWriter createBatchWriter() {
        try {
            return this.instance.getConnector(this.auths.getPrincipal(), CredentialHelper.extractToken((TCredentials)this.auths)).createBatchWriter("!METADATA", new BatchWriterConfig().setMaxMemory(0xC800000L).setMaxLatency(1000L, TimeUnit.MILLISECONDS).setMaxWriteThreads(4));
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setFutureLocations(Collection<Assignment> assignments) throws DistributedStoreException {
        BatchWriter writer = this.createBatchWriter();
        try {
            for (Assignment assignment : assignments) {
                Mutation m = new Mutation(assignment.tablet.getMetadataEntry());
                m.put(Constants.METADATA_FUTURE_LOCATION_COLUMN_FAMILY, assignment.server.asColumnQualifier(), assignment.server.asMutationValue());
                writer.addMutation(m);
            }
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (MutationsRejectedException e) {
                throw new DistributedStoreException((Exception)((Object)e));
            }
        }
    }

    @Override
    public void unassign(Collection<TabletLocationState> tablets) throws DistributedStoreException {
        BatchWriter writer = this.createBatchWriter();
        try {
            for (TabletLocationState tls : tablets) {
                Mutation m = new Mutation(tls.extent.getMetadataEntry());
                if (tls.current != null) {
                    m.putDelete(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY, tls.current.asColumnQualifier());
                }
                if (tls.future != null) {
                    m.putDelete(Constants.METADATA_FUTURE_LOCATION_COLUMN_FAMILY, tls.future.asColumnQualifier());
                }
                writer.addMutation(m);
            }
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (MutationsRejectedException e) {
                throw new DistributedStoreException((Exception)((Object)e));
            }
        }
    }

    @Override
    public String name() {
        return "Normal Tablets";
    }
}

