/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.server.master.state.MergeState;
import org.apache.hadoop.io.Writable;

public class MergeInfo
implements Writable {
    MergeState state = MergeState.NONE;
    KeyExtent range;
    Operation operation = Operation.MERGE;

    public MergeInfo() {
    }

    public void readFields(DataInput in) throws IOException {
        this.range = new KeyExtent();
        this.range.readFields(in);
        this.state = MergeState.values()[in.readInt()];
        this.operation = Operation.values()[in.readInt()];
    }

    public void write(DataOutput out) throws IOException {
        this.range.write(out);
        out.writeInt(this.state.ordinal());
        out.writeInt(this.operation.ordinal());
    }

    public MergeInfo(KeyExtent range, Operation op) {
        this.range = range;
        this.operation = op;
    }

    public MergeState getState() {
        return this.state;
    }

    public KeyExtent getRange() {
        return this.range;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setState(MergeState state) {
        this.state = state;
    }

    public boolean isDelete() {
        return this.operation.equals((Object)Operation.DELETE);
    }

    public boolean needsToBeChopped(KeyExtent extent) {
        if (!extent.getTableId().equals((Object)this.range.getTableId())) {
            return false;
        }
        if (this.isDelete()) {
            return extent.getPrevEndRow() != null && extent.getPrevEndRow().equals((Object)this.range.getEndRow());
        }
        return this.range.overlaps(extent);
    }

    public boolean overlaps(KeyExtent extent) {
        boolean result = this.range.overlaps(extent);
        if (!result && this.needsToBeChopped(extent)) {
            return true;
        }
        return result;
    }

    public String toString() {
        if (!this.state.equals((Object)MergeState.NONE)) {
            return "Merge " + this.operation.toString() + " of " + this.range + " State: " + (Object)((Object)this.state);
        }
        return "No Merge in progress";
    }

    public static enum Operation {
        MERGE,
        DELETE;

    }
}

