/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.Version;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.zookeeper.KeeperException;

public class Accumulo {
    private static final Logger log = Logger.getLogger(Accumulo.class);

    public static synchronized void updateAccumuloVersion(FileSystem fs) {
        try {
            if (Accumulo.getAccumuloPersistentVersion(fs) == 4) {
                fs.create(new Path(ServerConstants.getDataVersionLocation() + "/" + 5));
                fs.delete(new Path(ServerConstants.getDataVersionLocation() + "/" + 4), false);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to set accumulo version: an error occurred.", e);
        }
    }

    public static synchronized int getAccumuloPersistentVersion(FileSystem fs) {
        try {
            FileStatus[] files = fs.listStatus(ServerConstants.getDataVersionLocation());
            int dataVersion = files == null || files.length == 0 ? -1 : Integer.parseInt(files[0].getPath().getName());
            return dataVersion;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read accumulo version: an error occurred.", e);
        }
    }

    public static void enableTracing(String address, String application) {
        try {
            DistributedTrace.enable((Instance)HdfsZooInstance.getInstance(), (ZooReader)ZooReaderWriter.getInstance(), (String)application, (String)address);
        }
        catch (Exception ex) {
            log.error((Object)"creating remote sink for trace spans", (Throwable)ex);
        }
    }

    public static void init(FileSystem fs, ServerConfiguration config, String application) throws UnknownHostException {
        System.setProperty("org.apache.accumulo.core.application", application);
        if (System.getenv("ACCUMULO_LOG_DIR") != null) {
            System.setProperty("org.apache.accumulo.core.dir.log", System.getenv("ACCUMULO_LOG_DIR"));
        } else {
            System.setProperty("org.apache.accumulo.core.dir.log", System.getenv("ACCUMULO_HOME") + "/logs/");
        }
        String localhost = InetAddress.getLocalHost().getHostName();
        System.setProperty("org.apache.accumulo.core.ip.localhost.hostname", localhost);
        if (System.getenv("ACCUMULO_LOG_HOST") != null) {
            System.setProperty("org.apache.accumulo.core.host.log", System.getenv("ACCUMULO_LOG_HOST"));
        } else {
            System.setProperty("org.apache.accumulo.core.host.log", localhost);
        }
        String logConfig = String.format("%s/conf/%s_logger.xml", System.getenv("ACCUMULO_HOME"), application);
        if (!new File(logConfig).exists()) {
            logConfig = String.format("%s/conf/generic_logger.xml", System.getenv("ACCUMULO_HOME"));
        }
        LogLog.setQuietMode((boolean)true);
        DOMConfigurator.configureAndWatch((String)logConfig, (long)5000L);
        log.info((Object)(application + " starting"));
        log.info((Object)("Instance " + config.getInstance().getInstanceID()));
        int dataVersion = Accumulo.getAccumuloPersistentVersion(fs);
        log.info((Object)("Data Version " + dataVersion));
        Accumulo.waitForZookeeperAndHdfs(fs);
        Version codeVersion = new Version("1.5.0");
        if (dataVersion != 5 && dataVersion != 4) {
            throw new RuntimeException("This version of accumulo (" + codeVersion + ") is not compatible with files stored using data version " + dataVersion);
        }
        TreeMap sortedProps = new TreeMap();
        for (Map.Entry entry : config.getConfiguration()) {
            sortedProps.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : sortedProps.entrySet()) {
            if (((String)entry.getKey()).toLowerCase().contains("password") || ((String)entry.getKey()).toLowerCase().contains("secret") || ((String)entry.getKey()).startsWith(Property.TRACE_TOKEN_PROPERTY_PREFIX.getKey())) {
                log.info((Object)((String)entry.getKey() + " = <hidden>"));
                continue;
            }
            log.info((Object)((String)entry.getKey() + " = " + (String)entry.getValue()));
        }
        Accumulo.monitorSwappiness();
    }

    public static void monitorSwappiness() {
        SimpleTimer.getInstance().schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block6: {
                    try {
                        String procFile = "/proc/sys/vm/swappiness";
                        File swappiness = new File(procFile);
                        if (!swappiness.exists() || !swappiness.canRead()) break block6;
                        FileInputStream is = new FileInputStream(procFile);
                        try {
                            byte[] buffer = new byte[10];
                            int bytes = ((InputStream)is).read(buffer);
                            String setting = new String(buffer, 0, bytes);
                            setting = setting.trim();
                            if (bytes > 0 && Integer.parseInt(setting) > 10) {
                                log.warn((Object)("System swappiness setting is greater than ten (" + setting + ") which can cause time-sensitive operations to be delayed. " + " Accumulo is time sensitive because it needs to maintain distributed lock agreement."));
                            }
                        }
                        finally {
                            ((InputStream)is).close();
                        }
                    }
                    catch (Throwable t) {
                        log.error((Object)t, t);
                    }
                }
            }
        }, 1000L, 600000L);
    }

    public static String getLocalAddress(String[] args) throws UnknownHostException {
        InetAddress result = InetAddress.getLocalHost();
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals("-a") && !args[i].equals("--address")) continue;
            result = InetAddress.getByName(args[i + 1]);
            log.debug((Object)("Local address is: " + args[i + 1] + " (" + result.toString() + ")"));
            break;
        }
        return result.getHostName();
    }

    public static void waitForZookeeperAndHdfs(FileSystem fs) {
        log.info((Object)"Attempting to talk to zookeeper");
        while (true) {
            try {
                ZooReaderWriter.getInstance().getChildren("/accumulo");
            }
            catch (InterruptedException e) {
                continue;
            }
            catch (KeeperException ex) {
                log.info((Object)"Waiting for accumulo to be initialized");
                UtilWaitThread.sleep((long)1000L);
                continue;
            }
            break;
        }
        log.info((Object)"Zookeeper connected and initialized, attemping to talk to HDFS");
        long sleep = 1000L;
        while (true) {
            try {
                if (!Accumulo.isInSafeMode(fs)) break;
                log.warn((Object)"Waiting for the NameNode to leave safemode");
            }
            catch (IOException ex) {
                log.warn((Object)"Unable to connect to HDFS");
            }
            log.info((Object)("Sleeping " + (double)sleep / 1000.0 + " seconds"));
            UtilWaitThread.sleep((long)sleep);
            sleep = Math.min(60000L, sleep * 2L);
        }
        log.info((Object)"Connected to HDFS");
    }

    private static boolean isInSafeMode(FileSystem fs) throws IOException {
        Class<?> safeModeAction;
        if (!(fs instanceof DistributedFileSystem)) {
            return false;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.get((Configuration)CachedConfiguration.getInstance());
        try {
            safeModeAction = Class.forName("org.apache.hadoop.hdfs.protocol.HdfsConstants$SafeModeAction");
        }
        catch (ClassNotFoundException ex) {
            try {
                safeModeAction = Class.forName("org.apache.hadoop.hdfs.protocol.FSConstants$SafeModeAction");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot figure out the right class for Constants");
            }
        }
        Object get = null;
        for (Object obj : safeModeAction.getEnumConstants()) {
            if (!obj.toString().equals("SAFEMODE_GET")) continue;
            get = obj;
        }
        if (get == null) {
            throw new RuntimeException("cannot find SAFEMODE_GET");
        }
        try {
            Method setSafeMode = dfs.getClass().getMethod("setSafeMode", safeModeAction);
            return (Boolean)setSafeMode.invoke((Object)dfs, get);
        }
        catch (Exception ex) {
            throw new RuntimeException("cannot find method setSafeMode");
        }
    }
}

