/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.hadoop.test.GenericTestUtils;

public class JarFinder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyToZipStream(File file, ZipEntry entry, ZipOutputStream zos) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            zos.putNextEntry(entry);
            byte[] arr = new byte[4096];
            int read = ((InputStream)is).read(arr);
            while (read > -1) {
                zos.write(arr, 0, read);
                read = ((InputStream)is).read(arr);
            }
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            finally {
                zos.closeEntry();
            }
        }
    }

    public static void jarDir(File dir, String relativePath, ZipOutputStream zos) throws IOException {
        Preconditions.checkNotNull((Object)relativePath, (Object)"relativePath");
        Preconditions.checkNotNull((Object)zos, (Object)"zos");
        File manifestFile = new File(dir, "META-INF/MANIFEST.MF");
        ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
        if (!manifestFile.exists()) {
            zos.putNextEntry(manifestEntry);
            new Manifest().write(new BufferedOutputStream(zos));
            zos.closeEntry();
        } else {
            JarFinder.copyToZipStream(manifestFile, manifestEntry, zos);
        }
        zos.closeEntry();
        JarFinder.zipDir(dir, relativePath, zos, true);
        zos.close();
    }

    private static void zipDir(File dir, String relativePath, ZipOutputStream zos, boolean start) throws IOException {
        String[] dirList;
        for (String aDirList : dirList = dir.list()) {
            File f = new File(dir, aDirList);
            if (f.isHidden()) continue;
            if (f.isDirectory()) {
                if (!start) {
                    ZipEntry dirEntry = new ZipEntry(relativePath + f.getName() + "/");
                    zos.putNextEntry(dirEntry);
                    zos.closeEntry();
                }
                String filePath = f.getPath();
                File file = new File(filePath);
                JarFinder.zipDir(file, relativePath + f.getName() + "/", zos, false);
                continue;
            }
            String path = relativePath + f.getName();
            if (path.equals("META-INF/MANIFEST.MF")) continue;
            ZipEntry anEntry = new ZipEntry(path);
            JarFinder.copyToZipStream(f, anEntry, zos);
        }
    }

    private static void createJar(File dir, File jarFile) throws IOException {
        Preconditions.checkNotNull((Object)dir, (Object)"dir");
        Preconditions.checkNotNull((Object)jarFile, (Object)"jarFile");
        File jarDir = jarFile.getParentFile();
        if (!jarDir.exists() && !jarDir.mkdirs()) {
            throw new IOException(MessageFormat.format("could not create dir [{0}]", jarDir));
        }
        JarOutputStream zos = new JarOutputStream(new FileOutputStream(jarFile));
        JarFinder.jarDir(dir, "", zos);
    }

    public static String getJar(Class klass) {
        return JarFinder.getJar(klass, null);
    }

    public static String getJar(Class klass, String testSubDir) {
        Preconditions.checkNotNull((Object)klass, (Object)"klass");
        ClassLoader loader = klass.getClassLoader();
        if (loader != null) {
            String class_file = klass.getName().replaceAll("\\.", "/") + ".class";
            try {
                Enumeration<URL> itr = loader.getResources(class_file);
                while (itr.hasMoreElements()) {
                    URL url = itr.nextElement();
                    String path = url.getPath();
                    if (path.startsWith("file:")) {
                        path = path.substring("file:".length());
                    }
                    path = URLDecoder.decode(path, "UTF-8");
                    if ("jar".equals(url.getProtocol())) {
                        path = URLDecoder.decode(path, "UTF-8");
                        return path.replaceAll("!.*$", "");
                    }
                    if (!"file".equals(url.getProtocol())) continue;
                    String klassName = klass.getName();
                    klassName = klassName.replace(".", "/") + ".class";
                    path = path.substring(0, path.length() - klassName.length());
                    File baseDir = new File(path);
                    File testDir = testSubDir == null ? GenericTestUtils.getTestDir() : GenericTestUtils.getTestDir(testSubDir);
                    if (!(testDir = testDir.getAbsoluteFile()).exists()) {
                        testDir.mkdirs();
                    }
                    File tempFile = File.createTempFile("hadoop-", "", testDir);
                    File tempJar = new File(tempFile.getAbsolutePath() + ".jar");
                    JarFinder.createJar(baseDir, tempJar);
                    tempJar.deleteOnExit();
                    tempFile.deleteOnExit();
                    return tempJar.getAbsolutePath();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static File makeClassLoaderTestJar(Class<?> target, File rootDir, String jarName, int buffSize, String ... clsNames) throws IOException {
        File jarFile = new File(rootDir, jarName);
        JarOutputStream jstream = new JarOutputStream(new FileOutputStream(jarFile));
        for (String clsName : clsNames) {
            int count;
            String name = clsName.replace('.', '/') + ".class";
            InputStream entryInputStream = target.getResourceAsStream("/" + name);
            ZipEntry entry = new ZipEntry(name);
            jstream.putNextEntry(entry);
            BufferedInputStream bufInputStream = new BufferedInputStream(entryInputStream, buffSize);
            byte[] data = new byte[buffSize];
            while ((count = bufInputStream.read(data, 0, buffSize)) != -1) {
                jstream.write(data, 0, count);
            }
            jstream.closeEntry();
        }
        jstream.close();
        return jarFile;
    }
}

