/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.impl.TestMetricsConfig;
import org.apache.hadoop.metrics2.impl.TestMetricsSystemImpl;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.sink.ganglia.AbstractGangliaSink;
import org.apache.hadoop.metrics2.sink.ganglia.GangliaMetricsTestHelper;
import org.apache.hadoop.metrics2.sink.ganglia.GangliaSink30;
import org.apache.hadoop.metrics2.sink.ganglia.GangliaSink31;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGangliaMetrics {
    public static final Logger LOG = LoggerFactory.getLogger(TestMetricsSystemImpl.class);
    private String testNamePrefix = "gangliametrics";
    private final String[] expectedMetrics = new String[]{this.testNamePrefix + ".s1rec.C1", this.testNamePrefix + ".s1rec.G1", this.testNamePrefix + ".s1rec.Xxx", this.testNamePrefix + ".s1rec.Yyy", this.testNamePrefix + ".s1rec.S1NumOps", this.testNamePrefix + ".s1rec.S1AvgTime"};

    @Test
    public void testTagsForPrefix() throws Exception {
        ConfigBuilder cb = new ConfigBuilder().add(this.testNamePrefix + ".sink.ganglia.tagsForPrefix.all", "*").add(this.testNamePrefix + ".sink.ganglia.tagsForPrefix.some", "NumActiveSinks, NumActiveSources").add(this.testNamePrefix + ".sink.ganglia.tagsForPrefix.none", "");
        GangliaSink30 sink = new GangliaSink30();
        sink.init(cb.subset(this.testNamePrefix + ".sink.ganglia"));
        ArrayList<MetricsTag> tags = new ArrayList<MetricsTag>();
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Context, "all"));
        tags.add(new MetricsTag((MetricsInfo)MsInfo.NumActiveSources, "foo"));
        tags.add(new MetricsTag((MetricsInfo)MsInfo.NumActiveSinks, "bar"));
        tags.add(new MetricsTag((MetricsInfo)MsInfo.NumAllSinks, "haa"));
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Hostname, "host"));
        HashSet metrics = new HashSet();
        MetricsRecordImpl record = new MetricsRecordImpl((MetricsInfo)MsInfo.Context, 1L, tags, metrics);
        StringBuilder sb = new StringBuilder();
        sink.appendPrefix((MetricsRecord)record, sb);
        Assert.assertEquals((Object)".NumActiveSources=foo.NumActiveSinks=bar.NumAllSinks=haa", (Object)sb.toString());
        tags.set(0, new MetricsTag((MetricsInfo)MsInfo.Context, "some"));
        sb = new StringBuilder();
        sink.appendPrefix((MetricsRecord)record, sb);
        Assert.assertEquals((Object)".NumActiveSources=foo.NumActiveSinks=bar", (Object)sb.toString());
        tags.set(0, new MetricsTag((MetricsInfo)MsInfo.Context, "none"));
        sb = new StringBuilder();
        sink.appendPrefix((MetricsRecord)record, sb);
        Assert.assertEquals((Object)"", (Object)sb.toString());
        tags.set(0, new MetricsTag((MetricsInfo)MsInfo.Context, "nada"));
        sb = new StringBuilder();
        sink.appendPrefix((MetricsRecord)record, sb);
        Assert.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testGangliaMetrics2() throws Exception {
        ConfigBuilder cb = new ConfigBuilder().add("*.period", 120).add(this.testNamePrefix + ".sink.gsink30.context", this.testNamePrefix).add(this.testNamePrefix + ".sink.gsink31.context", this.testNamePrefix).save(TestMetricsConfig.getTestFilename("hadoop-metrics2-" + this.testNamePrefix));
        MetricsSystemImpl ms = new MetricsSystemImpl(this.testNamePrefix);
        ms.start();
        TestSource s1 = (TestSource)ms.register("s1", "s1 desc", (Object)new TestSource("s1rec"));
        s1.c1.incr();
        s1.xxx.incr();
        s1.g1.set(2L);
        s1.yyy.incr(2L);
        s1.s1.add(0L);
        int expectedCountFromGanglia30 = this.expectedMetrics.length;
        int expectedCountFromGanglia31 = 2 * this.expectedMetrics.length;
        GangliaSink30 gsink30 = new GangliaSink30();
        gsink30.init(cb.subset(this.testNamePrefix));
        MockDatagramSocket mockds30 = new MockDatagramSocket();
        GangliaMetricsTestHelper.setDatagramSocket((AbstractGangliaSink)gsink30, mockds30);
        GangliaSink31 gsink31 = new GangliaSink31();
        gsink31.init(cb.subset(this.testNamePrefix));
        MockDatagramSocket mockds31 = new MockDatagramSocket();
        GangliaMetricsTestHelper.setDatagramSocket((AbstractGangliaSink)gsink31, mockds31);
        ms.register("gsink30", "gsink30 desc", (MetricsSink)gsink30);
        ms.register("gsink31", "gsink31 desc", (MetricsSink)gsink31);
        ms.publishMetricsNow();
        ms.stop();
        this.checkMetrics(mockds30.getCapturedSend(), expectedCountFromGanglia30);
        this.checkMetrics(mockds31.getCapturedSend(), expectedCountFromGanglia31);
    }

    private void checkMetrics(List<byte[]> bytearrlist, int expectedCount) {
        boolean[] foundMetrics = new boolean[this.expectedMetrics.length];
        block0: for (byte[] bytes : bytearrlist) {
            String binaryStr = new String(bytes, StandardCharsets.UTF_8);
            for (int index = 0; index < this.expectedMetrics.length; ++index) {
                if (binaryStr.indexOf(this.expectedMetrics[index]) < 0) continue;
                foundMetrics[index] = true;
                continue block0;
            }
        }
        for (int index = 0; index < foundMetrics.length; ++index) {
            if (foundMetrics[index]) continue;
            Assert.assertTrue((String)("Missing metrics: " + this.expectedMetrics[index]), (boolean)false);
        }
        Assert.assertEquals((String)"Mismatch in record count: ", (long)expectedCount, (long)bytearrlist.size());
    }

    private class MockDatagramSocket
    extends DatagramSocket {
        private List<byte[]> capture = new ArrayList<byte[]>();

        @Override
        public synchronized void send(DatagramPacket p) throws IOException {
            byte[] bytes = new byte[p.getLength()];
            System.arraycopy(p.getData(), p.getOffset(), bytes, 0, p.getLength());
            this.capture.add(bytes);
        }

        synchronized List<byte[]> getCapturedSend() {
            return this.capture;
        }
    }

    @Metrics(context="gangliametrics")
    private static class TestSource {
        @Metric(value={"C1 desc"})
        MutableCounterLong c1;
        @Metric(value={"XXX desc"})
        MutableCounterLong xxx;
        @Metric(value={"G1 desc"})
        MutableGaugeLong g1;
        @Metric(value={"YYY desc"})
        MutableGaugeLong yyy;
        @Metric
        MutableRate s1;
        final MetricsRegistry registry;

        TestSource(String recName) {
            this.registry = new MetricsRegistry(recName);
        }
    }
}

