/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Random;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.TestWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestMD5Hash {
    private static final Random RANDOM = new Random();
    protected static byte[] D00 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static byte[] DFF = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public static MD5Hash getTestHash() throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] buffer = new byte[1024];
        RANDOM.nextBytes(buffer);
        digest.update(buffer);
        return new MD5Hash(digest.digest());
    }

    @Test
    public void testMD5Hash() throws Exception {
        MD5Hash md5Hash = TestMD5Hash.getTestHash();
        final MD5Hash md5Hash00 = new MD5Hash(D00);
        final MD5Hash md5HashFF = new MD5Hash(DFF);
        MD5Hash orderedHash = new MD5Hash(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16});
        MD5Hash backwardHash = new MD5Hash(new byte[]{-1, -2, -3, -4, -5, -6, -7, -8, -9, -10, -11, -12, -13, -14, -15, -16});
        MD5Hash closeHash1 = new MD5Hash(new byte[]{-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        MD5Hash closeHash2 = new MD5Hash(new byte[]{-1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        TestWritable.testWritable((Writable)md5Hash);
        TestWritable.testWritable((Writable)md5Hash00);
        TestWritable.testWritable((Writable)md5HashFF);
        Assert.assertEquals((Object)md5Hash, (Object)md5Hash);
        Assert.assertEquals((Object)md5Hash00, (Object)md5Hash00);
        Assert.assertEquals((Object)md5HashFF, (Object)md5HashFF);
        Assert.assertTrue((md5Hash.compareTo(md5Hash) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((md5Hash00.compareTo(md5Hash) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((md5HashFF.compareTo(md5Hash) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)md5Hash, (Object)new MD5Hash(md5Hash.toString()));
        Assert.assertEquals((Object)md5Hash00, (Object)new MD5Hash(md5Hash00.toString()));
        Assert.assertEquals((Object)md5HashFF, (Object)new MD5Hash(md5HashFF.toString()));
        Assert.assertEquals((long)16909060L, (long)orderedHash.quarterDigest());
        Assert.assertEquals((long)-66052L, (long)backwardHash.quarterDigest());
        Assert.assertEquals((long)72623859790382856L, (long)orderedHash.halfDigest());
        Assert.assertEquals((long)-283686952306184L, (long)backwardHash.halfDigest());
        Assert.assertTrue((String)"hash collision", (closeHash1.hashCode() != closeHash2.hashCode() ? 1 : 0) != 0);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < 100; ++i) {
                    MD5Hash hash = new MD5Hash(DFF);
                    Assert.assertEquals((Object)hash, (Object)md5HashFF);
                }
            }
        };
        Thread t2 = new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < 100; ++i) {
                    MD5Hash hash = new MD5Hash(D00);
                    Assert.assertEquals((Object)hash, (Object)md5Hash00);
                }
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    @Test
    public void testFactoryReturnsClearedHashes() throws IOException {
        ByteArrayInputStream failingStream = new ByteArrayInputStream("xxxx".getBytes()){

            @Override
            public synchronized int read(byte[] b) throws IOException {
                int ret = super.read(b);
                if (ret <= 0) {
                    throw new IOException("Injected fault");
                }
                return ret;
            }
        };
        String TEST_STRING = "hello";
        MD5Hash expectedHash = MD5Hash.digest((String)"hello");
        Assert.assertEquals((Object)expectedHash, (Object)MD5Hash.digest((String)"hello"));
        try {
            MD5Hash.digest((InputStream)failingStream);
            Assert.fail((String)"didnt throw!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((Object)expectedHash, (Object)MD5Hash.digest((String)"hello"));
    }
}

