/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.local.LocalConfigKeys;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.AclUtil;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ChRootedFs;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.Constants;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.hadoop.fs.viewfs.NotInMountpointException;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFs;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class ViewFsBaseTest {
    FileContext fcView;
    FileContext fcTarget;
    Path targetTestRoot;
    Configuration conf;
    FileContext xfcViewWithAuthority;
    URI schemeWithAuthority;
    final FileContextTestHelper fileContextTestHelper = this.createFileContextHelper();
    protected static boolean SupportsBlocks = false;

    protected FileContextTestHelper createFileContextHelper() {
        return new FileContextTestHelper();
    }

    @Before
    public void setUp() throws Exception {
        this.initializeTargetTestRoot();
        this.fcTarget.mkdir(new Path(this.targetTestRoot, "user"), FileContext.DEFAULT_PERM, true);
        this.fcTarget.mkdir(new Path(this.targetTestRoot, "data"), FileContext.DEFAULT_PERM, true);
        this.fcTarget.mkdir(new Path(this.targetTestRoot, "dir2"), FileContext.DEFAULT_PERM, true);
        this.fcTarget.mkdir(new Path(this.targetTestRoot, "dir3"), FileContext.DEFAULT_PERM, true);
        FileContextTestHelper.createFile(this.fcTarget, new Path(this.targetTestRoot, "aFile"));
        this.conf = new Configuration();
        ConfigUtil.addLink((Configuration)this.conf, (String)"/targetRoot", (URI)this.targetTestRoot.toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/user", (URI)new Path(this.targetTestRoot, "user").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/user2", (URI)new Path(this.targetTestRoot, "user").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/data", (URI)new Path(this.targetTestRoot, "data").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/internalDir/linkToDir2", (URI)new Path(this.targetTestRoot, "dir2").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/internalDir/internalDir2/linkToDir3", (URI)new Path(this.targetTestRoot, "dir3").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/danglingLink", (URI)new Path(this.targetTestRoot, "missingTarget").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/linkToAFile", (URI)new Path(this.targetTestRoot, "aFile").toUri());
        this.fcView = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)this.conf);
    }

    void initializeTargetTestRoot() throws IOException {
        this.targetTestRoot = this.fileContextTestHelper.getAbsoluteTestRootPath(this.fcTarget);
        this.fcTarget.delete(this.targetTestRoot, true);
        this.fcTarget.mkdir(this.targetTestRoot, FileContext.DEFAULT_PERM, true);
    }

    @After
    public void tearDown() throws Exception {
        this.fcTarget.delete(this.fileContextTestHelper.getTestRootPath(this.fcTarget), true);
    }

    @Test
    public void testGetMountPoints() {
        ViewFs viewfs = (ViewFs)this.fcView.getDefaultFileSystem();
        ViewFs.MountPoint[] mountPoints = viewfs.getMountPoints();
        Assert.assertEquals((long)8L, (long)mountPoints.length);
    }

    int getExpectedDelegationTokenCount() {
        return 0;
    }

    @Test
    public void testGetDelegationTokens() throws IOException {
        List delTokens = this.fcView.getDelegationTokens(new Path("/"), "sanjay");
        Assert.assertEquals((long)this.getExpectedDelegationTokenCount(), (long)delTokens.size());
    }

    @Test
    public void testBasicPaths() {
        Assert.assertEquals((Object)FsConstants.VIEWFS_URI, (Object)this.fcView.getDefaultFileSystem().getUri());
        Assert.assertEquals((Object)this.fcView.makeQualified(new Path("/user/" + System.getProperty("user.name"))), (Object)this.fcView.getWorkingDirectory());
        Assert.assertEquals((Object)this.fcView.makeQualified(new Path("/user/" + System.getProperty("user.name"))), (Object)this.fcView.getHomeDirectory());
        Assert.assertEquals((Object)new Path("/foo/bar").makeQualified(FsConstants.VIEWFS_URI, null), (Object)this.fcView.makeQualified(new Path("/foo/bar")));
    }

    @Test
    public void testOperationsThroughMountLinks() throws IOException {
        this.fileContextTestHelper.createFileNonRecursive(this.fcView, "/user/foo");
        Assert.assertTrue((String)"Create file should be file", (boolean)FileContextTestHelper.isFile(this.fcView, new Path("/user/foo")));
        Assert.assertTrue((String)"Target of created file should be type file", (boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.targetTestRoot, "user/foo")));
        Assert.assertTrue((String)"Delete should succeed", (boolean)this.fcView.delete(new Path("/user/foo"), false));
        Assert.assertFalse((String)"File should not exist after delete", (boolean)FileContextTestHelper.exists(this.fcView, new Path("/user/foo")));
        Assert.assertFalse((String)"Target File should not exist after delete", (boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.targetTestRoot, "user/foo")));
        this.fileContextTestHelper.createFileNonRecursive(this.fcView, "/internalDir/linkToDir2/foo");
        Assert.assertTrue((String)"Created file should be type file", (boolean)FileContextTestHelper.isFile(this.fcView, new Path("/internalDir/linkToDir2/foo")));
        Assert.assertTrue((String)"Target of created file should be type file", (boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.targetTestRoot, "dir2/foo")));
        Assert.assertTrue((String)"Delete should suceed", (boolean)this.fcView.delete(new Path("/internalDir/linkToDir2/foo"), false));
        Assert.assertFalse((String)"File should not exist after deletion", (boolean)FileContextTestHelper.exists(this.fcView, new Path("/internalDir/linkToDir2/foo")));
        Assert.assertFalse((String)"Target should not exist after deletion", (boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.targetTestRoot, "dir2/foo")));
        this.fileContextTestHelper.createFileNonRecursive(this.fcView, "/internalDir/internalDir2/linkToDir3/foo");
        Assert.assertTrue((String)"Created file should be of type file", (boolean)FileContextTestHelper.isFile(this.fcView, new Path("/internalDir/internalDir2/linkToDir3/foo")));
        Assert.assertTrue((String)"Target of created file should also be type file", (boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.targetTestRoot, "dir3/foo")));
        this.fileContextTestHelper.createFile(this.fcView, "/internalDir/linkToDir2/missingDir/miss2/foo");
        Assert.assertTrue((String)"Created file should be of type file", (boolean)FileContextTestHelper.isFile(this.fcView, new Path("/internalDir/linkToDir2/missingDir/miss2/foo")));
        Assert.assertTrue((String)"Target of created file should also be type file", (boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.targetTestRoot, "dir2/missingDir/miss2/foo")));
        Assert.assertTrue((String)"Delete should succeed", (boolean)this.fcView.delete(new Path("/internalDir/internalDir2/linkToDir3/foo"), false));
        Assert.assertFalse((String)"Deleted File should not exist", (boolean)FileContextTestHelper.exists(this.fcView, new Path("/internalDir/internalDir2/linkToDir3/foo")));
        Assert.assertFalse((String)"Target of deleted file should not exist", (boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.targetTestRoot, "dir3/foo")));
        this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/user/dirX"), FileContext.DEFAULT_PERM, false);
        Assert.assertTrue((String)"New dir should be type dir", (boolean)FileContextTestHelper.isDir(this.fcView, new Path("/user/dirX")));
        Assert.assertTrue((String)"Target of new dir should be of type dir", (boolean)FileContextTestHelper.isDir(this.fcTarget, new Path(this.targetTestRoot, "user/dirX")));
        this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/user/dirX/dirY"), FileContext.DEFAULT_PERM, false);
        Assert.assertTrue((String)"New dir should be type dir", (boolean)FileContextTestHelper.isDir(this.fcView, new Path("/user/dirX/dirY")));
        Assert.assertTrue((String)"Target of new dir should be of type dir", (boolean)FileContextTestHelper.isDir(this.fcTarget, new Path(this.targetTestRoot, "user/dirX/dirY")));
        Assert.assertTrue((String)"Delete should succeed", (boolean)this.fcView.delete(new Path("/user/dirX/dirY"), false));
        Assert.assertFalse((String)"Deleted File should not exist", (boolean)FileContextTestHelper.exists(this.fcView, new Path("/user/dirX/dirY")));
        Assert.assertFalse((String)"Deleted Target should not exist", (boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.targetTestRoot, "user/dirX/dirY")));
        Assert.assertTrue((String)"Delete should succeed", (boolean)this.fcView.delete(new Path("/user/dirX"), false));
        Assert.assertFalse((String)"Deleted File should not exist", (boolean)FileContextTestHelper.exists(this.fcView, new Path("/user/dirX")));
        Assert.assertFalse((String)"Deleted Target should not exist", (boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.targetTestRoot, "user/dirX")));
        this.fileContextTestHelper.createFile(this.fcView, "/user/foo");
        this.fcView.rename(new Path("/user/foo"), new Path("/user/fooBar"), new Options.Rename[0]);
        Assert.assertFalse((String)"Renamed src should not exist", (boolean)FileContextTestHelper.exists(this.fcView, new Path("/user/foo")));
        Assert.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.targetTestRoot, "user/foo")));
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(this.fcView, this.fileContextTestHelper.getTestRootPath(this.fcView, "/user/fooBar")));
        Assert.assertTrue((boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.targetTestRoot, "user/fooBar")));
        this.fcView.mkdir(new Path("/user/dirFoo"), FileContext.DEFAULT_PERM, false);
        this.fcView.rename(new Path("/user/dirFoo"), new Path("/user/dirFooBar"), new Options.Rename[0]);
        Assert.assertFalse((String)"Renamed src should not exist", (boolean)FileContextTestHelper.exists(this.fcView, new Path("/user/dirFoo")));
        Assert.assertFalse((String)"Renamed src should not exist in target", (boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.targetTestRoot, "user/dirFoo")));
        Assert.assertTrue((String)"Renamed dest should  exist as dir", (boolean)FileContextTestHelper.isDir(this.fcView, this.fileContextTestHelper.getTestRootPath(this.fcView, "/user/dirFooBar")));
        Assert.assertTrue((String)"Renamed dest should  exist as dir in target", (boolean)FileContextTestHelper.isDir(this.fcTarget, new Path(this.targetTestRoot, "user/dirFooBar")));
        this.fcView.mkdir(new Path("/targetRoot/dirFoo"), FileContext.DEFAULT_PERM, false);
        Assert.assertTrue((boolean)FileContextTestHelper.exists(this.fcView, new Path("/targetRoot/dirFoo")));
        boolean dirFooPresent = false;
        RemoteIterator dirContents = this.fcView.listStatus(new Path("/targetRoot/"));
        while (dirContents.hasNext()) {
            FileStatus fileStatus = (FileStatus)dirContents.next();
            if (!fileStatus.getPath().getName().equals("dirFoo")) continue;
            dirFooPresent = true;
        }
        Assert.assertTrue((boolean)dirFooPresent);
        RemoteIterator dirLocatedContents = this.fcView.listLocatedStatus(new Path("/targetRoot/"));
        dirFooPresent = false;
        while (dirLocatedContents.hasNext()) {
            FileStatus fileStatus = (FileStatus)dirLocatedContents.next();
            if (!fileStatus.getPath().getName().equals("dirFoo")) continue;
            dirFooPresent = true;
        }
        Assert.assertTrue((boolean)dirFooPresent);
    }

    @Test
    public void testRenameAcrossMounts1() throws IOException {
        this.fileContextTestHelper.createFile(this.fcView, "/user/foo");
        try {
            this.fcView.rename(new Path("/user/foo"), new Path("/user2/fooBarBar"), new Options.Rename[0]);
            ContractTestUtils.fail((String)"IOException is not thrown on rename operation");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Renames across Mount points not supported", e);
        }
    }

    @Test
    public void testRenameAcrossMounts2() throws IOException {
        this.fileContextTestHelper.createFile(this.fcView, "/user/foo");
        try {
            this.fcView.rename(new Path("/user/foo"), new Path("/data/fooBar"), new Options.Rename[0]);
            ContractTestUtils.fail((String)"IOException is not thrown on rename operation");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Renames across Mount points not supported", e);
        }
    }

    @Test
    public void testRenameAcrossMounts3() throws IOException {
        Configuration conf2 = new Configuration(this.conf);
        conf2.set("fs.viewfs.rename.strategy", ViewFileSystem.RenameStrategy.SAME_TARGET_URI_ACROSS_MOUNTPOINT.toString());
        FileContext fcView2 = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)conf2);
        String user1Path = "/user/foo";
        this.fileContextTestHelper.createFile(fcView2, user1Path);
        String user2Path = "/user2/fooBarBar";
        Path user2Dst = new Path(user2Path);
        fcView2.rename(new Path(user1Path), user2Dst, new Options.Rename[0]);
        ContractTestUtils.assertPathDoesNotExist(fcView2, "src should not exist after rename", new Path(user1Path));
        ContractTestUtils.assertPathDoesNotExist(this.fcTarget, "src should not exist after rename", new Path(this.targetTestRoot, "user/foo"));
        ContractTestUtils.assertIsFile(fcView2, this.fileContextTestHelper.getTestRootPath(fcView2, user2Path));
        ContractTestUtils.assertIsFile(this.fcTarget, new Path(this.targetTestRoot, "user/fooBarBar"));
    }

    @Test
    public void testRenameAcrossMounts4() throws IOException {
        Configuration conf2 = new Configuration(this.conf);
        conf2.set("fs.viewfs.rename.strategy", ViewFileSystem.RenameStrategy.SAME_FILESYSTEM_ACROSS_MOUNTPOINT.toString());
        FileContext fcView2 = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)conf2);
        String userPath = "/user/foo";
        this.fileContextTestHelper.createFile(fcView2, userPath);
        String anotherMountPath = "/data/fooBar";
        Path anotherDst = new Path(anotherMountPath);
        fcView2.rename(new Path(userPath), anotherDst, new Options.Rename[0]);
        ContractTestUtils.assertPathDoesNotExist(fcView2, "src should not exist after rename", new Path(userPath));
        ContractTestUtils.assertPathDoesNotExist(this.fcTarget, "src should not exist after rename", new Path(this.targetTestRoot, "user/foo"));
        ContractTestUtils.assertIsFile(fcView2, this.fileContextTestHelper.getTestRootPath(fcView2, anotherMountPath));
        ContractTestUtils.assertIsFile(fcView2, new Path(this.targetTestRoot, "data/fooBar"));
    }

    @Test
    public void testGetBlockLocations() throws IOException {
        Path targetFilePath = new Path(this.targetTestRoot, "data/largeFile");
        FileContextTestHelper.createFile(this.fcTarget, targetFilePath, 10, 1024);
        Path viewFilePath = new Path("/data/largeFile");
        FileContextTestHelper.checkFileStatus(this.fcView, viewFilePath.toString(), FileContextTestHelper.fileType.isFile);
        BlockLocation[] viewBL = this.fcView.getFileBlockLocations(viewFilePath, 0L, 10340L);
        Assert.assertEquals((long)(SupportsBlocks ? 10L : 1L), (long)viewBL.length);
        BlockLocation[] targetBL = this.fcTarget.getFileBlockLocations(targetFilePath, 0L, 10340L);
        this.compareBLs(viewBL, targetBL);
        this.fcView.getFileBlockLocations(viewFilePath, 0L, 10340L);
        targetBL = this.fcTarget.getFileBlockLocations(targetFilePath, 0L, 10340L);
        this.compareBLs(viewBL, targetBL);
    }

    void compareBLs(BlockLocation[] viewBL, BlockLocation[] targetBL) {
        Assert.assertEquals((long)targetBL.length, (long)viewBL.length);
        int i = 0;
        for (BlockLocation vbl : viewBL) {
            Assert.assertEquals((Object)vbl.toString(), (Object)targetBL[i].toString());
            Assert.assertEquals((long)targetBL[i].getOffset(), (long)vbl.getOffset());
            Assert.assertEquals((long)targetBL[i].getLength(), (long)vbl.getLength());
            ++i;
        }
    }

    @Test
    public void testListOnInternalDirsOfMountTable() throws IOException {
        FileStatus[] dirPaths = this.fcView.util().listStatus(new Path("/"));
        Assert.assertEquals((long)7L, (long)dirPaths.length);
        FileStatus fs = this.fileContextTestHelper.containsPath(this.fcView, "/user", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"A mount should appear as symlink", (boolean)fs.isSymlink());
        fs = this.fileContextTestHelper.containsPath(this.fcView, "/data", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"A mount should appear as symlink", (boolean)fs.isSymlink());
        fs = this.fileContextTestHelper.containsPath(this.fcView, "/internalDir", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"InternalDirs should appear as dir", (boolean)fs.isDirectory());
        fs = this.fileContextTestHelper.containsPath(this.fcView, "/danglingLink", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"A mount should appear as symlink", (boolean)fs.isSymlink());
        fs = this.fileContextTestHelper.containsPath(this.fcView, "/linkToAFile", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"A mount should appear as symlink", (boolean)fs.isSymlink());
        dirPaths = this.fcView.util().listStatus(new Path("/internalDir"));
        Assert.assertEquals((long)2L, (long)dirPaths.length);
        fs = this.fileContextTestHelper.containsPath(this.fcView, "/internalDir/internalDir2", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"InternalDirs should appear as dir", (boolean)fs.isDirectory());
        fs = this.fileContextTestHelper.containsPath(this.fcView, "/internalDir/linkToDir2", dirPaths);
        Assert.assertNotNull((Object)fs);
        Assert.assertTrue((String)"A mount should appear as symlink", (boolean)fs.isSymlink());
    }

    @Test(expected=FileNotFoundException.class)
    public void testFileStatusOnMountLink() throws IOException {
        Assert.assertTrue((String)"Slash should appear as dir", (boolean)this.fcView.getFileStatus(new Path("/")).isDirectory());
        FileContextTestHelper.checkFileStatus(this.fcView, "/", FileContextTestHelper.fileType.isDir);
        FileContextTestHelper.checkFileStatus(this.fcView, "/user", FileContextTestHelper.fileType.isDir);
        FileContextTestHelper.checkFileStatus(this.fcView, "/data", FileContextTestHelper.fileType.isDir);
        FileContextTestHelper.checkFileStatus(this.fcView, "/internalDir", FileContextTestHelper.fileType.isDir);
        FileContextTestHelper.checkFileStatus(this.fcView, "/internalDir/linkToDir2", FileContextTestHelper.fileType.isDir);
        FileContextTestHelper.checkFileStatus(this.fcView, "/internalDir/internalDir2/linkToDir3", FileContextTestHelper.fileType.isDir);
        FileContextTestHelper.checkFileStatus(this.fcView, "/linkToAFile", FileContextTestHelper.fileType.isFile);
        this.fcView.getFileStatus(new Path("/danglingLink"));
    }

    @Test
    public void testGetFileChecksum() throws AccessControlException, UnresolvedLinkException, IOException {
        AbstractFileSystem mockAFS = (AbstractFileSystem)Mockito.mock(AbstractFileSystem.class);
        InodeTree.ResolveResult res = new InodeTree.ResolveResult(null, (Object)mockAFS, null, new Path("someFile"));
        InodeTree fsState = (InodeTree)Mockito.mock(InodeTree.class);
        Mockito.when((Object)fsState.resolve(Matchers.anyString(), Matchers.anyBoolean())).thenReturn((Object)res);
        ViewFs vfs = (ViewFs)Mockito.mock(ViewFs.class);
        vfs.fsState = fsState;
        Mockito.when((Object)vfs.getFileChecksum(new Path("/tmp/someFile"))).thenCallRealMethod();
        vfs.getFileChecksum(new Path("/tmp/someFile"));
        ((AbstractFileSystem)Mockito.verify((Object)mockAFS)).getFileChecksum(new Path("someFile"));
    }

    @Test(expected=FileNotFoundException.class)
    public void testgetFSonDanglingLink() throws IOException {
        this.fcView.getFileStatus(new Path("/danglingLink"));
    }

    @Test(expected=FileNotFoundException.class)
    public void testgetFSonNonExistingInternalDir() throws IOException {
        this.fcView.getFileStatus(new Path("/internalDir/nonExisting"));
    }

    @Test
    public void testgetFileLinkStatus() throws IOException {
        FileContextTestHelper.checkFileLinkStatus(this.fcView, "/user", FileContextTestHelper.fileType.isSymlink);
        FileContextTestHelper.checkFileLinkStatus(this.fcView, "/data", FileContextTestHelper.fileType.isSymlink);
        FileContextTestHelper.checkFileLinkStatus(this.fcView, "/internalDir/linkToDir2", FileContextTestHelper.fileType.isSymlink);
        FileContextTestHelper.checkFileLinkStatus(this.fcView, "/internalDir/internalDir2/linkToDir3", FileContextTestHelper.fileType.isSymlink);
        FileContextTestHelper.checkFileLinkStatus(this.fcView, "/linkToAFile", FileContextTestHelper.fileType.isSymlink);
        FileContextTestHelper.checkFileLinkStatus(this.fcView, "/internalDir", FileContextTestHelper.fileType.isDir);
        FileContextTestHelper.checkFileLinkStatus(this.fcView, "/internalDir/internalDir2", FileContextTestHelper.fileType.isDir);
    }

    @Test(expected=FileNotFoundException.class)
    public void testgetFileLinkStatusonNonExistingInternalDir() throws IOException {
        this.fcView.getFileLinkStatus(new Path("/internalDir/nonExisting"));
    }

    @Test
    public void testSymlinkTarget() throws IOException {
        Assert.assertEquals((Object)this.fcView.getLinkTarget(new Path("/user")), (Object)new Path(this.targetTestRoot, "user"));
        Assert.assertEquals((Object)this.fcView.getLinkTarget(new Path("/data")), (Object)new Path(this.targetTestRoot, "data"));
        Assert.assertEquals((Object)this.fcView.getLinkTarget(new Path("/internalDir/linkToDir2")), (Object)new Path(this.targetTestRoot, "dir2"));
        Assert.assertEquals((Object)this.fcView.getLinkTarget(new Path("/internalDir/internalDir2/linkToDir3")), (Object)new Path(this.targetTestRoot, "dir3"));
        Assert.assertEquals((Object)this.fcView.getLinkTarget(new Path("/linkToAFile")), (Object)new Path(this.targetTestRoot, "aFile"));
    }

    @Test(expected=IOException.class)
    public void testgetLinkTargetOnNonLink() throws IOException {
        this.fcView.getLinkTarget(new Path("/internalDir/internalDir2"));
    }

    @Test
    public void testResolvePathInternalPaths() throws IOException {
        Assert.assertEquals((Object)new Path("/"), (Object)this.fcView.resolvePath(new Path("/")));
        Assert.assertEquals((Object)new Path("/internalDir"), (Object)this.fcView.resolvePath(new Path("/internalDir")));
    }

    @Test
    public void testResolvePathMountPoints() throws IOException {
        Assert.assertEquals((Object)new Path(this.targetTestRoot, "user"), (Object)this.fcView.resolvePath(new Path("/user")));
        Assert.assertEquals((Object)new Path(this.targetTestRoot, "data"), (Object)this.fcView.resolvePath(new Path("/data")));
        Assert.assertEquals((Object)new Path(this.targetTestRoot, "dir2"), (Object)this.fcView.resolvePath(new Path("/internalDir/linkToDir2")));
        Assert.assertEquals((Object)new Path(this.targetTestRoot, "dir3"), (Object)this.fcView.resolvePath(new Path("/internalDir/internalDir2/linkToDir3")));
    }

    @Test
    public void testResolvePathThroughMountPoints() throws IOException {
        this.fileContextTestHelper.createFile(this.fcView, "/user/foo");
        Assert.assertEquals((Object)new Path(this.targetTestRoot, "user/foo"), (Object)this.fcView.resolvePath(new Path("/user/foo")));
        this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/user/dirX"), FileContext.DEFAULT_PERM, false);
        Assert.assertEquals((Object)new Path(this.targetTestRoot, "user/dirX"), (Object)this.fcView.resolvePath(new Path("/user/dirX")));
        this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/user/dirX/dirY"), FileContext.DEFAULT_PERM, false);
        Assert.assertEquals((Object)new Path(this.targetTestRoot, "user/dirX/dirY"), (Object)this.fcView.resolvePath(new Path("/user/dirX/dirY")));
    }

    @Test(expected=FileNotFoundException.class)
    public void testResolvePathDanglingLink() throws IOException {
        this.fcView.resolvePath(new Path("/danglingLink"));
    }

    @Test(expected=FileNotFoundException.class)
    public void testResolvePathMissingThroughMountPoints() throws IOException {
        this.fcView.resolvePath(new Path("/user/nonExisting"));
    }

    @Test(expected=FileNotFoundException.class)
    public void testResolvePathMissingThroughMountPoints2() throws IOException {
        this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/user/dirX"), FileContext.DEFAULT_PERM, false);
        this.fcView.resolvePath(new Path("/user/dirX/nonExisting"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalMkdirSlash() throws IOException {
        this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/"), FileContext.DEFAULT_PERM, false);
    }

    @Test(expected=AccessControlException.class)
    public void testInternalMkdirExisting1() throws IOException {
        this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/internalDir"), FileContext.DEFAULT_PERM, false);
    }

    @Test(expected=AccessControlException.class)
    public void testInternalMkdirExisting2() throws IOException {
        this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/internalDir/linkToDir2"), FileContext.DEFAULT_PERM, false);
    }

    @Test(expected=AccessControlException.class)
    public void testInternalMkdirNew() throws IOException {
        this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/dirNew"), FileContext.DEFAULT_PERM, false);
    }

    @Test(expected=AccessControlException.class)
    public void testInternalMkdirNew2() throws IOException {
        this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/internalDir/dirNew"), FileContext.DEFAULT_PERM, false);
    }

    @Test(expected=AccessControlException.class)
    public void testInternalCreate1() throws IOException {
        this.fileContextTestHelper.createFileNonRecursive(this.fcView, "/foo");
    }

    @Test(expected=AccessControlException.class)
    public void testInternalCreate2() throws IOException {
        this.fileContextTestHelper.createFileNonRecursive(this.fcView, "/internalDir/foo");
    }

    @Test(expected=AccessControlException.class)
    public void testInternalCreateMissingDir() throws IOException {
        this.fileContextTestHelper.createFile(this.fcView, "/missingDir/foo");
    }

    @Test(expected=AccessControlException.class)
    public void testInternalCreateMissingDir2() throws IOException {
        this.fileContextTestHelper.createFile(this.fcView, "/missingDir/miss2/foo");
    }

    @Test(expected=AccessControlException.class)
    public void testInternalCreateMissingDir3() throws IOException {
        this.fileContextTestHelper.createFile(this.fcView, "/internalDir/miss2/foo");
    }

    @Test(expected=FileNotFoundException.class)
    public void testInternalDeleteNonExisting() throws IOException {
        this.fcView.delete(new Path("/NonExisting"), false);
    }

    @Test(expected=FileNotFoundException.class)
    public void testInternalDeleteNonExisting2() throws IOException {
        this.fcView.delete(new Path("/internalDir/NonExisting"), false);
    }

    @Test(expected=AccessControlException.class)
    public void testInternalDeleteExisting() throws IOException {
        this.fcView.delete(new Path("/internalDir"), false);
    }

    @Test(expected=AccessControlException.class)
    public void testInternalDeleteExisting2() throws IOException {
        Assert.assertTrue((String)"Delete of link to dir should succeed", (boolean)this.fcView.getFileStatus(new Path("/internalDir/linkToDir2")).isDirectory());
        this.fcView.delete(new Path("/internalDir/linkToDir2"), false);
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRename1() throws IOException {
        this.fcView.rename(new Path("/internalDir"), new Path("/newDir"), new Options.Rename[0]);
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRename2() throws IOException {
        Assert.assertTrue((String)"linkTODir2 should be a dir", (boolean)this.fcView.getFileStatus(new Path("/internalDir/linkToDir2")).isDirectory());
        this.fcView.rename(new Path("/internalDir/linkToDir2"), new Path("/internalDir/dir1"), new Options.Rename[0]);
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRename3() throws IOException {
        this.fcView.rename(new Path("/user"), new Path("/internalDir/linkToDir2"), new Options.Rename[0]);
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRenameToSlash() throws IOException {
        this.fcView.rename(new Path("/internalDir/linkToDir2/foo"), new Path("/"), new Options.Rename[0]);
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRenameFromSlash() throws IOException {
        this.fcView.rename(new Path("/"), new Path("/bar"), new Options.Rename[0]);
    }

    @Test(expected=AccessControlException.class)
    public void testInternalSetOwner() throws IOException {
        this.fcView.setOwner(new Path("/internalDir"), "foo", "bar");
    }

    @Test(expected=AccessControlException.class)
    public void testInternalModifyAclEntries() throws IOException {
        this.fcView.modifyAclEntries(new Path("/internalDir"), new ArrayList());
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRemoveAclEntries() throws IOException {
        this.fcView.removeAclEntries(new Path("/internalDir"), new ArrayList());
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRemoveDefaultAcl() throws IOException {
        this.fcView.removeDefaultAcl(new Path("/internalDir"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRemoveAcl() throws IOException {
        this.fcView.removeAcl(new Path("/internalDir"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalSetAcl() throws IOException {
        this.fcView.setAcl(new Path("/internalDir"), new ArrayList());
    }

    @Test
    public void testInternalGetAclStatus() throws IOException {
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        AclStatus aclStatus = this.fcView.getAclStatus(new Path("/internalDir"));
        Assert.assertEquals((Object)aclStatus.getOwner(), (Object)currentUser.getUserName());
        Assert.assertEquals((Object)aclStatus.getGroup(), (Object)currentUser.getGroupNames()[0]);
        Assert.assertEquals((Object)aclStatus.getEntries(), (Object)AclUtil.getMinimalAcl((FsPermission)Constants.PERMISSION_555));
        Assert.assertFalse((boolean)aclStatus.isStickyBit());
    }

    @Test(expected=AccessControlException.class)
    public void testInternalSetXAttr() throws IOException {
        this.fcView.setXAttr(new Path("/internalDir"), "xattrName", null);
    }

    @Test(expected=NotInMountpointException.class)
    public void testInternalGetXAttr() throws IOException {
        this.fcView.getXAttr(new Path("/internalDir"), "xattrName");
    }

    @Test(expected=NotInMountpointException.class)
    public void testInternalGetXAttrs() throws IOException {
        this.fcView.getXAttrs(new Path("/internalDir"));
    }

    @Test(expected=NotInMountpointException.class)
    public void testInternalGetXAttrsWithNames() throws IOException {
        this.fcView.getXAttrs(new Path("/internalDir"), new ArrayList());
    }

    @Test(expected=NotInMountpointException.class)
    public void testInternalListXAttr() throws IOException {
        this.fcView.listXAttrs(new Path("/internalDir"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRemoveXAttr() throws IOException {
        this.fcView.removeXAttr(new Path("/internalDir"), "xattrName");
    }

    @Test(expected=AccessControlException.class)
    public void testInternalCreateSnapshot1() throws IOException {
        this.fcView.createSnapshot(new Path("/internalDir"));
    }

    @Test(expected=AccessControlException.class)
    public void testInternalCreateSnapshot2() throws IOException {
        this.fcView.createSnapshot(new Path("/internalDir"), "snap1");
    }

    @Test(expected=AccessControlException.class)
    public void testInternalRenameSnapshot() throws IOException {
        this.fcView.renameSnapshot(new Path("/internalDir"), "snapOldName", "snapNewName");
    }

    @Test(expected=AccessControlException.class)
    public void testInternalDeleteSnapshot() throws IOException {
        this.fcView.deleteSnapshot(new Path("/internalDir"), "snap1");
    }

    @Test
    public void testOwnerForInternalDir() throws IOException, InterruptedException, URISyntaxException {
        final UserGroupInformation userUgi = UserGroupInformation.createUserForTesting((String)"user@HADOOP.COM", (String[])new String[]{"hadoop"});
        userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException, URISyntaxException {
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                String doAsUserName = ugi.getUserName();
                Assert.assertEquals((Object)doAsUserName, (Object)"user@HADOOP.COM");
                FileContext viewFS = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)ViewFsBaseTest.this.conf);
                FileStatus stat = viewFS.getFileStatus(new Path("/internalDir"));
                Assert.assertEquals((Object)userUgi.getShortUserName(), (Object)stat.getOwner());
                return null;
            }
        });
    }

    @Test
    public void testRespectsServerDefaults() throws Exception {
        FsServerDefaults targetDefs = this.fcTarget.getDefaultFileSystem().getServerDefaults(new Path("/"));
        FsServerDefaults viewDefs = this.fcView.getDefaultFileSystem().getServerDefaults(new Path("/data"));
        Assert.assertEquals((long)targetDefs.getReplication(), (long)viewDefs.getReplication());
        Assert.assertEquals((long)targetDefs.getBlockSize(), (long)viewDefs.getBlockSize());
        Assert.assertEquals((long)targetDefs.getBytesPerChecksum(), (long)viewDefs.getBytesPerChecksum());
        Assert.assertEquals((long)targetDefs.getFileBufferSize(), (long)viewDefs.getFileBufferSize());
        Assert.assertEquals((long)targetDefs.getWritePacketSize(), (long)viewDefs.getWritePacketSize());
        Assert.assertEquals((Object)targetDefs.getEncryptDataTransfer(), (Object)viewDefs.getEncryptDataTransfer());
        Assert.assertEquals((long)targetDefs.getTrashInterval(), (long)viewDefs.getTrashInterval());
        Assert.assertEquals((Object)targetDefs.getChecksumType(), (Object)viewDefs.getChecksumType());
        this.fcView.create(new Path("/data/file"), EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]).close();
        FileStatus stat = this.fcTarget.getFileStatus(new Path(this.targetTestRoot, "data/file"));
        Assert.assertEquals((long)targetDefs.getReplication(), (long)stat.getReplication());
    }

    @Test
    public void testServerDefaultsInternalDir() throws Exception {
        FsServerDefaults localDefs = LocalConfigKeys.getServerDefaults();
        FsServerDefaults viewDefs = this.fcView.getDefaultFileSystem().getServerDefaults(new Path("/internalDir"));
        Assert.assertEquals((long)localDefs.getReplication(), (long)viewDefs.getReplication());
        Assert.assertEquals((long)localDefs.getBlockSize(), (long)viewDefs.getBlockSize());
        Assert.assertEquals((long)localDefs.getBytesPerChecksum(), (long)viewDefs.getBytesPerChecksum());
        Assert.assertEquals((long)localDefs.getFileBufferSize(), (long)viewDefs.getFileBufferSize());
        Assert.assertEquals((long)localDefs.getWritePacketSize(), (long)viewDefs.getWritePacketSize());
        Assert.assertEquals((Object)localDefs.getEncryptDataTransfer(), (Object)viewDefs.getEncryptDataTransfer());
        Assert.assertEquals((long)localDefs.getTrashInterval(), (long)viewDefs.getTrashInterval());
        Assert.assertEquals((Object)localDefs.getChecksumType(), (Object)viewDefs.getChecksumType());
    }

    @Test
    public void testListLocatedStatus() throws IOException {
        Path mockTarget = new Path("mockfs://listLocatedStatus/foo");
        Path mountPoint = new Path("/fooMount");
        Configuration newConf = new Configuration();
        newConf.setClass("fs.AbstractFileSystem.mockfs.impl", MockFs.class, AbstractFileSystem.class);
        ConfigUtil.addLink((Configuration)newConf, (String)mountPoint.toString(), (URI)mockTarget.toUri());
        FileContext.getFileContext((URI)URI.create("viewfs:///"), (Configuration)newConf).listLocatedStatus(mountPoint);
        AbstractFileSystem mockFs = MockFs.getMockFs(mockTarget.toUri());
        ((AbstractFileSystem)Mockito.verify((Object)mockFs)).listLocatedStatus(new Path(mockTarget.toUri().getPath()));
        ((AbstractFileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).listStatus((Path)Matchers.any(Path.class));
        ((AbstractFileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).listStatusIterator((Path)Matchers.any(Path.class));
    }

    @Test
    public void testListStatusIterator() throws IOException {
        Path mockTarget = new Path("mockfs://listStatusIterator/foo");
        Path mountPoint = new Path("/fooMount");
        Configuration newConf = new Configuration();
        newConf.setClass("fs.AbstractFileSystem.mockfs.impl", MockFs.class, AbstractFileSystem.class);
        ConfigUtil.addLink((Configuration)newConf, (String)mountPoint.toString(), (URI)mockTarget.toUri());
        FileContext.getFileContext((URI)URI.create("viewfs:///"), (Configuration)newConf).listStatus(mountPoint);
        AbstractFileSystem mockFs = MockFs.getMockFs(mockTarget.toUri());
        ((AbstractFileSystem)Mockito.verify((Object)mockFs)).listStatusIterator(new Path(mockTarget.toUri().getPath()));
        ((AbstractFileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).listStatus((Path)Matchers.any(Path.class));
    }

    @Test
    public void testListStatusWithNoGroups() throws Exception {
        UserGroupInformation userUgi = UserGroupInformation.createUserForTesting((String)"user@HADOOP.COM", (String[])new String[0]);
        userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                String clusterName = "default";
                URI viewFsUri = new URI("viewfs", clusterName, "/", null, null);
                FileSystem vfs = FileSystem.get((URI)viewFsUri, (Configuration)ViewFsBaseTest.this.conf);
                try {
                    vfs.listStatus(new Path(viewFsUri.toString() + "internalDir"));
                    Assert.fail((String)"Exception should be thrown.");
                }
                catch (IOException e) {
                    GenericTestUtils.assertExceptionContains("There is no primary group for UGI", e);
                }
                return null;
            }
        });
    }

    static class MockFs
    extends ChRootedFs {
        private static Map<String, AbstractFileSystem> fsCache = new HashMap<String, AbstractFileSystem>();

        MockFs(URI uri, Configuration conf) throws URISyntaxException {
            super(MockFs.getMockFs(uri), new Path("/"));
        }

        static AbstractFileSystem getMockFs(URI uri) {
            AbstractFileSystem mockFs = fsCache.get(uri.getAuthority());
            if (mockFs == null) {
                mockFs = (AbstractFileSystem)Mockito.mock(AbstractFileSystem.class);
                Mockito.when((Object)mockFs.getUri()).thenReturn((Object)uri);
                Mockito.when((Object)mockFs.getUriDefaultPort()).thenReturn((Object)1);
                Mockito.when((Object)mockFs.getUriPath((Path)Matchers.any(Path.class))).thenCallRealMethod();
                Mockito.when((Object)mockFs.isValidName(Matchers.anyString())).thenReturn((Object)true);
                fsCache.put(uri.getAuthority(), mockFs);
            }
            return mockFs;
        }
    }
}

