/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestZooKeeperWatcher {
    @Test
    public void testIsClientReadable() throws ZooKeeperConnectionException, IOException {
        ZooKeeperWatcher watcher = new ZooKeeperWatcher(HBaseConfiguration.create(), "testIsClientReadable", null, false);
        Assert.assertTrue((boolean)watcher.isClientReadable(watcher.baseZNode));
        Assert.assertTrue((boolean)watcher.isClientReadable(watcher.getZNodeForReplica(0)));
        Assert.assertTrue((boolean)watcher.isClientReadable(watcher.getMasterAddressZNode()));
        Assert.assertTrue((boolean)watcher.isClientReadable(watcher.clusterIdZNode));
        Assert.assertTrue((boolean)watcher.isClientReadable(watcher.tableZNode));
        Assert.assertTrue((boolean)watcher.isClientReadable(ZKUtil.joinZNode((String)watcher.tableZNode, (String)"foo")));
        Assert.assertTrue((boolean)watcher.isClientReadable(watcher.rsZNode));
        Assert.assertFalse((boolean)watcher.isClientReadable(watcher.tableLockZNode));
        Assert.assertFalse((boolean)watcher.isClientReadable(watcher.balancerZNode));
        Assert.assertFalse((boolean)watcher.isClientReadable(watcher.getRegionNormalizerZNode()));
        Assert.assertFalse((boolean)watcher.isClientReadable(watcher.clusterStateZNode));
        Assert.assertFalse((boolean)watcher.isClientReadable(watcher.drainingZNode));
        Assert.assertFalse((boolean)watcher.isClientReadable(watcher.recoveringRegionsZNode));
        Assert.assertFalse((boolean)watcher.isClientReadable(watcher.splitLogZNode));
        Assert.assertFalse((boolean)watcher.isClientReadable(watcher.backupMasterAddressesZNode));
        watcher.close();
    }
}

