/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestZKUtil {
    @Test
    public void testCreateACL() throws ZooKeeperConnectionException, IOException {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.superuser", "user1,@group1,user2,@group2,user3");
        String node = "/hbase/testCreateACL";
        ZooKeeperWatcher watcher = new ZooKeeperWatcher(conf, node, null, false);
        ArrayList aclList = ZKUtil.createACL((ZooKeeperWatcher)watcher, (String)node, (boolean)true);
        Assert.assertEquals((long)aclList.size(), (long)4L);
        Assert.assertTrue((!aclList.contains(new ACL(31, new Id("auth", "@group1"))) && !aclList.contains(new ACL(31, new Id("auth", "@group2"))) ? 1 : 0) != 0);
        Assert.assertTrue((aclList.contains(new ACL(31, new Id("auth", "user1"))) && aclList.contains(new ACL(31, new Id("auth", "user2"))) && aclList.contains(new ACL(31, new Id("auth", "user3"))) ? 1 : 0) != 0);
    }
}

