/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestPayloadCarryingRpcController {
    @Test
    public void testListOfCellScannerables() throws IOException {
        ArrayList<CellScannable> cells = new ArrayList<CellScannable>();
        int count = 10;
        for (int i = 0; i < 10; ++i) {
            cells.add(TestPayloadCarryingRpcController.createCell(i));
        }
        PayloadCarryingRpcController controller = new PayloadCarryingRpcController(cells);
        CellScanner cellScanner = controller.cellScanner();
        int index = 0;
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            byte[] indexBytes = Bytes.toBytes((int)index);
            Assert.assertTrue((String)("" + index), (boolean)Bytes.equals((byte[])indexBytes, (int)0, (int)indexBytes.length, (byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
            ++index;
        }
        Assert.assertEquals((long)10L, (long)index);
    }

    static CellScannable createCell(final int index) {
        return new CellScannable(){

            public CellScanner cellScanner() {
                return new CellScanner(){
                    private boolean hasCell = true;

                    public Cell current() {
                        return new Cell(){
                            private final int i;
                            {
                                this.i = index;
                            }

                            public byte[] getRowArray() {
                                return null;
                            }

                            public int getRowOffset() {
                                return 0;
                            }

                            public short getRowLength() {
                                return 0;
                            }

                            public byte[] getFamilyArray() {
                                return null;
                            }

                            public int getFamilyOffset() {
                                return 0;
                            }

                            public byte getFamilyLength() {
                                return 0;
                            }

                            public byte[] getQualifierArray() {
                                return null;
                            }

                            public int getQualifierOffset() {
                                return 0;
                            }

                            public int getQualifierLength() {
                                return 0;
                            }

                            public long getTimestamp() {
                                return 0L;
                            }

                            public byte getTypeByte() {
                                return 0;
                            }

                            public long getMvccVersion() {
                                return 0L;
                            }

                            public long getSequenceId() {
                                return 0L;
                            }

                            public byte[] getValueArray() {
                                return Bytes.toBytes((int)this.i);
                            }

                            public int getValueOffset() {
                                return 0;
                            }

                            public int getValueLength() {
                                return 4;
                            }

                            public int getTagsOffset() {
                                return 0;
                            }

                            public int getTagsLength() {
                                return 0;
                            }

                            public byte[] getTagsArray() {
                                return null;
                            }

                            public byte[] getValue() {
                                return null;
                            }

                            public byte[] getFamily() {
                                return null;
                            }

                            public byte[] getQualifier() {
                                return null;
                            }

                            public byte[] getRow() {
                                return null;
                            }
                        };
                    }

                    public boolean advance() {
                        if (!this.hasCell) {
                            return this.hasCell;
                        }
                        this.hasCell = false;
                        return true;
                    }
                };
            }
        };
    }
}

