/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.stack.HandshakeCompletedListenerImpl;
import gov.nist.javax.sip.stack.KeyedSemaphore;
import gov.nist.javax.sip.stack.NioTcpMessageChannel;
import gov.nist.javax.sip.stack.NioTcpMessageProcessor;
import gov.nist.javax.sip.stack.NioTlsMessageChannel;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class NIOHandler {
    private static StackLogger logger = CommonLogger.getLogger(NIOHandler.class);
    private static final int BLOCKING_CONNECT_TIMEOUT = 10000;
    private SipStackImpl sipStack;
    private NioTcpMessageProcessor messageProcessor;
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private final ConcurrentHashMap<String, SocketChannel> socketTable = new ConcurrentHashMap();
    KeyedSemaphore keyedSemaphore = new KeyedSemaphore();

    protected static String makeKey(InetAddress addr, int port) {
        return addr.getHostAddress() + ":" + port;
    }

    protected static String makeKey(String addr, int port) {
        return addr + ":" + port;
    }

    protected NIOHandler(SIPTransactionStack sipStack, NioTcpMessageProcessor messageProcessor) {
        this.sipStack = (SipStackImpl)sipStack;
        this.messageProcessor = messageProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putSocket(String key, SocketChannel sock) {
        if (this.stopped.get()) {
            return;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("adding socket for key " + key);
        }
        boolean entered = false;
        try {
            this.keyedSemaphore.enterIOCriticalSection(key);
            entered = true;
            this.socketTable.put(key, sock);
        }
        catch (IOException ioExp) {
            if (logger.isLoggingEnabled(32)) {
                logger.logError("Failed on putting socket", ioExp);
            }
        }
        finally {
            if (entered) {
                this.keyedSemaphore.leaveIOCriticalSection(key);
            }
        }
    }

    protected SocketChannel getSocket(String key) {
        return this.socketTable.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSocket(String key) {
        boolean entered = false;
        try {
            this.keyedSemaphore.enterIOCriticalSection(key);
            entered = true;
            SocketChannel removed = this.socketTable.remove(key);
            this.keyedSemaphore.remove(key);
            if (logger.isLoggingEnabled(32)) {
                boolean wasRemoved = removed != null;
                logger.logDebug("removed Socket and Semaphore for key " + key + ", removed:" + wasRemoved);
            }
        }
        catch (IOException ioExp) {
            if (logger.isLoggingEnabled(32)) {
                logger.logError("Failed on putting socket", ioExp);
            }
        }
        finally {
            if (entered) {
                this.keyedSemaphore.leaveIOCriticalSection(key);
            }
        }
    }

    protected void removeSocket(SocketChannel channel) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Trying to remove cached socketChannel without key" + this + " socketChannel = " + channel);
        }
        LinkedList<String> keys = new LinkedList<String>();
        Set<Map.Entry<String, SocketChannel>> e = this.socketTable.entrySet();
        for (Map.Entry<String, SocketChannel> entry : e) {
            SocketChannel sc = entry.getValue();
            if (!sc.equals(channel)) continue;
            keys.add(entry.getKey());
        }
        for (String key : keys) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Removing cached socketChannel without key" + this + " socketChannel = " + channel + " key = " + key);
            }
            this.removeSocket(key);
        }
    }

    private void writeChunks(SocketChannel channel, byte[] bytes, int length) {
        this.messageProcessor.send(channel, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketChannel openOutgoingConnection(InetAddress senderAddress, InetAddress receiverAddress, int contactPort, boolean retry, String key) throws IOException {
        SocketChannel clientSock;
        block17: {
            int retry_count = 0;
            int max_retry = retry ? 2 : 1;
            clientSock = null;
            boolean entered = false;
            try {
                this.keyedSemaphore.enterIOCriticalSection(key);
                entered = true;
                clientSock = this.getSocket(key);
                if (!(clientSock == null || clientSock.isConnected() && clientSock.isOpen())) {
                    this.removeSocket(key);
                    clientSock = null;
                }
                if (clientSock != null || retry_count >= max_retry || clientSock != null) break block17;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("inaddr = " + receiverAddress);
                    logger.logDebug("port = " + contactPort);
                }
                try {
                    clientSock = this.messageProcessor.blockingConnect(new InetSocketAddress(receiverAddress, contactPort), senderAddress, 10000);
                }
                catch (SocketException e) {
                    if (logger.isLoggingEnabled(16)) {
                        logger.logInfo("Problem connecting " + receiverAddress + " " + contactPort + " " + senderAddress);
                    }
                    this.removeSocket(key);
                    throw new SocketException(e.getClass() + " " + e.getMessage() + " " + e.getCause() + " Problem connecting " + receiverAddress + " " + contactPort + " " + senderAddress);
                }
                this.putSocket(key, clientSock);
            }
            catch (IOException ex) {
                if (logger.isLoggingEnabled(16)) {
                    logger.logInfo("Problem OpeningConn:  inAddr " + receiverAddress.getHostAddress() + " port = " + contactPort + " retry " + retry);
                }
                this.removeSocket(key);
                if (!retry) {
                    if (contactPort <= 0) {
                        contactPort = 5060;
                    }
                    if ((clientSock = this.getSocket(key = NIOHandler.makeKey(receiverAddress, contactPort))) == null || !clientSock.isConnected() || !clientSock.isOpen()) {
                        this.removeSocket(key);
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("inaddr = " + receiverAddress + " port = " + contactPort);
                        }
                        clientSock = this.messageProcessor.blockingConnect(new InetSocketAddress(receiverAddress, contactPort), senderAddress, 10000);
                        this.putSocket(key, clientSock);
                    }
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("sending to " + key);
                    }
                    break block17;
                }
                logger.logError("IOException occured at ", ex);
                throw ex;
            }
            finally {
                if (entered) {
                    this.keyedSemaphore.leaveIOCriticalSection(key);
                }
            }
        }
        return clientSock;
    }

    public SocketChannel sendBytes(InetAddress senderAddress, InetAddress receiverAddress, int contactPort, String transport, byte[] bytes, boolean retry, NioTcpMessageChannel messageChannel) throws IOException {
        if (this.stopped.get()) {
            return null;
        }
        int length = bytes.length;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendBytes " + transport + " inAddr " + receiverAddress.getHostAddress() + " port = " + contactPort + " length = " + length + " retry " + retry);
        }
        if (logger.isLoggingEnabled(16) && this.sipStack.isLogStackTraceOnMessageSend()) {
            logger.logStackTrace(16);
        }
        String key = NIOHandler.makeKey(receiverAddress, contactPort);
        boolean newSocket = false;
        SocketChannel clientSock = this.getSocket(key);
        if (!(clientSock == null || clientSock.isConnected() && clientSock.isOpen())) {
            clientSock = null;
        }
        if (clientSock == null) {
            newSocket = true;
            clientSock = this.openOutgoingConnection(senderAddress, receiverAddress, contactPort, retry, key);
            messageChannel.peerPort = contactPort;
        }
        if (clientSock != null) {
            if (newSocket && messageChannel instanceof NioTlsMessageChannel) {
                HandshakeCompletedListenerImpl listner = new HandshakeCompletedListenerImpl((NioTlsMessageChannel)messageChannel, clientSock);
                ((NioTlsMessageChannel)messageChannel).setHandshakeCompletedListener(listner);
            } else {
                this.writeChunks(clientSock, bytes, length);
            }
        }
        if (clientSock == null) {
            if (logger.isLoggingEnabled(4)) {
                logger.logError(this.socketTable.toString());
                logger.logError("Could not connect to " + receiverAddress + ":" + contactPort);
            }
            throw new IOException("Could not connect to " + receiverAddress + ":" + contactPort);
        }
        return clientSock;
    }

    public void closeAll() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Closing " + this.socketTable.size() + " sockets from IOHandler");
        }
        Enumeration<SocketChannel> values = this.socketTable.elements();
        while (values.hasMoreElements()) {
            SocketChannel s = values.nextElement();
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void stop() {
        this.stopped.set(true);
        try {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("keys to check for inactivity removal " + NioTcpMessageChannel.channelMap.keySet());
                logger.logDebug("existing socket in NIOHandler " + this.socketTable.keySet());
            }
            Iterator<Map.Entry<SocketChannel, NioTcpMessageChannel>> entriesIterator = NioTcpMessageChannel.channelMap.entrySet().iterator();
            while (entriesIterator.hasNext()) {
                Map.Entry<SocketChannel, NioTcpMessageChannel> entry = entriesIterator.next();
                SocketChannel socketChannel = entry.getKey();
                NioTcpMessageChannel messageChannel = entry.getValue();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("stop() : Removing socket " + messageChannel.key + " socketChannel = " + socketChannel);
                }
                messageChannel.close();
                NioTcpMessageChannel.channelMap.remove(socketChannel);
                entriesIterator = NioTcpMessageChannel.channelMap.entrySet().iterator();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SocketChannel createOrReuseSocket(InetAddress inetAddress, int port) throws IOException {
        if (this.stopped.get()) {
            return null;
        }
        String key = NIOHandler.makeKey(inetAddress, port);
        SocketChannel channel = null;
        channel = this.getSocket(key);
        if (!(channel == null || channel.isConnected() && channel.isOpen())) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Channel disconnected " + channel);
            }
            channel = null;
        }
        if (channel == null) {
            channel = this.openOutgoingConnection(this.messageProcessor.getIpAddress(), inetAddress, port, false, key);
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Returning socket " + key + " channel = " + channel);
        }
        return channel;
    }
}

