/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.cli;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.openmeetings.util.OmFileHelper;

public class CleanupUnit
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final File parent;
    private final long sizeTotal;

    public CleanupUnit() {
        this.parent = new File(".");
        this.sizeTotal = 0L;
    }

    public CleanupUnit(File parent) {
        this.parent = parent;
        if (!parent.isDirectory() || !parent.exists()) {
            throw new RuntimeException("Parent doesn't exist or not directory");
        }
        this.sizeTotal = OmFileHelper.getSize((File)parent);
    }

    public void cleanup() throws IOException {
        for (File f : this.getParent().listFiles()) {
            FileUtils.deleteQuietly((File)f);
        }
    }

    public File getParent() {
        return this.parent;
    }

    public long getSizeTotal() {
        return this.sizeTotal;
    }

    public String getHumanTotal() {
        return OmFileHelper.getHumanSize((long)this.sizeTotal);
    }
}

