/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.scheduling.methods;

import com.github.caldav4j.methods.HttpPostMethod;
import com.github.caldav4j.model.request.CalendarRequest;
import java.net.URI;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Organizer;

public class HttpSchedulePostMethod
extends HttpPostMethod {
    public HttpSchedulePostMethod(URI uri, CalendarRequest calendarRequest, CalendarOutputter calendarOutputter) {
        super(uri, calendarRequest, calendarOutputter);
    }

    public HttpSchedulePostMethod(String uri, CalendarRequest calendarRequest, CalendarOutputter calendarOutputter) {
        super(uri, calendarRequest, calendarOutputter);
    }

    @Override
    protected void addRequestHeaders(CalendarRequest calendarRequest) {
        boolean addOrganizerToAttendees = false;
        boolean hasAttendees = false;
        Calendar calendar = calendarRequest.getCalendar();
        if (calendar != null) {
            ComponentList cList = calendar.getComponents();
            if (Method.REPLY.equals((Object)calendar.getProperty("METHOD"))) {
                addOrganizerToAttendees = true;
            }
            for (CalendarComponent event : cList) {
                Organizer organizer;
                if (event instanceof VTimeZone || (organizer = (Organizer)event.getProperty("ORGANIZER")) == null || organizer.getValue() == null || !organizer.getValue().startsWith("mailto:")) continue;
                super.addHeader("Originator", organizer.getValue());
                if (addOrganizerToAttendees) {
                    super.addHeader("Recipient", organizer.getValue());
                }
                for (Object oAttendee : event.getProperties("ATTENDEE")) {
                    Attendee a = (Attendee)oAttendee;
                    if (!a.getValue().startsWith("mailto:")) continue;
                    super.addHeader("Recipient", a.getValue());
                }
            }
        }
        super.addRequestHeaders(calendarRequest);
    }
}

