/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.asterisk.wrap.events;

import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.InvalidChannelName;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.asterisk.wrap.events.ChannelEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.core.ChannelProxy;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class RenameEvent
extends ManagerEvent
implements ChannelEvent {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(RenameEvent.class);
    private final Channel _channel;
    private final String _newName;
    private String uniqueId;

    public RenameEvent(org.asteriskjava.manager.event.RenameEvent event) throws InvalidChannelName {
        super(event);
        AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        this._channel = pbx.internalRegisterChannel(event.getChannel(), event.getUniqueId());
        this._newName = event.getNewname();
        String uniqueId = ((ChannelProxy)this._channel).getRealChannel().getUniqueId();
        logger.debug("Renaming :" + uniqueId + " " + event.getUniqueId());
        this.uniqueId = event.getUniqueId();
        assert (uniqueId.equalsIgnoreCase("-1") || uniqueId.compareToIgnoreCase(event.getUniqueId()) == 0) : "Rename registered against incorrect channel";
    }

    @Override
    public final Channel getChannel() {
        return this._channel;
    }

    public final String getNewName() {
        return this._newName;
    }

    public final String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String toString() {
        org.asteriskjava.manager.event.RenameEvent rawEvent = (org.asteriskjava.manager.event.RenameEvent)this.getSource();
        return "RenameEvent: existing channel: " + this._channel + " newname=" + this._newName + "rawExisting:" + rawEvent.getChannel() + " rawNewname:" + rawEvent.getNewname() + "rawUniquID:" + rawEvent.getUniqueId();
    }
}

