/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.wan.impl.merkletree;

import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.wan.impl.merkletree.AbstractMerkleTreeView;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import com.hazelcast.wan.impl.merkletree.MerkleTreeUtil;
import java.util.Arrays;

public class ArrayMerkleTree
extends AbstractMerkleTreeView
implements MerkleTree {
    private final int leafLevel;
    private final long footprint;

    public ArrayMerkleTree(int depth) {
        super(depth);
        this.leafLevel = depth - 1;
        this.footprint = 4 * this.tree.length + JVMUtil.REFERENCE_COST_IN_BYTES + 4 + 4 + 4 + 8;
    }

    @Override
    public void updateAdd(Object key, Object value) {
        int keyHash = key.hashCode();
        int valueHash = value.hashCode();
        int leafOrder = MerkleTreeUtil.getLeafOrderForHash(keyHash, this.leafLevel);
        int leafCurrentHash = this.getNodeHash(leafOrder);
        int leafNewHash = MerkleTreeUtil.addHash(leafCurrentHash, valueHash);
        this.setNodeHash(leafOrder, leafNewHash);
        this.updateBranch(leafOrder);
    }

    @Override
    public void updateReplace(Object key, Object oldValue, Object newValue) {
        int keyHash = key.hashCode();
        int oldValueHash = oldValue.hashCode();
        int newValueHash = newValue.hashCode();
        int leafOrder = MerkleTreeUtil.getLeafOrderForHash(keyHash, this.leafLevel);
        int leafCurrentHash = this.getNodeHash(leafOrder);
        int leafNewHash = MerkleTreeUtil.removeHash(leafCurrentHash, oldValueHash);
        leafNewHash = MerkleTreeUtil.addHash(leafNewHash, newValueHash);
        this.setNodeHash(leafOrder, leafNewHash);
        this.updateBranch(leafOrder);
    }

    @Override
    public void updateRemove(Object key, Object removedValue) {
        int keyHash = key.hashCode();
        int removedValueHash = removedValue.hashCode();
        int leafOrder = MerkleTreeUtil.getLeafOrderForHash(keyHash, this.leafLevel);
        int leafCurrentHash = this.getNodeHash(leafOrder);
        int leafNewHash = MerkleTreeUtil.removeHash(leafCurrentHash, removedValueHash);
        this.setNodeHash(leafOrder, leafNewHash);
        this.updateBranch(leafOrder);
    }

    @Override
    public int getNodeHash(int nodeOrder) {
        return this.tree[nodeOrder];
    }

    @Override
    public long footprint() {
        return this.footprint;
    }

    @Override
    public void clear() {
        Arrays.fill(this.tree, 0);
    }

    private void updateBranch(int leafOrder) {
        int nodeOrder = MerkleTreeUtil.getParentOrder(leafOrder);
        for (int level = this.leafLevel; level > 0; --level) {
            int leftChildOrder = MerkleTreeUtil.getLeftChildOrder(nodeOrder);
            int rightChildOrder = MerkleTreeUtil.getRightChildOrder(nodeOrder);
            int leftChildHash = this.getNodeHash(leftChildOrder);
            int rightChildHash = this.getNodeHash(rightChildOrder);
            int newNodeHash = MerkleTreeUtil.sumHash(leftChildHash, rightChildHash);
            this.setNodeHash(nodeOrder, newNodeHash);
            nodeOrder = MerkleTreeUtil.getParentOrder(nodeOrder);
        }
    }
}

