/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SqlExecuteCodec;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.sql.SqlExpectedResultType;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.AbstractSqlResult;
import com.hazelcast.sql.impl.InternalSqlService;
import com.hazelcast.sql.impl.client.SqlAbstractMessageTask;
import com.hazelcast.sql.impl.client.SqlClientUtils;
import com.hazelcast.sql.impl.client.SqlError;
import com.hazelcast.sql.impl.client.SqlPage;
import com.hazelcast.sql.impl.security.NoOpSqlSecurityContext;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import java.security.AccessControlException;
import java.security.Permission;

public class SqlExecuteMessageTask
extends SqlAbstractMessageTask<SqlExecuteCodec.RequestParameters> {
    public SqlExecuteMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        SqlSecurityContext sqlSecurityContext = this.prepareSecurityContext();
        SqlStatement query = new SqlStatement(((SqlExecuteCodec.RequestParameters)this.parameters).sql);
        for (Data param : ((SqlExecuteCodec.RequestParameters)this.parameters).parameters) {
            query.addParameter(this.serializationService.toObject(param));
        }
        query.setSchema(((SqlExecuteCodec.RequestParameters)this.parameters).schema);
        query.setTimeoutMillis(((SqlExecuteCodec.RequestParameters)this.parameters).timeoutMillis);
        query.setCursorBufferSize(((SqlExecuteCodec.RequestParameters)this.parameters).cursorBufferSize);
        query.setExpectedResultType(SqlExpectedResultType.fromId(((SqlExecuteCodec.RequestParameters)this.parameters).expectedResultType));
        InternalSqlService sqlService = this.nodeEngine.getSqlService();
        boolean skipUpdateStatistics = ((SqlExecuteCodec.RequestParameters)this.parameters).isSkipUpdateStatisticsExists && ((SqlExecuteCodec.RequestParameters)this.parameters).skipUpdateStatistics;
        return sqlService.execute(query, sqlSecurityContext, ((SqlExecuteCodec.RequestParameters)this.parameters).queryId, skipUpdateStatistics);
    }

    @Override
    protected SqlExecuteCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return SqlExecuteCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        AbstractSqlResult result = (AbstractSqlResult)response;
        if (result.updateCount() >= 0L) {
            return SqlExecuteCodec.encodeResponse(null, null, result.updateCount(), null, false, result.getPartitionArgumentIndex());
        }
        InternalSqlService sqlService = this.nodeEngine.getSqlService();
        SqlPage page = sqlService.getClientStateRegistry().registerAndFetch(this.endpoint.getUuid(), result, ((SqlExecuteCodec.RequestParameters)this.parameters).cursorBufferSize, this.serializationService);
        return SqlExecuteCodec.encodeResponse(result.getRowMetadata().getColumns(), page, -1L, null, result.isInfiniteRows(), result.getPartitionArgumentIndex());
    }

    @Override
    protected ClientMessage encodeException(Throwable throwable) {
        if (this.parameters == null) {
            return super.encodeException(throwable);
        }
        this.nodeEngine.getSqlService().closeOnError(((SqlExecuteCodec.RequestParameters)this.parameters).queryId);
        if (throwable instanceof AccessControlException) {
            return super.encodeException(throwable);
        }
        if (!(throwable instanceof Exception)) {
            return super.encodeException(throwable);
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Client SQL error: " + throwable, throwable);
        }
        SqlError error = SqlClientUtils.exceptionToClientError((Exception)throwable, this.nodeEngine.getLocalMember().getUuid());
        return SqlExecuteCodec.encodeResponse(null, null, -1L, error, false, -1);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:sqlService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "execute";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((SqlExecuteCodec.RequestParameters)this.parameters).sql, ((SqlExecuteCodec.RequestParameters)this.parameters).parameters, ((SqlExecuteCodec.RequestParameters)this.parameters).timeoutMillis, ((SqlExecuteCodec.RequestParameters)this.parameters).cursorBufferSize, ((SqlExecuteCodec.RequestParameters)this.parameters).schema, ((SqlExecuteCodec.RequestParameters)this.parameters).queryId};
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    private SqlSecurityContext prepareSecurityContext() {
        SecurityContext securityContext = this.clientEngine.getSecurityContext();
        if (securityContext == null) {
            return NoOpSqlSecurityContext.INSTANCE;
        }
        return securityContext.createSqlContext(this.endpoint.getSubject());
    }
}

