/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.client.impl.ClientEndpointStatisticsSnapshot;
import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.phonehome.Metric;
import com.hazelcast.internal.util.phonehome.MetricsCollectionContext;
import com.hazelcast.internal.util.phonehome.MetricsProvider;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class ClientMetricsProvider
implements MetricsProvider {
    private static final int CLIENT_TYPE_COUNT = 6;
    private static final Map<String, ClientInfoProviderHelper> CLIENT_TYPE_TO_HELPER = new HashMap<String, ClientInfoProviderHelper>(6);

    ClientMetricsProvider() {
    }

    @Override
    public void provideMetrics(Node node, MetricsCollectionContext context) {
        ClientEngine clientEngine = node.getClientEngine();
        Map<String, Long> activeClients = clientEngine.getActiveClientsInCluster();
        Map<String, ClientEndpointStatisticsSnapshot> snapshots = clientEngine.getEndpointStatisticsSnapshots();
        CLIENT_TYPE_TO_HELPER.forEach((clientType, helper) -> {
            long clientCount = activeClients.getOrDefault(clientType, 0L);
            ClientEndpointStatisticsSnapshot snapshot = (ClientEndpointStatisticsSnapshot)snapshots.get(clientType);
            helper.provideMetrics(clientCount, snapshot, context);
        });
        context.collect(PhoneHomeMetrics.CLIENT_ENDPOINT_COUNT, MetricsProvider.convertToLetter(node.clientEngine.getClientEndpointCount()));
    }

    static {
        CLIENT_TYPE_TO_HELPER.put("CPP", new ClientInfoProviderHelper(PhoneHomeMetrics.ACTIVE_CPP_CLIENTS_COUNT, PhoneHomeMetrics.OPENED_CPP_CLIENT_CONNECTIONS_COUNT, PhoneHomeMetrics.CLOSED_CPP_CLIENT_CONNECTIONS_COUNT, PhoneHomeMetrics.TOTAL_CPP_CLIENT_CONNECTION_DURATION, PhoneHomeMetrics.CPP_CLIENT_VERSIONS));
        CLIENT_TYPE_TO_HELPER.put("CSP", new ClientInfoProviderHelper(PhoneHomeMetrics.ACTIVE_CSHARP_CLIENTS_COUNT, PhoneHomeMetrics.OPENED_CSHARP_CLIENT_CONNECTIONS_COUNT, PhoneHomeMetrics.CLOSED_CSHARP_CLIENT_CONNECTIONS_COUNT, PhoneHomeMetrics.TOTAL_CSHARP_CLIENT_CONNECTION_DURATION, PhoneHomeMetrics.CSHARP_CLIENT_VERSIONS));
        CLIENT_TYPE_TO_HELPER.put("JVM", new ClientInfoProviderHelper(PhoneHomeMetrics.ACTIVE_JAVA_CLIENTS_COUNT, PhoneHomeMetrics.OPENED_JAVA_CLIENT_CONNECTIONS_COUNT, PhoneHomeMetrics.CLOSED_JAVA_CLIENT_CONNECTIONS_COUNT, PhoneHomeMetrics.TOTAL_JAVA_CLIENT_CONNECTION_DURATION, PhoneHomeMetrics.JAVA_CLIENT_VERSIONS));
        CLIENT_TYPE_TO_HELPER.put("NJS", new ClientInfoProviderHelper(PhoneHomeMetrics.ACTIVE_NODEJS_CLIENTS_COUNT, PhoneHomeMetrics.OPENED_NODEJS_CLIENT_CONNECTIONS_COUNT, PhoneHomeMetrics.CLOSED_NODEJS_CLIENT_CONNECTIONS_COUNT, PhoneHomeMetrics.TOTAL_NODEJS_CLIENT_CONNECTION_DURATION, PhoneHomeMetrics.NODEJS_CLIENT_VERSIONS));
        CLIENT_TYPE_TO_HELPER.put("PYH", new ClientInfoProviderHelper(PhoneHomeMetrics.ACTIVE_PYTHON_CLIENTS_COUNT, PhoneHomeMetrics.OPENED_PYTHON_CLIENT_CONNECTIONS_COUNT, PhoneHomeMetrics.CLOSED_PYTHON_CLIENT_CONNECTIONS_COUNT, PhoneHomeMetrics.TOTAL_PYTHON_CLIENT_CONNECTION_DURATION, PhoneHomeMetrics.PYTHON_CLIENT_VERSIONS));
        CLIENT_TYPE_TO_HELPER.put("GOO", new ClientInfoProviderHelper(PhoneHomeMetrics.ACTIVE_GO_CLIENTS_COUNT, PhoneHomeMetrics.OPENED_GO_CLIENT_CONNECTIONS_COUNT, PhoneHomeMetrics.CLOSED_GO_CLIENT_CONNECTIONS_COUNT, PhoneHomeMetrics.TOTAL_GO_CLIENT_CONNECTION_DURATION, PhoneHomeMetrics.GO_CLIENT_VERSIONS));
        CLIENT_TYPE_TO_HELPER.put("CLC", new ClientInfoProviderHelper(PhoneHomeMetrics.ACTIVE_CL_CLIENTS_COUNT, PhoneHomeMetrics.OPENED_CL_CLIENT_CONNECTIONS_COUNT, PhoneHomeMetrics.CLOSED_CL_CLIENT_CONNECTIONS_COUNT, PhoneHomeMetrics.TOTAL_CL_CLIENT_CONNECTION_DURATION, PhoneHomeMetrics.CL_CLIENT_VERSIONS));
    }

    private record ClientInfoProviderHelper(Metric activeClientCount, Metric openedClientConnectionCount, Metric closedClientConnectionCount, Metric totalClientConnectionDuration, Metric clientVersions) {
        public void provideMetrics(long clientCount, ClientEndpointStatisticsSnapshot snapshot, MetricsCollectionContext context) {
            context.collect(this.activeClientCount, clientCount);
            long connectionsOpened = snapshot != null ? snapshot.getConnectionsOpened() : 0L;
            context.collect(this.openedClientConnectionCount, connectionsOpened);
            long connectionsClosed = snapshot != null ? snapshot.getConnectionsClosed() : 0L;
            context.collect(this.closedClientConnectionCount, connectionsClosed);
            long totalConnectionDuration = snapshot != null ? snapshot.getTotalConnectionDuration() : 0L;
            context.collect(this.totalClientConnectionDuration, totalConnectionDuration);
            Set<Object> connectedClientVersions = snapshot != null ? snapshot.getClientVersions() : Collections.emptySet();
            context.collect(this.clientVersions, String.join((CharSequence)",", connectedClientVersions));
        }
    }
}

