/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.PortableId;
import java.io.IOException;
import java.util.Objects;

@SerializableByConvention(value=SerializableByConvention.Reason.PUBLIC_API)
public class FieldDefinitionImpl
implements FieldDefinition,
DataSerializable {
    private int index;
    private String fieldName;
    private FieldType type;
    private PortableId portableId;

    private FieldDefinitionImpl() {
    }

    public FieldDefinitionImpl(int index, String fieldName, FieldType type, int version) {
        this(index, fieldName, type, 0, 0, version);
    }

    public FieldDefinitionImpl(int index, String fieldName, FieldType type, int factoryId, int classId, int version) {
        this(index, fieldName, type, new PortableId(factoryId, classId, version));
    }

    public FieldDefinitionImpl(int index, String fieldName, FieldType type, PortableId portableId) {
        this.index = index;
        this.fieldName = fieldName;
        this.type = type;
        this.portableId = portableId;
    }

    @Override
    public FieldType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getFactoryId() {
        return this.portableId.getFactoryId();
    }

    @Override
    public int getClassId() {
        return this.portableId.getClassId();
    }

    @Override
    public int getVersion() {
        return this.portableId.getVersion();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.index);
        out.writeString(this.fieldName);
        out.writeByte(this.type.getId());
        this.portableId.writeData(out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.index = in.readInt();
        this.fieldName = in.readString();
        this.type = FieldType.get(in.readByte());
        this.portableId = new PortableId();
        this.portableId.readData(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDefinitionImpl that = (FieldDefinitionImpl)o;
        return this.index == that.index && Objects.equals(this.fieldName, that.fieldName) && this.type == that.type && this.portableId.equals(that.portableId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.index, this.fieldName, this.type, this.portableId});
    }

    public String toString() {
        return "FieldDefinitionImpl{index=" + this.index + ", fieldName='" + this.fieldName + "', type=" + this.type + ", factoryId=" + this.portableId.getFactoryId() + ", classId=" + this.portableId.getClassId() + ", version=" + this.portableId.getVersion() + "}";
    }
}

