/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.commons;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kurento.commons.ConfigFileObject;
import org.kurento.commons.PropertiesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFilePropertyHolder
implements PropertiesManager.PropertyHolder {
    private static Logger log = LoggerFactory.getLogger(ConfigFilePropertyHolder.class);
    private static final String SINGLE_CONFIG_FILES_PROPERTY = "single.config.file";
    private static Path lastLoadedConfigFilePath;
    private List<ConfigFileObject> loadedConfigFiles = new ArrayList<ConfigFileObject>();
    private Set<Path> loadedPaths = new HashSet<Path>();
    private static final Gson gson;

    public static synchronized void configurePropertiesFromConfigFile(Path configFilePath) throws JsonSyntaxException, JsonIOException, IOException {
        boolean singleConfigFile = Boolean.getBoolean(SINGLE_CONFIG_FILES_PROPERTY);
        if (singleConfigFile && lastLoadedConfigFilePath != null) {
            log.warn("Trying to load a second config file. The first was {} and the current is {}. Ignoring it.", (Object)lastLoadedConfigFilePath, (Object)configFilePath);
            return;
        }
        ConfigFilePropertyHolder cfph = null;
        PropertiesManager.PropertyHolder ph = PropertiesManager.getPropertyHolder();
        if (ph != null && ph instanceof ConfigFilePropertyHolder) {
            cfph = (ConfigFilePropertyHolder)ph;
            if (cfph.loadedPaths != null && cfph.loadedPaths.contains(configFilePath)) {
                log.debug("Trying to load again config file {}. Ignoring it.", (Object)configFilePath.toAbsolutePath());
                return;
            }
        }
        lastLoadedConfigFilePath = configFilePath;
        Preconditions.checkNotNull((Object)configFilePath, (Object)"configFilePath paramter must be not null.");
        log.debug("Using configuration file in path '{}' ({})", (Object)configFilePath, (Object)configFilePath.getClass().getCanonicalName());
        JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(configFilePath, StandardCharsets.UTF_8));
        reader.setLenient(true);
        JsonObject configFile = (JsonObject)gson.fromJson(reader, JsonObject.class);
        ConfigFilePropertyHolder.traceConfigContent(configFile);
        if (cfph == null) {
            cfph = new ConfigFilePropertyHolder();
        }
        cfph.loadedConfigFiles.add(new ConfigFileObject(configFilePath, configFile));
        cfph.loadedPaths.add(configFilePath);
        PropertiesManager.setPropertyHolder(cfph);
    }

    private static void traceConfigContent(JsonObject configFile) {
        if (log.isDebugEnabled()) {
            Gson gs = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            String jsonContents = gs.toJson((JsonElement)configFile);
            log.debug("Configuration content: " + jsonContents);
        }
    }

    @Override
    public String getProperty(String property) {
        String systemProperty = System.getProperty(property);
        if (systemProperty != null) {
            return systemProperty;
        }
        String[] tokens = property.split("\\.");
        int lastTokenNumber = tokens.length - 1;
        if (this.loadedConfigFiles != null) {
            block2: for (ConfigFileObject configFileObj : this.loadedConfigFiles) {
                JsonElement element;
                Path currentPath = configFileObj.getConfigFilePath();
                JsonObject currentObject = configFileObj.getConfigFile();
                for (int i = 0; i < tokens.length && (element = currentObject.get(tokens[i])) != null; ++i) {
                    if (i == lastTokenNumber) {
                        log.debug("Found {} in config file {}", (Object)property, (Object)currentPath.toAbsolutePath());
                        if (element instanceof JsonPrimitive) {
                            return element.getAsString();
                        }
                        return element.toString();
                    }
                    try {
                        currentObject = (JsonObject)element;
                        continue;
                    }
                    catch (ClassCastException e) {
                        continue block2;
                    }
                }
            }
        }
        return null;
    }

    public List<ConfigFileObject> getLoadedConfigFiles() {
        return this.loadedConfigFiles;
    }

    static {
        gson = new GsonBuilder().create();
    }
}

