/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.plugins.datepicker;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.wicket.util.io.IClusterable;
import org.wicketstuff.jquery.core.utils.DateUtils;

public class DateRange
implements IClusterable {
    private static final long serialVersionUID = 1L;
    public static final String PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private long start;
    private long end;

    public static DateRange of(Date start, Date end) {
        return DateRange.of(DateUtils.utc((Date)start), DateUtils.utc((Date)end));
    }

    public static DateRange of(long start, long end) {
        Calendar s = Calendar.getInstance(DateUtils.UTC);
        s.setTimeInMillis(start);
        s.set(11, 0);
        s.set(12, 0);
        s.set(13, 0);
        s.set(14, 0);
        Calendar e = Calendar.getInstance(DateUtils.UTC);
        e.setTimeInMillis(end);
        e.set(11, 23);
        e.set(12, 59);
        e.set(13, 59);
        e.set(14, 999);
        return new DateRange(s.getTimeInMillis(), e.getTimeInMillis());
    }

    public static DateRange today() {
        return DateRange.of(new Date(), new Date());
    }

    public static DateFormat newDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat(PATTERN);
        df.setTimeZone(DateUtils.UTC);
        return df;
    }

    public DateRange(Date start, Date end) {
        this(DateUtils.utc((Date)start), DateUtils.utc((Date)end));
    }

    public DateRange(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public final Date getStart() {
        return new Date(this.start);
    }

    public void setStart(Date date) {
        this.setStart(date.getTime());
    }

    public void setStart(long date) {
        this.start = date;
    }

    public Date getEnd() {
        return new Date(this.end);
    }

    public void setEnd(Date date) {
        this.setEnd(date.getTime());
    }

    public void setEnd(long date) {
        this.end = date;
    }

    public String toString() {
        DateFormat df = DateRange.newDateFormat();
        return String.format("[new Date('%s'),new Date('%s')]", df.format(this.getStart()), df.format(this.getEnd()));
    }
}

