/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.util.AssertUtils;

public final class FileUtils {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    private static boolean endsWithSeparator(@NonNull String filename) {
        if (filename.isEmpty()) {
            return false;
        }
        char lastChar = filename.charAt(filename.length() - 1);
        return lastChar == '/' || lastChar == '\\';
    }

    public static void copyFile(@NonNull File srcFile, @NonNull File destFile, CopyOption ... options) throws IOException {
        AssertUtils.notNull(srcFile, "srcFile must not be null");
        AssertUtils.notNull(destFile, "destFile must not be null");
        Path srcPath = srcFile.toPath();
        AssertUtils.isTrue(Files.isRegularFile(srcPath, new LinkOption[0]), "srcFile must be an existing file");
        Files.copy(srcPath, destFile.toPath(), options);
        destFile.setLastModified(srcFile.lastModified());
    }

    public static void copyFileToDirectory(@NonNull File srcFile, @NonNull File destDir, CopyOption ... options) throws IOException {
        AssertUtils.notNull(srcFile, "srcFile must not be null");
        AssertUtils.notNull(destDir, "destDir must not be null");
        Path srcPath = srcFile.toPath();
        Path destPath = destDir.toPath();
        AssertUtils.isTrue(Files.isRegularFile(srcPath, new LinkOption[0]), "srcFile must be an existing file");
        AssertUtils.isTrue(!Files.isRegularFile(destPath, new LinkOption[0]), "destDir cannot be an existing file");
        destPath.toFile().mkdirs();
        Path destFilePath = destPath.resolve(srcFile.getName());
        Files.copy(srcPath, destFilePath, options);
        destFilePath.toFile().setLastModified(srcFile.lastModified());
    }

    public static void copyDirectory(@NonNull File srcDir, @NonNull File destDir, CopyOption ... options) throws IOException {
        AssertUtils.notNull(srcDir, "srcDir must not be null");
        AssertUtils.notNull(destDir, "destDir must not be null");
        Path srcPath = srcDir.toPath();
        Path destPath = destDir.toPath();
        AssertUtils.isTrue(Files.isDirectory(srcPath, new LinkOption[0]), "srcDir must be an existing directory");
        AssertUtils.isTrue(!Files.isRegularFile(destPath, new LinkOption[0]), "destDir cannot be an existing file");
        AssertUtils.isTrue(!destPath.toAbsolutePath().startsWith(srcPath.toAbsolutePath()), "destDir cannot be a child of srcDir");
        if (Files.isDirectory(destPath, new LinkOption[0])) {
            if (Arrays.asList(options).contains(StandardCopyOption.REPLACE_EXISTING)) {
                FileUtils.delete(destDir);
            } else {
                throw new FileAlreadyExistsException(destDir.toString());
            }
        }
        Files.walkFileTree(srcPath, new CopyDir(srcPath, destPath, options));
    }

    public static boolean delete(@Nullable File file) throws IOException {
        if (file == null || !file.exists()) {
            return false;
        }
        Path pathToDelete = file.toPath();
        if (Files.isDirectory(pathToDelete, new LinkOption[0])) {
            try {
                Files.walk(pathToDelete, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                });
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        } else {
            Files.delete(pathToDelete);
        }
        return !Files.exists(pathToDelete, new LinkOption[0]);
    }

    public static boolean deleteQuietly(@Nullable File file) {
        try {
            return FileUtils.delete(file);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static @Nullable String getBaseName(@Nullable String filename) {
        if (filename == null) {
            return null;
        }
        if (FileUtils.endsWithSeparator(filename)) {
            return "";
        }
        String name = Paths.get(filename, new String[0]).getFileName().toString();
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return name;
        }
        return name.substring(0, i);
    }

    public static @Nullable String getExtension(@Nullable String filename) {
        if (filename == null) {
            return null;
        }
        if (FileUtils.endsWithSeparator(filename)) {
            return "";
        }
        String name = Paths.get(filename, new String[0]).getFileName().toString();
        int i = name.lastIndexOf(46);
        if (i == -1 || i == name.length()) {
            return "";
        }
        return name.substring(i + 1);
    }

    public static @Nullable String getName(@Nullable String filename) {
        if (filename == null) {
            return null;
        }
        if (FileUtils.endsWithSeparator(filename)) {
            return "";
        }
        return Paths.get(filename, new String[0]).getFileName().toString();
    }

    public static @NonNull String readFileToString(@NonNull File file, @NonNull Charset encoding) throws IOException {
        AssertUtils.notNull(file, "file must not be null");
        AssertUtils.notNull(encoding, "encoding must not be null");
        Path srcPath = file.toPath();
        AssertUtils.isTrue(Files.isRegularFile(srcPath, new LinkOption[0]), "srcFile must be an existing file");
        return new String(Files.readAllBytes(srcPath), encoding);
    }

    private FileUtils() {
        throw new AssertionError((Object)"Utility class must not be instantiated");
    }

    private static class CopyDir
    extends SimpleFileVisitor<Path> {
        private final Path sourceDir;
        private final Path targetDir;
        private final CopyOption[] options;

        CopyDir(Path sourceDir, Path targetDir, CopyOption ... options) {
            this.sourceDir = sourceDir;
            this.targetDir = targetDir;
            this.options = options;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            Path targetFile = this.targetDir.resolve(this.sourceDir.relativize(file));
            Files.copy(file, targetFile, this.options);
            targetFile.toFile().setLastModified(file.toFile().lastModified());
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attributes) throws IOException {
            Path newDir = this.targetDir.resolve(this.sourceDir.relativize(dir));
            Files.createDirectory(newDir, new FileAttribute[0]);
            return FileVisitResult.CONTINUE;
        }
    }
}

