/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.room;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.openmeetings.db.dto.room.RoomFileDTO;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.util.DtoHelper;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RoomDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String tag;
    private String comment;
    private Room.Type type;
    private Long capacity = 4L;
    private boolean appointment;
    private String confno;
    private boolean isPublic;
    private boolean demo;
    private boolean closed;
    private Integer demoTime;
    private String externalId;
    private String externalType;
    private String redirectUrl;
    private boolean moderated;
    private boolean waitModerator;
    private boolean allowUserQuestions;
    private boolean allowRecording;
    private boolean waitRecording;
    private boolean audioOnly;
    private Set<Room.RoomElement> hiddenElements = new HashSet<Room.RoomElement>();
    private List<RoomFileDTO> files = new ArrayList<RoomFileDTO>();

    public RoomDTO() {
    }

    public RoomDTO(Room r) {
        this.id = r.getId();
        this.name = r.getName();
        this.tag = r.getTag();
        this.comment = r.getComment();
        this.type = r.getType();
        this.capacity = r.getCapacity();
        this.appointment = r.isAppointment();
        this.confno = r.getConfno();
        this.isPublic = r.getIspublic();
        this.demo = r.isDemoRoom();
        this.closed = r.isClosed();
        this.demoTime = r.getDemoTime();
        this.externalId = r.getExternalId();
        this.externalType = r.externalType();
        this.redirectUrl = r.getRedirectURL();
        this.moderated = r.isModerated();
        this.waitModerator = r.isWaitModerator();
        this.allowUserQuestions = r.isAllowUserQuestions();
        this.allowRecording = r.isAllowRecording();
        this.waitRecording = r.isWaitRecording();
        this.audioOnly = r.isAudioOnly();
        this.hiddenElements = r.getHiddenElements();
        this.files = RoomFileDTO.get(r.getFiles());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Room.Type getType() {
        return this.type;
    }

    public void setType(Room.Type type) {
        this.type = type;
    }

    public Long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Long capacity) {
        this.capacity = capacity;
    }

    public boolean isAppointment() {
        return this.appointment;
    }

    public void setAppointment(boolean appointment) {
        this.appointment = appointment;
    }

    public String getConfno() {
        return this.confno;
    }

    public void setConfno(String confno) {
        this.confno = confno;
    }

    public boolean isDemo() {
        return this.demo;
    }

    public void setDemo(boolean demo) {
        this.demo = demo;
    }

    public Integer getDemoTime() {
        return this.demoTime;
    }

    public void setDemoTime(Integer demoTime) {
        this.demoTime = demoTime;
    }

    public boolean isModerated() {
        return this.moderated;
    }

    public void setModerated(boolean moderated) {
        this.moderated = moderated;
    }

    public boolean isWaitModerator() {
        return this.waitModerator;
    }

    public void setWaitModerator(boolean waitModerator) {
        this.waitModerator = waitModerator;
    }

    public boolean isAllowUserQuestions() {
        return this.allowUserQuestions;
    }

    public void setAllowUserQuestions(boolean allowUserQuestions) {
        this.allowUserQuestions = allowUserQuestions;
    }

    public boolean isAllowRecording() {
        return this.allowRecording;
    }

    public void setAllowRecording(boolean allowRecording) {
        this.allowRecording = allowRecording;
    }

    public boolean isWaitRecording() {
        return this.waitRecording;
    }

    public void setWaitRecording(boolean waitRecording) {
        this.waitRecording = waitRecording;
    }

    public boolean isAudioOnly() {
        return this.audioOnly;
    }

    public void setAudioOnly(boolean audioOnly) {
        this.audioOnly = audioOnly;
    }

    public Set<Room.RoomElement> getHiddenElements() {
        return this.hiddenElements;
    }

    public void setHiddenElements(Set<Room.RoomElement> hiddenElements) {
        this.hiddenElements = hiddenElements;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getExternalType() {
        return this.externalType;
    }

    public void setExternalType(String externalType) {
        this.externalType = externalType;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public List<RoomFileDTO> getFiles() {
        return this.files;
    }

    public void setFiles(List<RoomFileDTO> files) {
        this.files = files;
    }

    public static List<RoomDTO> list(List<Room> l) {
        ArrayList<RoomDTO> rList = new ArrayList<RoomDTO>();
        if (l != null) {
            for (Room r : l) {
                rList.add(new RoomDTO(r));
            }
        }
        return rList;
    }

    public static RoomDTO fromString(String s) {
        return RoomDTO.get(new JSONObject(s));
    }

    public static RoomDTO get(JSONObject o) {
        if (o == null) {
            return null;
        }
        RoomDTO r = new RoomDTO();
        r.id = DtoHelper.optLong(o, "id");
        r.name = o.optString("name");
        r.tag = o.optString("tag");
        r.comment = o.optString("comment");
        r.type = DtoHelper.optEnum(Room.Type.class, o, "type");
        if (r.type == null) {
            throw new IllegalArgumentException("Room should have valid type");
        }
        r.capacity = o.optLong("capacity", 4L);
        r.appointment = o.optBoolean("appointment", false);
        r.confno = o.optString("confno");
        r.isPublic = o.optBoolean("isPublic", false);
        r.demo = o.optBoolean("demo", false);
        r.closed = o.optBoolean("closed", false);
        r.demoTime = DtoHelper.optInt(o, "demoTime");
        r.externalId = o.optString("externalId", null);
        r.externalType = o.optString("externalType", null);
        r.redirectUrl = o.optString("redirectUrl");
        r.moderated = o.optBoolean("moderated", false);
        r.waitModerator = o.optBoolean("waitModerator", false);
        r.allowUserQuestions = o.optBoolean("allowUserQuestions", false);
        r.allowRecording = o.optBoolean("allowRecording", false);
        r.waitRecording = o.optBoolean("waitRecording", false);
        r.audioOnly = o.optBoolean("audioOnly", false);
        r.getHiddenElements().addAll(DtoHelper.optEnumList(Room.RoomElement.class, o.optJSONArray("hiddenElements")));
        JSONArray fa = o.optJSONArray("files");
        if (fa != null) {
            for (int i = 0; i < fa.length(); ++i) {
                r.getFiles().add(RoomFileDTO.get(fa.getJSONObject(i)));
            }
        }
        return r;
    }

    public String toString() {
        return new JSONObject((Object)this).toString();
    }
}

