/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.basic;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Calendar;
import java.util.List;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.entity.basic.MailMessage;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class MailMessageDao
implements IDataProviderDao<MailMessage> {
    private static final List<String> searchFields = List.of("recipients", "subject", "body", "lastError");
    @PersistenceContext
    private EntityManager em;

    @Override
    public MailMessage get(Long id) {
        return (MailMessage)this.em.createNamedQuery("getMailMessageById", MailMessage.class).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public List<MailMessage> get(long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getMailMessages", MailMessage.class), start, count).getResultList();
    }

    public List<MailMessage> get(long start, long count, MailMessage.Status status) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getMailMessagesByStatus", MailMessage.class).setParameter("status", (Object)status), start, count).getResultList();
    }

    @Override
    public List<MailMessage> get(String search, long start, long count, SortParam<String> sort) {
        return DaoHelper.get(this.em, MailMessage.class, false, search, searchFields, false, null, sort, start, count);
    }

    @Override
    public long count() {
        return (Long)this.em.createNamedQuery("countMailMessages", Long.class).getSingleResult();
    }

    @Override
    public long count(String search) {
        return DaoHelper.count(this.em, MailMessage.class, search, searchFields, false, null);
    }

    public void resetSendingStatus(Calendar date) {
        this.em.createNamedQuery("resetMailStatusByDate").setParameter("noneStatus", (Object)MailMessage.Status.NONE).setParameter("sendingStatus", (Object)MailMessage.Status.SENDING).setParameter("date", (Object)date).executeUpdate();
    }

    public void resetSendingStatus(Long id) {
        this.em.createNamedQuery("resetMailStatusById").setParameter("noneStatus", (Object)MailMessage.Status.NONE).setParameter("id", (Object)id).executeUpdate();
    }

    @Override
    public MailMessage update(MailMessage m, Long userId) {
        if (m.getId() == null) {
            this.em.persist((Object)m);
        } else {
            m = (MailMessage)this.em.merge((Object)m);
        }
        return m;
    }

    @Override
    public void delete(MailMessage m, Long userId) {
        if (m != null) {
            this.delete(m.getId());
        }
    }

    public void delete(Long id) {
        if (id != null) {
            this.em.remove((Object)this.get(id));
        }
    }
}

