/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiFunction;

public class ComputeEntryProcessor<K, V>
implements EntryProcessor<K, V, V>,
IdentifiedDataSerializable {
    BiFunction<? super K, ? super V, ? extends V> biFunction;

    public ComputeEntryProcessor() {
    }

    public ComputeEntryProcessor(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        this.biFunction = biFunction;
    }

    @Override
    public V process(Map.Entry<K, V> entry) {
        V oldValue = entry.getValue();
        V newValue = this.biFunction.apply(entry.getKey(), oldValue);
        if (oldValue != null) {
            if (newValue != null) {
                entry.setValue(newValue);
                return newValue;
            }
            ((LazyMapEntry)entry).remove();
        } else if (newValue != null) {
            entry.setValue(newValue);
            return newValue;
        }
        return null;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 151;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.biFunction);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.biFunction = (BiFunction)in.readObject();
    }
}

