/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.impl.util.Util;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JetEvent<T> {
    private final long timestamp;
    private final T payload;

    private JetEvent(long timestamp, @Nonnull T payload) {
        this.timestamp = timestamp;
        this.payload = payload;
    }

    @Nullable
    public static <T> JetEvent<T> jetEvent(long timestamp, @Nullable T payload) {
        if (payload == null) {
            return null;
        }
        return new JetEvent<T>(timestamp, payload);
    }

    public long timestamp() {
        return this.timestamp;
    }

    @Nonnull
    public T payload() {
        return this.payload;
    }

    public String toString() {
        return "JetEvent{ts=" + Util.toLocalTime(this.timestamp) + ", payload=" + this.payload + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JetEvent jetEvent = (JetEvent)o;
        return this.timestamp == jetEvent.timestamp && Objects.equals(this.payload, jetEvent.payload);
    }

    public int hashCode() {
        return Objects.hash(this.payload, this.timestamp);
    }
}

