/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact.record;

import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializer;
import com.hazelcast.internal.serialization.impl.compact.CompactUtil;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactReader;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.record.ComponentReaderWriter;
import com.hazelcast.internal.serialization.impl.compact.record.JavaRecordReader;
import com.hazelcast.internal.serialization.impl.compact.zeroconfig.ValueReaderWriter;
import com.hazelcast.internal.serialization.impl.compact.zeroconfig.ValueReaderWriters;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.compact.CompactReader;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import com.hazelcast.nio.serialization.compact.CompactWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class JavaRecordSerializer
implements CompactSerializer<Object> {
    private final CompactStreamSerializer compactStreamSerializer;
    private final Map<Class<?>, JavaRecordReader> readersCache = new ConcurrentHashMap();
    private final Map<Class<?>, ComponentReaderWriter[]> readerWritersCache = new ConcurrentHashMap();

    public JavaRecordSerializer(CompactStreamSerializer compactStreamSerializer) {
        this.compactStreamSerializer = compactStreamSerializer;
    }

    public boolean isRecord(Class<?> clazz) {
        return clazz.isRecord();
    }

    @Override
    @Nonnull
    public Object read(@Nonnull CompactReader reader) {
        DefaultCompactReader compactReader = (DefaultCompactReader)reader;
        Class associatedClass = Objects.requireNonNull(compactReader.getAssociatedClass(), "AssociatedClass is required for JavaRecordSerializer");
        JavaRecordReader recordReader = this.readersCache.get(associatedClass);
        if (recordReader == null) {
            this.populateReadersWriters(associatedClass);
            recordReader = this.readersCache.get(associatedClass);
        }
        return recordReader.readRecord(compactReader, compactReader.getSchema());
    }

    @Override
    public void write(@Nonnull CompactWriter writer, @Nonnull Object object) {
        Class<?> clazz = object.getClass();
        ComponentReaderWriter[] readerWriters = this.readerWritersCache.get(clazz);
        if (readerWriters == null) {
            this.populateReadersWriters(clazz);
            readerWriters = this.readerWritersCache.get(clazz);
        }
        try {
            for (ComponentReaderWriter readerWriter : readerWriters) {
                readerWriter.writeComponent(writer, object);
            }
        }
        catch (Exception e) {
            throw new HazelcastSerializationException("Failed to write the Java record", e);
        }
    }

    @Override
    @Nonnull
    public String getTypeName() {
        throw new IllegalStateException("getTypeName should not be called for the record serializer");
    }

    @Override
    @Nonnull
    public Class<Object> getCompactClass() {
        throw new IllegalStateException("getCompactClass should not be called for the record serializer");
    }

    private void populateReadersWriters(Class<?> clazz) {
        CompactUtil.verifyClassIsCompactSerializable(clazz);
        try {
            RecordComponent[] recordComponents = clazz.getRecordComponents();
            Class[] componentTypes = new Class[recordComponents.length];
            ComponentReaderWriter[] componentReaderWriters = new ComponentReaderWriter[recordComponents.length];
            for (int i = 0; i < recordComponents.length; ++i) {
                RecordComponent recordComponent = recordComponents[i];
                Class<?> type = recordComponent.getType();
                Type genericType = recordComponent.getGenericType();
                String name = recordComponent.getName();
                componentTypes[i] = type;
                Method componentGetter = clazz.getDeclaredMethod(name, new Class[0]);
                componentGetter.setAccessible(true);
                componentReaderWriters[i] = new ComponentReaderWriterAdapter(ValueReaderWriters.readerWriterFor(this.compactStreamSerializer, clazz, type, genericType, name), componentGetter);
            }
            Constructor<?> constructor = clazz.getDeclaredConstructor(componentTypes);
            constructor.setAccessible(true);
            JavaRecordReader recordReader = new JavaRecordReader(constructor, componentReaderWriters);
            this.readersCache.put(clazz, recordReader);
            this.readerWritersCache.put(clazz, componentReaderWriters);
        }
        catch (Exception e) {
            throw new HazelcastSerializationException("Failed to construct the readers/writers for the Java record", e);
        }
    }

    private record ComponentReaderWriterAdapter<T>(ValueReaderWriter<T> readerWriter, Method componentGetter) implements ComponentReaderWriter
    {
        @Override
        public Object readComponent(CompactReader compactReader, Schema schema) {
            return this.readerWriter.read(compactReader, schema);
        }

        @Override
        public void writeComponent(CompactWriter compactWriter, Object recordObject) throws Exception {
            this.readerWriter.write(compactWriter, this.componentGetter.invoke(recordObject, new Object[0]));
        }
    }
}

