/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig;

import com.hazelcast.config.JavaSerializationFilterConfig;
import com.hazelcast.config.UserCodeNamespaceConfig;
import com.hazelcast.config.UserCodeNamespacesConfig;
import com.hazelcast.internal.dynamicconfig.ConfigurationService;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class DynamicUserCodeNamespacesConfig
extends UserCodeNamespacesConfig {
    private final Supplier<ConfigurationService> configurationServiceAccessor;

    public DynamicUserCodeNamespacesConfig(Supplier<ConfigurationService> configurationServiceAccessor, UserCodeNamespacesConfig userCodeNamespacesConfig) {
        super(userCodeNamespacesConfig);
        this.configurationServiceAccessor = configurationServiceAccessor;
    }

    @Override
    public UserCodeNamespacesConfig addNamespaceConfig(UserCodeNamespaceConfig userCodeNamespaceConfig) {
        if (!this.isEnabled()) {
            throw new UnsupportedOperationException("Cannot add namespace while Namespaces are disabled.");
        }
        super.addNamespaceConfig(userCodeNamespaceConfig);
        this.configurationServiceAccessor.get().broadcastConfig(userCodeNamespaceConfig);
        return this;
    }

    @Override
    public UserCodeNamespacesConfig removeNamespaceConfig(String namespace) {
        throw new UnsupportedOperationException("Namespaces cannot be removed at runtime");
    }

    @Override
    public void setClassFilterConfig(@Nullable JavaSerializationFilterConfig classFilterConfig) {
        throw new UnsupportedOperationException("Cannot define JavaSerializationFilterConfig for NamespacesConfig at runtime.");
    }

    @Override
    public UserCodeNamespacesConfig setEnabled(boolean enabled) {
        throw new UnsupportedOperationException("Cannot enable or disable NamespacesConfig at runtime.");
    }
}

