/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.memcache;

import com.hazelcast.internal.ascii.TextCommandConstants;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.memcache.DeleteCommand;
import com.hazelcast.internal.ascii.memcache.MemcacheCommandProcessor;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public class DeleteCommandProcessor
extends MemcacheCommandProcessor<DeleteCommand> {
    public DeleteCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
    }

    @Override
    public void handle(DeleteCommand command) {
        String key = URLDecoder.decode(command.getKey(), StandardCharsets.UTF_8);
        Object mapName = "hz_memcache_default";
        int index = key.indexOf(58);
        if (index != -1) {
            mapName = "hz_memcache_" + key.substring(0, index);
            key = key.substring(index + 1);
        }
        if (key.equals("")) {
            this.textCommandService.deleteAll((String)mapName);
        } else {
            Object oldValue = this.textCommandService.delete((String)mapName, key);
            if (oldValue == null) {
                this.textCommandService.incrementDeleteMissCount();
                command.setResponse(TextCommandConstants.NOT_FOUND);
            } else {
                this.textCommandService.incrementDeleteHitCount(1);
                command.setResponse(TextCommandConstants.DELETED);
            }
        }
        if (command.shouldReply()) {
            this.textCommandService.sendResponse(command);
        }
    }

    @Override
    public void handleRejection(DeleteCommand command) {
        this.handle(command);
    }
}

