/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.MapCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.vector.SearchOptions;
import java.util.Map;

public final class VectorSearchOptionsCodec {
    private static final int INCLUDE_VALUE_FIELD_OFFSET = 0;
    private static final int INCLUDE_VECTORS_FIELD_OFFSET = 1;
    private static final int LIMIT_FIELD_OFFSET = 2;
    private static final int INITIAL_FRAME_SIZE = 6;

    private VectorSearchOptionsCodec() {
    }

    public static void encode(ClientMessage clientMessage, SearchOptions vectorSearchOptions) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[6]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, vectorSearchOptions.isIncludeValue());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 1, vectorSearchOptions.isIncludeVectors());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 2, vectorSearchOptions.getLimit());
        clientMessage.add(initialFrame);
        MapCodec.encodeNullable(clientMessage, vectorSearchOptions.getHints(), StringCodec::encode, StringCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static SearchOptions decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        boolean includeValue = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        boolean includeVectors = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 1);
        int limit = FixedSizeTypesCodec.decodeInt(initialFrame.content, 2);
        Map<String, String> hints = MapCodec.decodeNullable(iterator, StringCodec::decode, StringCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createVectorSearchOptions(includeValue, includeVectors, limit, hints);
    }
}

