/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.ListenerConfigHolderCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class DynamicConfigAddListConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1770496;
    public static final int RESPONSE_MESSAGE_TYPE = 1770497;
    private static final int REQUEST_BACKUP_COUNT_FIELD_OFFSET = 16;
    private static final int REQUEST_ASYNC_BACKUP_COUNT_FIELD_OFFSET = 20;
    private static final int REQUEST_MAX_SIZE_FIELD_OFFSET = 24;
    private static final int REQUEST_STATISTICS_ENABLED_FIELD_OFFSET = 28;
    private static final int REQUEST_MERGE_BATCH_SIZE_FIELD_OFFSET = 29;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 33;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private DynamicConfigAddListConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, @Nullable Collection<ListenerConfigHolder> listenerConfigs, int backupCount, int asyncBackupCount, int maxSize, boolean statisticsEnabled, @Nullable String splitBrainProtectionName, String mergePolicy, int mergeBatchSize, @Nullable String userCodeNamespace) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setContainsSerializedDataInRequest(true);
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("DynamicConfig.AddListConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[33], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1770496);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, backupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, asyncBackupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, maxSize);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 28, statisticsEnabled);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 29, mergeBatchSize);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        ListMultiFrameCodec.encodeNullable(clientMessage, listenerConfigs, ListenerConfigHolderCodec::encode);
        CodecUtil.encodeNullable(clientMessage, splitBrainProtectionName, StringCodec::encode);
        StringCodec.encode(clientMessage, mergePolicy);
        CodecUtil.encodeNullable(clientMessage, userCodeNamespace, StringCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.backupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.asyncBackupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        request.maxSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        request.statisticsEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 28);
        request.mergeBatchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 29);
        request.name = StringCodec.decode(iterator);
        request.listenerConfigs = ListMultiFrameCodec.decodeNullable(iterator, ListenerConfigHolderCodec::decode);
        request.splitBrainProtectionName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.mergePolicy = StringCodec.decode(iterator);
        if (iterator.hasNext()) {
            request.userCodeNamespace = CodecUtil.decodeNullable(iterator, StringCodec::decode);
            request.isUserCodeNamespaceExists = true;
        } else {
            request.isUserCodeNamespaceExists = false;
        }
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1770497);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        @Nullable
        public List<ListenerConfigHolder> listenerConfigs;
        public int backupCount;
        public int asyncBackupCount;
        public int maxSize;
        public boolean statisticsEnabled;
        @Nullable
        public String splitBrainProtectionName;
        public String mergePolicy;
        public int mergeBatchSize;
        @Nullable
        public String userCodeNamespace;
        public boolean isUserCodeNamespaceExists;
    }
}

