/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.model.request;

import com.github.caldav4j.CalDAVConstants;
import com.github.caldav4j.exceptions.DOMValidationException;
import com.github.caldav4j.model.request.PropFilter;
import com.github.caldav4j.model.request.PropProperty;
import com.github.caldav4j.model.request.TimeRange;
import com.github.caldav4j.xml.OutputsDOMBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.model.Date;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;

public class CompFilter
extends OutputsDOMBase {
    public static final String ELEMENT_NAME = "comp-filter";
    public static final String ELEM_IS_DEFINED = "is-defined";
    public static final String ATTR_NAME = "name";
    private boolean isDefined = false;
    private TimeRange timeRange = null;
    private List<CompFilter> compFilters = new ArrayList<CompFilter>();
    private List<PropFilter> propFilters = new ArrayList<PropFilter>();
    private String name = null;

    public CompFilter(String name) {
        this.name = name;
    }

    public CompFilter() {
    }

    public CompFilter(String caldavNamespaceQualifier, String name, boolean isDefined, Date start, Date end, List<CompFilter> compFilters, List<PropFilter> propFilters) {
        this(name, isDefined, start, end, compFilters, propFilters);
    }

    public CompFilter(String name, boolean isDefined, Date start, Date end, List<CompFilter> compFilters, List<PropFilter> propFilters) {
        this.isDefined = isDefined;
        this.name = name;
        if (start != null || end != null) {
            this.timeRange = new TimeRange(start, end);
        }
        if (propFilters != null) {
            this.propFilters.addAll(propFilters);
        }
        if (compFilters != null) {
            this.compFilters.addAll(compFilters);
        }
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected Namespace getNamespace() {
        return CalDAVConstants.NAMESPACE_CALDAV;
    }

    protected Collection<XmlSerializable> getChildren() {
        ArrayList<XmlSerializable> children = new ArrayList<XmlSerializable>();
        if (this.isDefined) {
            children.add((XmlSerializable)new PropProperty(ELEM_IS_DEFINED, CalDAVConstants.NAMESPACE_CALDAV));
        } else if (this.timeRange != null) {
            children.add(this.timeRange);
        }
        if (this.compFilters != null) {
            children.addAll(this.compFilters);
        }
        if (this.propFilters != null) {
            children.addAll(this.propFilters);
        }
        return children;
    }

    @Override
    protected String getTextContent() {
        return null;
    }

    @Override
    protected Map<String, String> getAttributes() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(ATTR_NAME, this.name);
        return m;
    }

    public List<CompFilter> getCompFilters() {
        return this.compFilters;
    }

    public void setCompFilters(List<CompFilter> compFilters) {
        this.compFilters = compFilters;
    }

    public void addCompFilter(CompFilter compFilter) {
        this.compFilters.add(compFilter);
    }

    public boolean isDefined() {
        return this.isDefined;
    }

    public void setDefined(boolean isDefined) {
        this.isDefined = isDefined;
    }

    public List<PropFilter> getPropFilters() {
        return this.propFilters;
    }

    public void setPropFilters(List<PropFilter> propFilters) {
        this.propFilters = propFilters;
    }

    public void addPropFilter(PropFilter propFilter) {
        this.propFilters.add(propFilter);
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(TimeRange timeRange) {
        this.timeRange = timeRange;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void validate() throws DOMValidationException {
        if (this.name == null) {
            this.throwValidationException("Name is a required property.");
        }
        if (this.isDefined && this.timeRange != null) {
            this.throwValidationException("TimeRange and isDefined are mutually exclusive");
        }
        if (this.timeRange != null) {
            this.timeRange.validate();
        }
        if (this.compFilters != null) {
            this.validate(this.compFilters);
        }
        if (this.propFilters != null) {
            this.validate(this.propFilters);
        }
    }
}

