/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.model.request;

import com.github.caldav4j.CalDAVConstants;
import com.github.caldav4j.exceptions.DOMValidationException;
import com.github.caldav4j.model.request.CalDAVReportRequest;
import com.github.caldav4j.model.request.CalendarData;
import com.github.caldav4j.model.request.DavHref;
import com.github.caldav4j.model.request.Prop;
import com.github.caldav4j.model.request.PropProperty;
import com.github.caldav4j.util.UrlUtils;
import com.github.caldav4j.xml.OutputsDOMBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;

public class CalendarMultiget
extends OutputsDOMBase
implements CalDAVReportRequest {
    public static final String ELEMENT_NAME = "calendar-multiget";
    public static final String ELEM_ALLPROP = "allprop";
    public static final String ELEM_PROPNAME = "propname";
    public static final String ELEM_FILTER = "filter";
    public static final String ELEM_HREF = "href";
    private boolean allProp = false;
    private boolean propName = false;
    private CalendarData calendarDataProp = null;
    private List<String> hrefs = new ArrayList<String>();
    private Prop<?> properties = new Prop();

    public CalendarMultiget() {
    }

    public CalendarMultiget(DavPropertyNameSet properties, CalendarData calendarData, boolean allProp, boolean propName) {
        this(calendarData, allProp, propName);
        this.properties.addChildren(properties);
    }

    public CalendarMultiget(Prop<?> properties, CalendarData calendarData, boolean allProp, boolean propName) {
        this(calendarData, allProp, propName);
        this.properties.addChildren(properties);
    }

    public CalendarMultiget(CalendarData calendarData, boolean allProp, boolean propName) {
        this.calendarDataProp = calendarData;
        this.allProp = allProp;
        this.propName = propName;
    }

    public CalendarMultiget(Collection<? extends XmlSerializable> properties, CalendarData calendarData, boolean allProp, boolean propName) {
        this(calendarData, allProp, propName);
        this.properties.addChildren(properties);
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected Namespace getNamespace() {
        return CalDAVConstants.NAMESPACE_CALDAV;
    }

    protected Collection<XmlSerializable> getChildren() {
        ArrayList<XmlSerializable> children = new ArrayList<XmlSerializable>();
        if (this.allProp) {
            children.add((XmlSerializable)new PropProperty(ELEM_ALLPROP, CalDAVConstants.NAMESPACE_WEBDAV));
        } else if (this.propName) {
            children.add((XmlSerializable)new PropProperty(ELEM_PROPNAME, CalDAVConstants.NAMESPACE_WEBDAV));
        } else if (this.properties != null && !this.properties.isEmpty() || this.calendarDataProp != null) {
            Prop temp = new Prop();
            temp.addChildren(this.properties.getChildren());
            if (this.calendarDataProp != null) {
                temp.addChild(this.calendarDataProp);
            }
            children.add((XmlSerializable)temp);
        }
        if (this.hrefs != null && !this.hrefs.isEmpty()) {
            for (String uri : this.hrefs) {
                DavHref href = new DavHref(UrlUtils.removeDoubleSlashes(uri));
                children.add(href);
            }
        }
        return children;
    }

    @Override
    protected String getTextContent() {
        return null;
    }

    public boolean isAllProp() {
        return this.allProp;
    }

    public void setAllProp(boolean allProp) {
        this.allProp = allProp;
    }

    public boolean isPropName() {
        return this.propName;
    }

    public void setPropName(boolean propName) {
        this.propName = propName;
    }

    public Prop<?> getProperties() {
        return this.properties;
    }

    public void setProperties(Collection<PropProperty<?>> properties) {
        this.properties.addChildren(properties);
    }

    public void setProperties(DavPropertyNameSet properties) {
        this.properties.addChildren(properties.getContent());
    }

    public void addProperty(XmlSerializable propProperty) {
        this.properties.add(propProperty);
    }

    public void addProperty(String propertyName, Namespace namespace) {
        PropProperty propProperty = new PropProperty(propertyName, namespace);
        this.properties.add((XmlSerializable)propProperty);
    }

    @Override
    protected Map<String, String> getAttributes() {
        return null;
    }

    public CalendarData getCalendarDataProp() {
        return this.calendarDataProp;
    }

    public void setCalendarDataProp(CalendarData calendarDataProp) {
        this.calendarDataProp = calendarDataProp;
    }

    public void setHrefs(List<String> l) {
        this.hrefs.addAll(l);
    }

    public List<String> getHrefs() {
        return this.hrefs;
    }

    public void addHref(String name) {
        this.hrefs.add(name);
    }

    @Override
    public void validate() throws DOMValidationException {
        if (this.calendarDataProp != null) {
            this.calendarDataProp.validate();
        }
        if (this.hrefs == null) {
            this.throwValidationException("Dav:Href cannot be null.");
        }
    }
}

