/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util.asm;

import java.util.ArrayList;
import org.apache.openjpa.util.asm.EnhancementClassLoader;
import org.apache.openjpa.util.asm.EnhancementProject;
import org.apache.xbean.asm9.Type;
import org.apache.xbean.asm9.tree.ClassNode;

public class ClassNodeTracker {
    private ClassNode classNode;
    private final ClassLoader cl;
    private final EnhancementProject project;

    public ClassNodeTracker(EnhancementProject project, ClassNode classNode, ClassLoader cl) {
        this.project = project;
        this.classNode = classNode;
        this.cl = this.hasEnhancementCl(cl) ? cl : new EnhancementClassLoader(project, cl);
        project.putClass(classNode.name.replace("/", "."), this);
    }

    private boolean hasEnhancementCl(ClassLoader cl) {
        boolean hasEhCl = false;
        do {
            if (!(cl instanceof EnhancementClassLoader)) continue;
            hasEhCl = true;
            break;
        } while ((cl = cl.getParent()) != null);
        return hasEhCl;
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    public void setClassNode(ClassNode classNode) {
        this.classNode = classNode;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public EnhancementProject getProject() {
        return this.project;
    }

    public Class<?> getType() {
        try {
            return Class.forName(this.classNode.name.replace("/", "."), false, this.cl);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void declareInterface(Class<?> iface) {
        if (this.classNode.interfaces == null) {
            this.classNode.interfaces = new ArrayList<String>();
        }
        this.classNode.interfaces.add(Type.getInternalName(iface));
    }
}

