/****************************************************************************
 * arch/arm/src/mx8mp/hardware/mx8mp_pinmux.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

/* Reference:
 *   "i.MX 8M Plus Applications Processor Reference Manual",
 *   Document Number: IMX8MPRM Rev. 1, 06/2021. NXP
 */

#ifndef __ARCH_ARM_SRC_MX8MP_HARDWARE_MX8MP_PINMUX_H
#define __ARCH_ARM_SRC_MX8MP_HARDWARE_MX8MP_PINMUX_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* IOMUXC Register Offsets **************************************************/

/* General Purpose Registers */

#define IOMUXC_GPR0_OFFSET                  0x0000
#define IOMUXC_GPR1_OFFSET                  0x0004
#define IOMUXC_GPR2_OFFSET                  0x0008
#define IOMUXC_GPR3_OFFSET                  0x000c
#define IOMUXC_GPR4_OFFSET                  0x0010
#define IOMUXC_GPR5_OFFSET                  0x0014
#define IOMUXC_GPR6_OFFSET                  0x0018
#define IOMUXC_GPR7_OFFSET                  0x001c
#define IOMUXC_GPR8_OFFSET                  0x0020
#define IOMUXC_GPR9_OFFSET                  0x0024
#define IOMUXC_GPR10_OFFSET                 0x0028
#define IOMUXC_GPR11_OFFSET                 0x002c
#define IOMUXC_GPR12_OFFSET                 0x0030
#define IOMUXC_GPR13_OFFSET                 0x0034
#define IOMUXC_GPR14_OFFSET                 0x0038
#define IOMUXC_GPR15_OFFSET                 0x003c
#define IOMUXC_GPR16_OFFSET                 0x0040
#define IOMUXC_GPR17_OFFSET                 0x0044
#define IOMUXC_GPR18_OFFSET                 0x0048
#define IOMUXC_GPR19_OFFSET                 0x004c
#define IOMUXC_GPR20_OFFSET                 0x0050
#define IOMUXC_GPR21_OFFSET                 0x0054
#define IOMUXC_GPR22_OFFSET                 0x0058
#define IOMUXC_GPR23_OFFSET                 0x005c
#define IOMUXC_GPR24_OFFSET                 0x0060

/* The pin function ID is a tuple that contains in order:
 *  mux_register
 *  mux_mode
 *  input_register
 *  input_daisy
 *  config_register)
 */

#define IOMUXC_BOOT_MODE0_SRC_BOOT_MODE0                    0x00000000, 0x0, 0x00000000, 0x0, 0x30330250
#define IOMUXC_BOOT_MODE1_SRC_BOOT_MODE1                    0x00000000, 0x0, 0x00000000, 0x0, 0x30330254
#define IOMUXC_BOOT_MODE2_SRC_BOOT_MODE2                    0x00000000, 0x0, 0x00000000, 0x0, 0x30330258
#define IOMUXC_BOOT_MODE3_SRC_BOOT_MODE3                    0x00000000, 0x0, 0x00000000, 0x0, 0x3033025C

#define IOMUXC_JTAG_MOD_JTAG_MODE                           0x00000000, 0x0, 0x00000000, 0x0, 0x30330260
#define IOMUXC_JTAG_TDI_JTAG_TDI                            0x00000000, 0x0, 0x00000000, 0x0, 0x30330264
#define IOMUXC_JTAG_TMS_JTAG_TMS                            0x00000000, 0x0, 0x00000000, 0x0, 0x30330268
#define IOMUXC_JTAG_TCK_JTAG_TCK                            0x00000000, 0x0, 0x00000000, 0x0, 0x3033026C
#define IOMUXC_JTAG_TDO_JTAG_TDO                            0x00000000, 0x0, 0x00000000, 0x0, 0x30330270

#define IOMUXC_RTC_XTALI_SNVS_RTC                           0x00000000, 0x0, 0x00000000, 0x0, 0x00000000
#define IOMUXC_PMIC_STBY_REQ_CCM_PMIC_STBY_REQ              0x00000000, 0x0, 0x00000000, 0x0, 0x00000000
#define IOMUXC_PMIC_ON_REQ_SNVS_PMIC_ON_REQ                 0x00000000, 0x0, 0x00000000, 0x0, 0x00000000
#define IOMUXC_ONOFF_SNVS_ONOFF                             0x00000000, 0x0, 0x00000000, 0x0, 0x00000000
#define IOMUXC_POR_B_SNVS_POR_B                             0x00000000, 0x0, 0x00000000, 0x0, 0x00000000

#define IOMUXC_GPIO1_IO00_GPIO1_IO00                        0x30330014, 0x0, 0x00000000, 0x0, 0x30330274
#define IOMUXC_GPIO1_IO00_CCM_ENET_PHY_REF_CLK_ROOT         0x30330014, 0x1, 0x00000000, 0x0, 0x30330274
#define IOMUXC_GPIO1_IO00_ISP_FL_TRIG_0                     0x30330014, 0x3, 0x303305D4, 0x0, 0x30330274
#define IOMUXC_GPIO1_IO00_ANAMIX_REF_CLK_32K                0x30330014, 0x5, 0x00000000, 0x0, 0x30330274
#define IOMUXC_GPIO1_IO00_CCM_EXT_CLK1                      0x30330014, 0x6, 0x00000000, 0x0, 0x30330274
#define IOMUXC_GPIO1_IO01_GPIO1_IO01                        0x30330018, 0x0, 0x00000000, 0x0, 0x30330278
#define IOMUXC_GPIO1_IO01_PWM1_OUT                          0x30330018, 0x1, 0x00000000, 0x0, 0x30330278
#define IOMUXC_GPIO1_IO01_ISP_SHUTTER_TRIG_0                0x30330018, 0x3, 0x303305DC, 0x0, 0x30330278
#define IOMUXC_GPIO1_IO01_ANAMIX_REF_CLK_24M                0x30330018, 0x5, 0x00000000, 0x0, 0x30330278
#define IOMUXC_GPIO1_IO01_CCM_EXT_CLK2                      0x30330018, 0x6, 0x00000000, 0x0, 0x30330278
#define IOMUXC_GPIO1_IO02_GPIO1_IO02                        0x3033001C, 0x0, 0x00000000, 0x0, 0x3033027C
#define IOMUXC_GPIO1_IO02_WDOG1_WDOG_B                      0x3033001C, 0x1, 0x00000000, 0x0, 0x3033027C
#define IOMUXC_GPIO1_IO02_ISP_FLASH_TRIG_0                  0x3033001C, 0x3, 0x00000000, 0x0, 0x3033027C
#define IOMUXC_GPIO1_IO02_WDOG1_WDOG_ANY                    0x3033001C, 0x5, 0x00000000, 0x0, 0x3033027C
#define IOMUXC_GPIO1_IO02_SJC_DE_B                          0x3033001C, 0x7, 0x00000000, 0x0, 0x3033027C
#define IOMUXC_GPIO1_IO03_GPIO1_IO03                        0x30330020, 0x0, 0x00000000, 0x0, 0x30330280
#define IOMUXC_GPIO1_IO03_USDHC1_VSELECT                    0x30330020, 0x1, 0x00000000, 0x0, 0x30330280
#define IOMUXC_GPIO1_IO03_ISP_PRELIGHT_TRIG_0               0x30330020, 0x3, 0x00000000, 0x0, 0x30330280
#define IOMUXC_GPIO1_IO03_SDMA1_EXT_EVENT0                  0x30330020, 0x5, 0x00000000, 0x0, 0x30330280
#define IOMUXC_GPIO1_IO04_GPIO1_IO04                        0x30330024, 0x0, 0x00000000, 0x0, 0x30330284
#define IOMUXC_GPIO1_IO04_USDHC2_VSELECT                    0x30330024, 0x1, 0x00000000, 0x0, 0x30330284
#define IOMUXC_GPIO1_IO04_ISP_SHUTTER_OPEN_0                0x30330024, 0x3, 0x00000000, 0x0, 0x30330284
#define IOMUXC_GPIO1_IO04_SDMA1_EXT_EVENT1                  0x30330024, 0x5, 0x00000000, 0x0, 0x30330284
#define IOMUXC_GPIO1_IO05_GPIO1_IO05                        0x30330028, 0x0, 0x00000000, 0x0, 0x30330288
#define IOMUXC_GPIO1_IO05_M7_NMI                            0x30330028, 0x1, 0x00000000, 0x0, 0x30330288
#define IOMUXC_GPIO1_IO05_ISP_FL_TRIG_1                     0x30330028, 0x3, 0x303305D8, 0x0, 0x30330288
#define IOMUXC_GPIO1_IO05_CCM_PMIC_READY                    0x30330028, 0x5, 0x30330554, 0x0, 0x30330288
#define IOMUXC_GPIO1_IO06_GPIO1_IO06                        0x3033002C, 0x0, 0x00000000, 0x0, 0x3033028C
#define IOMUXC_GPIO1_IO06_ENET_QOS_MDC                      0x3033002C, 0x1, 0x00000000, 0x0, 0x3033028C
#define IOMUXC_GPIO1_IO06_ISP_SHUTTER_TRIG_1                0x3033002C, 0x3, 0x303305E0, 0x0, 0x3033028C
#define IOMUXC_GPIO1_IO06_USDHC1_CD_B                       0x3033002C, 0x5, 0x00000000, 0x0, 0x3033028C
#define IOMUXC_GPIO1_IO06_CCM_EXT_CLK3                      0x3033002C, 0x6, 0x00000000, 0x0, 0x3033028C
#define IOMUXC_GPIO1_IO07_GPIO1_IO07                        0x30330030, 0x0, 0x00000000, 0x0, 0x30330290
#define IOMUXC_GPIO1_IO07_ENET_QOS_MDIO                     0x30330030, 0x1, 0x30330590, 0x0, 0x30330290
#define IOMUXC_GPIO1_IO07_ISP_FLASH_TRIG_1                  0x30330030, 0x3, 0x00000000, 0x0, 0x30330290
#define IOMUXC_GPIO1_IO07_USDHC1_WP                         0x30330030, 0x5, 0x00000000, 0x0, 0x30330290
#define IOMUXC_GPIO1_IO07_CCM_EXT_CLK4                      0x30330030, 0x6, 0x00000000, 0x0, 0x30330290
#define IOMUXC_GPIO1_IO08_GPIO1_IO08                        0x30330034, 0x0, 0x00000000, 0x0, 0x30330294
#define IOMUXC_GPIO1_IO08_ENET_QOS_1588_EVENT0_IN           0x30330034, 0x1, 0x00000000, 0x0, 0x30330294
#define IOMUXC_GPIO1_IO08_PWM1_OUT                          0x30330034, 0x2, 0x00000000, 0x0, 0x30330294
#define IOMUXC_GPIO1_IO08_ISP_PRELIGHT_TRIG_1               0x30330034, 0x3, 0x00000000, 0x0, 0x30330294
#define IOMUXC_GPIO1_IO08_ENET_QOS_1588_EVENT0_AUX_IN       0x30330034, 0x4, 0x00000000, 0x0, 0x30330294
#define IOMUXC_GPIO1_IO08_USDHC2_RESET_B                    0x30330034, 0x5, 0x00000000, 0x0, 0x30330294
#define IOMUXC_GPIO1_IO09_GPIO1_IO09                        0x30330038, 0x0, 0x00000000, 0x0, 0x30330298
#define IOMUXC_GPIO1_IO09_ENET_QOS_1588_EVENT0_OUT          0x30330038, 0x1, 0x00000000, 0x0, 0x30330298
#define IOMUXC_GPIO1_IO09_PWM2_OUT                          0x30330038, 0x2, 0x00000000, 0x0, 0x30330298
#define IOMUXC_GPIO1_IO09_ISP_SHUTTER_OPEN_1                0x30330038, 0x3, 0x00000000, 0x0, 0x30330298
#define IOMUXC_GPIO1_IO09_USDHC3_RESET_B                    0x30330038, 0x4, 0x00000000, 0x0, 0x30330298
#define IOMUXC_GPIO1_IO09_SDMA2_EXT_EVENT0                  0x30330038, 0x5, 0x00000000, 0x0, 0x30330298
#define IOMUXC_GPIO1_IO10_GPIO1_IO10                        0x3033003C, 0x0, 0x00000000, 0x0, 0x3033029C
#define IOMUXC_GPIO1_IO10_USB1_ID                           0x3033003C, 0x1, 0x00000000, 0x0, 0x3033029C
#define IOMUXC_GPIO1_IO10_PWM3_OUT                          0x3033003C, 0x2, 0x00000000, 0x0, 0x3033029C
#define IOMUXC_GPIO1_IO11_GPIO1_IO11                        0x30330040, 0x0, 0x00000000, 0x0, 0x303302A0
#define IOMUXC_GPIO1_IO11_USB2_ID                           0x30330040, 0x1, 0x00000000, 0x0, 0x303302A0
#define IOMUXC_GPIO1_IO11_PWM2_OUT                          0x30330040, 0x2, 0x00000000, 0x0, 0x303302A0
#define IOMUXC_GPIO1_IO11_USDHC3_VSELECT                    0x30330040, 0x4, 0x00000000, 0x0, 0x303302A0
#define IOMUXC_GPIO1_IO11_CCM_PMIC_READY                    0x30330040, 0x5, 0x30330554, 0x1, 0x303302A0
#define IOMUXC_GPIO1_IO12_GPIO1_IO12                        0x30330044, 0x0, 0x00000000, 0x0, 0x303302A4
#define IOMUXC_GPIO1_IO12_USB1_PWR                          0x30330044, 0x1, 0x00000000, 0x0, 0x303302A4
#define IOMUXC_GPIO1_IO12_SDMA2_EXT_EVENT1                  0x30330044, 0x5, 0x00000000, 0x0, 0x303302A4
#define IOMUXC_GPIO1_IO13_GPIO1_IO13                        0x30330048, 0x0, 0x00000000, 0x0, 0x303302A8
#define IOMUXC_GPIO1_IO13_USB1_OC                           0x30330048, 0x1, 0x00000000, 0x0, 0x303302A8
#define IOMUXC_GPIO1_IO13_PWM2_OUT                          0x30330048, 0x5, 0x00000000, 0x0, 0x303302A8
#define IOMUXC_GPIO1_IO14_GPIO1_IO14                        0x3033004C, 0x0, 0x00000000, 0x0, 0x303302AC
#define IOMUXC_GPIO1_IO14_USB2_PWR                          0x3033004C, 0x1, 0x00000000, 0x0, 0x303302AC
#define IOMUXC_GPIO1_IO14_USDHC3_CD_B                       0x3033004C, 0x4, 0x30330608, 0x0, 0x303302AC
#define IOMUXC_GPIO1_IO14_PWM3_OUT                          0x3033004C, 0x5, 0x00000000, 0x0, 0x303302AC
#define IOMUXC_GPIO1_IO14_CCM_CLKO1                         0x3033004C, 0x6, 0x00000000, 0x0, 0x303302AC
#define IOMUXC_GPIO1_IO15_GPIO1_IO15                        0x30330050, 0x0, 0x00000000, 0x0, 0x303302B0
#define IOMUXC_GPIO1_IO15_USB2_OC                           0x30330050, 0x1, 0x00000000, 0x0, 0x303302B0
#define IOMUXC_GPIO1_IO15_USDHC3_WP                         0x30330050, 0x4, 0x30330634, 0x0, 0x303302B0
#define IOMUXC_GPIO1_IO15_PWM4_OUT                          0x30330050, 0x5, 0x00000000, 0x0, 0x303302B0
#define IOMUXC_GPIO1_IO15_CCM_CLKO2                         0x30330050, 0x6, 0x00000000, 0x0, 0x303302B0
#define IOMUXC_ENET_MDC_ENET_QOS_MDC                        0x30330054, 0x0, 0x00000000, 0x0, 0x303302B4
#define IOMUXC_ENET_MDC_AUDIOMIX_SAI6_TX_DATA0              0x30330054, 0x2, 0x00000000, 0x0, 0x303302B4
#define IOMUXC_ENET_MDC_GPIO1_IO16                          0x30330054, 0x5, 0x00000000, 0x0, 0x303302B4
#define IOMUXC_ENET_MDC_USDHC3_STROBE                       0x30330054, 0x6, 0x30330630, 0x0, 0x303302B4
#define IOMUXC_ENET_MDIO_ENET_QOS_MDIO                      0x30330058, 0x0, 0x30330590, 0x1, 0x303302B8
#define IOMUXC_ENET_MDIO_AUDIOMIX_SAI6_TX_SYNC              0x30330058, 0x2, 0x30330528, 0x0, 0x303302B8
#define IOMUXC_ENET_MDIO_AUDIOMIX_PDM_BIT_STREAM3           0x30330058, 0x3, 0x303304CC, 0x0, 0x303302B8
#define IOMUXC_ENET_MDIO_GPIO1_IO17                         0x30330058, 0x5, 0x00000000, 0x0, 0x303302B8
#define IOMUXC_ENET_MDIO_USDHC3_DATA5                       0x30330058, 0x6, 0x30330624, 0x0, 0x303302B8
#define IOMUXC_ENET_TD3_ENET_QOS_RGMII_TD3                  0x3033005C, 0x0, 0x00000000, 0x0, 0x303302BC
#define IOMUXC_ENET_TD3_AUDIOMIX_SAI6_TX_BCLK               0x3033005C, 0x2, 0x30330524, 0x0, 0x303302BC
#define IOMUXC_ENET_TD3_AUDIOMIX_PDM_BIT_STREAM2            0x3033005C, 0x3, 0x303304C8, 0x0, 0x303302BC
#define IOMUXC_ENET_TD3_GPIO1_IO18                          0x3033005C, 0x5, 0x00000000, 0x0, 0x303302BC
#define IOMUXC_ENET_TD3_USDHC3_DATA6                        0x3033005C, 0x6, 0x30330628, 0x0, 0x303302BC
#define IOMUXC_ENET_TD2_ENET_QOS_RGMII_TD2                  0x30330060, 0x0, 0x00000000, 0x0, 0x303302C0
#define IOMUXC_ENET_TD2_CCM_ENET_QOS_CLOCK_GENERATE_REF_CLK 0x30330060, 0x1, 0x00000000, 0x0, 0x303302C0
#define IOMUXC_ENET_TD2_AUDIOMIX_SAI6_RX_DATA0              0x30330060, 0x2, 0x3033051C, 0x0, 0x303302C0
#define IOMUXC_ENET_TD2_AUDIOMIX_PDM_BIT_STREAM1            0x30330060, 0x3, 0x303304C4, 0x0, 0x303302C0
#define IOMUXC_ENET_TD2_GPIO1_IO19                          0x30330060, 0x5, 0x00000000, 0x0, 0x303302C0
#define IOMUXC_ENET_TD2_USDHC3_DATA7                        0x30330060, 0x6, 0x3033062C, 0x0, 0x303302C0
#define IOMUXC_ENET_TD1_ENET_QOS_RGMII_TD1                  0x30330064, 0x0, 0x00000000, 0x0, 0x303302C4
#define IOMUXC_ENET_TD1_AUDIOMIX_SAI6_RX_SYNC               0x30330064, 0x2, 0x30330520, 0x0, 0x303302C4
#define IOMUXC_ENET_TD1_AUDIOMIX_PDM_BIT_STREAM0            0x30330064, 0x3, 0x303304C0, 0x0, 0x303302C4
#define IOMUXC_ENET_TD1_GPIO1_IO20                          0x30330064, 0x5, 0x00000000, 0x0, 0x303302C4
#define IOMUXC_ENET_TD1_USDHC3_CD_B                         0x30330064, 0x6, 0x30330608, 0x1, 0x303302C4
#define IOMUXC_ENET_TD0_ENET_QOS_RGMII_TD0                  0x30330068, 0x0, 0x00000000, 0x0, 0x303302C8
#define IOMUXC_ENET_TD0_AUDIOMIX_SAI6_RX_BCLK               0x30330068, 0x2, 0x30330518, 0x0, 0x303302C8
#define IOMUXC_ENET_TD0_AUDIOMIX_PDM_CLK                    0x30330068, 0x3, 0x00000000, 0x0, 0x303302C8
#define IOMUXC_ENET_TD0_GPIO1_IO21                          0x30330068, 0x5, 0x00000000, 0x0, 0x303302C8
#define IOMUXC_ENET_TD0_USDHC3_WP                           0x30330068, 0x6, 0x30330634, 0x1, 0x303302C8
#define IOMUXC_ENET_TX_CTL_ENET_QOS_RGMII_TX_CTL            0x3033006C, 0x0, 0x00000000, 0x0, 0x303302CC
#define IOMUXC_ENET_TX_CTL_AUDIOMIX_SAI6_MCLK               0x3033006C, 0x2, 0x30330514, 0x0, 0x303302CC
#define IOMUXC_ENET_TX_CTL_AUDIOMIX_SPDIF1_OUT              0x3033006C, 0x3, 0x00000000, 0x0, 0x303302CC
#define IOMUXC_ENET_TX_CTL_GPIO1_IO22                       0x3033006C, 0x5, 0x00000000, 0x0, 0x303302CC
#define IOMUXC_ENET_TX_CTL_USDHC3_DATA0                     0x3033006C, 0x6, 0x30330610, 0x0, 0x303302CC
#define IOMUXC_ENET_TXC_CCM_ENET_QOS_CLOCK_GENERATE_TX_CLK  0x30330070, 0x0, 0x00000000, 0x0, 0x303302D0
#define IOMUXC_ENET_TXC_ENET_QOS_TX_ER                      0x30330070, 0x1, 0x00000000, 0x0, 0x303302D0
#define IOMUXC_ENET_TXC_AUDIOMIX_SAI7_TX_DATA0              0x30330070, 0x2, 0x00000000, 0x0, 0x303302D0
#define IOMUXC_ENET_TXC_GPIO1_IO23                          0x30330070, 0x5, 0x00000000, 0x0, 0x303302D0
#define IOMUXC_ENET_TXC_USDHC3_DATA1                        0x30330070, 0x6, 0x30330614, 0x0, 0x303302D0
#define IOMUXC_ENET_RX_CTL_ENET_QOS_RGMII_RX_CTL            0x30330074, 0x0, 0x00000000, 0x0, 0x303302D4
#define IOMUXC_ENET_RX_CTL_AUDIOMIX_SAI7_TX_SYNC            0x30330074, 0x2, 0x30330540, 0x0, 0x303302D4
#define IOMUXC_ENET_RX_CTL_AUDIOMIX_PDM_BIT_STREAM3         0x30330074, 0x3, 0x303304CC, 0x1, 0x303302D4
#define IOMUXC_ENET_RX_CTL_GPIO1_IO24                       0x30330074, 0x5, 0x00000000, 0x0, 0x303302D4
#define IOMUXC_ENET_RX_CTL_USDHC3_DATA2                     0x30330074, 0x6, 0x30330618, 0x0, 0x303302D4
#define IOMUXC_ENET_RXC_CCM_ENET_QOS_CLOCK_GENERATE_RX_CLK  0x30330078, 0x0, 0x00000000, 0x0, 0x303302D8
#define IOMUXC_ENET_RXC_ENET_QOS_RX_ER                      0x30330078, 0x1, 0x00000000, 0x0, 0x303302D8
#define IOMUXC_ENET_RXC_AUDIOMIX_SAI7_TX_BCLK               0x30330078, 0x2, 0x3033053C, 0x0, 0x303302D8
#define IOMUXC_ENET_RXC_AUDIOMIX_PDM_BIT_STREAM2            0x30330078, 0x3, 0x303304C8, 0x1, 0x303302D8
#define IOMUXC_ENET_RXC_GPIO1_IO25                          0x30330078, 0x5, 0x00000000, 0x0, 0x303302D8
#define IOMUXC_ENET_RXC_USDHC3_DATA3                        0x30330078, 0x6, 0x3033061C, 0x0, 0x303302D8
#define IOMUXC_ENET_RD0_ENET_QOS_RGMII_RD0                  0x3033007C, 0x0, 0x00000000, 0x0, 0x303302DC
#define IOMUXC_ENET_RD0_AUDIOMIX_SAI7_RX_DATA0              0x3033007C, 0x2, 0x30330534, 0x0, 0x303302DC
#define IOMUXC_ENET_RD0_AUDIOMIX_PDM_BIT_STREAM1            0x3033007C, 0x3, 0x303304C4, 0x1, 0x303302DC
#define IOMUXC_ENET_RD0_GPIO1_IO26                          0x3033007C, 0x5, 0x00000000, 0x0, 0x303302DC
#define IOMUXC_ENET_RD0_USDHC3_DATA4                        0x3033007C, 0x6, 0x30330620, 0x0, 0x303302DC
#define IOMUXC_ENET_RD1_ENET_QOS_RGMII_RD1                  0x30330080, 0x0, 0x00000000, 0x0, 0x303302E0
#define IOMUXC_ENET_RD1_AUDIOMIX_SAI7_RX_SYNC               0x30330080, 0x2, 0x30330538, 0x0, 0x303302E0
#define IOMUXC_ENET_RD1_AUDIOMIX_PDM_BIT_STREAM0            0x30330080, 0x3, 0x303304C0, 0x1, 0x303302E0
#define IOMUXC_ENET_RD1_GPIO1_IO27                          0x30330080, 0x5, 0x00000000, 0x0, 0x303302E0
#define IOMUXC_ENET_RD1_USDHC3_RESET_B                      0x30330080, 0x6, 0x00000000, 0x0, 0x303302E0
#define IOMUXC_ENET_RD2_ENET_QOS_RGMII_RD2                  0x30330084, 0x0, 0x00000000, 0x0, 0x303302E4
#define IOMUXC_ENET_RD2_AUDIOMIX_SAI7_RX_BCLK               0x30330084, 0x2, 0x30330530, 0x0, 0x303302E4
#define IOMUXC_ENET_RD2_AUDIOMIX_PDM_CLK                    0x30330084, 0x3, 0x00000000, 0x0, 0x303302E4
#define IOMUXC_ENET_RD2_GPIO1_IO28                          0x30330084, 0x5, 0x00000000, 0x0, 0x303302E4
#define IOMUXC_ENET_RD2_USDHC3_CLK                          0x30330084, 0x6, 0x30330604, 0x0, 0x303302E4
#define IOMUXC_ENET_RD3_ENET_QOS_RGMII_RD3                  0x30330088, 0x0, 0x00000000, 0x0, 0x303302E8
#define IOMUXC_ENET_RD3_AUDIOMIX_SAI7_MCLK                  0x30330088, 0x2, 0x3033052C, 0x0, 0x303302E8
#define IOMUXC_ENET_RD3_AUDIOMIX_SPDIF1_IN                  0x30330088, 0x3, 0x30330544, 0x0, 0x303302E8
#define IOMUXC_ENET_RD3_GPIO1_IO29                          0x30330088, 0x5, 0x00000000, 0x0, 0x303302E8
#define IOMUXC_ENET_RD3_USDHC3_CMD                          0x30330088, 0x6, 0x3033060C, 0x0, 0x303302E8
#define IOMUXC_SD1_CLK_USDHC1_CLK                           0x3033008C, 0x0, 0x00000000, 0x0, 0x303302EC
#define IOMUXC_SD1_CLK_ENET1_MDC                            0x3033008C, 0x1, 0x00000000, 0x0, 0x303302EC
#define IOMUXC_SD1_CLK_I2C5_SCL                             0x3033008C, 0x3, 0x303305C4, 0x0, 0x303302EC
#define IOMUXC_SD1_CLK_UART1_TX                             0x3033008C, 0x4, 0x00000000, 0x0, 0x303302EC
#define IOMUXC_SD1_CLK_UART1_RX                             0x3033008C, 0x4, 0x303305E8, 0x0, 0x303302EC
#define IOMUXC_SD1_CLK_GPIO2_IO00                           0x3033008C, 0x5, 0x00000000, 0x0, 0x303302EC
#define IOMUXC_SD1_CMD_USDHC1_CMD                           0x30330090, 0x0, 0x00000000, 0x0, 0x303302F0
#define IOMUXC_SD1_CMD_ENET1_MDIO                           0x30330090, 0x1, 0x3033057C, 0x0, 0x303302F0
#define IOMUXC_SD1_CMD_I2C5_SDA                             0x30330090, 0x3, 0x303305C8, 0x0, 0x303302F0
#define IOMUXC_SD1_CMD_UART1_RX                             0x30330090, 0x4, 0x303305E8, 0x1, 0x303302F0
#define IOMUXC_SD1_CMD_UART1_TX                             0x30330090, 0x4, 0x00000000, 0x0, 0x303302F0
#define IOMUXC_SD1_CMD_GPIO2_IO01                           0x30330090, 0x5, 0x00000000, 0x0, 0x303302F0
#define IOMUXC_SD1_DATA0_USDHC1_DATA0                       0x30330094, 0x0, 0x00000000, 0x0, 0x303302F4
#define IOMUXC_SD1_DATA0_ENET1_RGMII_TD1                    0x30330094, 0x1, 0x00000000, 0x0, 0x303302F4
#define IOMUXC_SD1_DATA0_I2C6_SCL                           0x30330094, 0x3, 0x303305CC, 0x0, 0x303302F4
#define IOMUXC_SD1_DATA0_UART1_RTS_B                        0x30330094, 0x4, 0x303305E4, 0x0, 0x303302F4
#define IOMUXC_SD1_DATA0_UART1_CTS_B                        0x30330094, 0x4, 0x00000000, 0x0, 0x303302F4
#define IOMUXC_SD1_DATA0_GPIO2_IO02                         0x30330094, 0x5, 0x00000000, 0x0, 0x303302F4
#define IOMUXC_SD1_DATA1_USDHC1_DATA1                       0x30330098, 0x0, 0x00000000, 0x0, 0x303302F8
#define IOMUXC_SD1_DATA1_ENET1_RGMII_TD0                    0x30330098, 0x1, 0x00000000, 0x0, 0x303302F8
#define IOMUXC_SD1_DATA1_I2C6_SDA                           0x30330098, 0x3, 0x303305D0, 0x0, 0x303302F8
#define IOMUXC_SD1_DATA1_UART1_CTS_B                        0x30330098, 0x4, 0x00000000, 0x0, 0x303302F8
#define IOMUXC_SD1_DATA1_UART1_RTS_B                        0x30330098, 0x4, 0x303305E4, 0x1, 0x303302F8
#define IOMUXC_SD1_DATA1_GPIO2_IO03                         0x30330098, 0x5, 0x00000000, 0x0, 0x303302F8
#define IOMUXC_SD1_DATA2_USDHC1_DATA2                       0x3033009C, 0x0, 0x00000000, 0x0, 0x303302FC
#define IOMUXC_SD1_DATA2_ENET1_RGMII_RD0                    0x3033009C, 0x1, 0x30330580, 0x0, 0x303302FC
#define IOMUXC_SD1_DATA2_I2C4_SCL                           0x3033009C, 0x3, 0x303305BC, 0x0, 0x303302FC
#define IOMUXC_SD1_DATA2_UART2_TX                           0x3033009C, 0x4, 0x00000000, 0x0, 0x303302FC
#define IOMUXC_SD1_DATA2_UART2_RX                           0x3033009C, 0x4, 0x303305F0, 0x0, 0x303302FC
#define IOMUXC_SD1_DATA2_GPIO2_IO04                         0x3033009C, 0x5, 0x00000000, 0x0, 0x303302FC
#define IOMUXC_SD1_DATA3_USDHC1_DATA3                       0x303300A0, 0x0, 0x00000000, 0x0, 0x30330300
#define IOMUXC_SD1_DATA3_ENET1_RGMII_RD1                    0x303300A0, 0x1, 0x30330584, 0x0, 0x30330300
#define IOMUXC_SD1_DATA3_I2C4_SDA                           0x303300A0, 0x3, 0x303305C0, 0x0, 0x30330300
#define IOMUXC_SD1_DATA3_UART2_RX                           0x303300A0, 0x4, 0x303305F0, 0x1, 0x30330300
#define IOMUXC_SD1_DATA3_UART2_TX                           0x303300A0, 0x4, 0x00000000, 0x0, 0x30330300
#define IOMUXC_SD1_DATA3_GPIO2_IO05                         0x303300A0, 0x5, 0x00000000, 0x0, 0x30330300
#define IOMUXC_SD1_DATA4_USDHC1_DATA4                       0x303300A4, 0x0, 0x00000000, 0x0, 0x30330304
#define IOMUXC_SD1_DATA4_ENET1_RGMII_TX_CTL                 0x303300A4, 0x1, 0x00000000, 0x0, 0x30330304
#define IOMUXC_SD1_DATA4_I2C1_SCL                           0x303300A4, 0x3, 0x303305A4, 0x0, 0x30330304
#define IOMUXC_SD1_DATA4_UART2_RTS_B                        0x303300A4, 0x4, 0x303305EC, 0x0, 0x30330304
#define IOMUXC_SD1_DATA4_UART2_CTS_B                        0x303300A4, 0x4, 0x00000000, 0x0, 0x30330304
#define IOMUXC_SD1_DATA4_GPIO2_IO06                         0x303300A4, 0x5, 0x00000000, 0x0, 0x30330304
#define IOMUXC_SD1_DATA5_USDHC1_DATA5                       0x303300A8, 0x0, 0x00000000, 0x0, 0x30330308
#define IOMUXC_SD1_DATA5_ENET1_TX_ER                        0x303300A8, 0x1, 0x00000000, 0x0, 0x30330308
#define IOMUXC_SD1_DATA5_I2C1_SDA                           0x303300A8, 0x3, 0x303305A8, 0x0, 0x30330308
#define IOMUXC_SD1_DATA5_UART2_CTS_B                        0x303300A8, 0x4, 0x00000000, 0x0, 0x30330308
#define IOMUXC_SD1_DATA5_UART2_RTS_B                        0x303300A8, 0x4, 0x303305EC, 0x1, 0x30330308
#define IOMUXC_SD1_DATA5_GPIO2_IO07                         0x303300A8, 0x5, 0x00000000, 0x0, 0x30330308
#define IOMUXC_SD1_DATA6_USDHC1_DATA6                       0x303300AC, 0x0, 0x00000000, 0x0, 0x3033030C
#define IOMUXC_SD1_DATA6_ENET1_RGMII_RX_CTL                 0x303300AC, 0x1, 0x30330588, 0x0, 0x3033030C
#define IOMUXC_SD1_DATA6_I2C2_SCL                           0x303300AC, 0x3, 0x303305AC, 0x0, 0x3033030C
#define IOMUXC_SD1_DATA6_UART3_TX                           0x303300AC, 0x4, 0x00000000, 0x0, 0x3033030C
#define IOMUXC_SD1_DATA6_UART3_RX                           0x303300AC, 0x4, 0x303305F8, 0x0, 0x3033030C
#define IOMUXC_SD1_DATA6_GPIO2_IO08                         0x303300AC, 0x5, 0x00000000, 0x0, 0x3033030C
#define IOMUXC_SD1_DATA7_USDHC1_DATA7                       0x303300B0, 0x0, 0x00000000, 0x0, 0x30330310
#define IOMUXC_SD1_DATA7_ENET1_RX_ER                        0x303300B0, 0x1, 0x3033058C, 0x0, 0x30330310
#define IOMUXC_SD1_DATA7_I2C2_SDA                           0x303300B0, 0x3, 0x303305B0, 0x0, 0x30330310
#define IOMUXC_SD1_DATA7_UART3_RX                           0x303300B0, 0x4, 0x303305F8, 0x1, 0x30330310
#define IOMUXC_SD1_DATA7_UART3_TX                           0x303300B0, 0x4, 0x00000000, 0x0, 0x30330310
#define IOMUXC_SD1_DATA7_GPIO2_IO09                         0x303300B0, 0x5, 0x00000000, 0x0, 0x30330310
#define IOMUXC_SD1_RESET_B_USDHC1_RESET_B                   0x303300B4, 0x0, 0x00000000, 0x0, 0x30330314
#define IOMUXC_SD1_RESET_B_ENET1_TX_CLK                     0x303300B4, 0x1, 0x30330578, 0x0, 0x30330314
#define IOMUXC_SD1_RESET_B_I2C3_SCL                         0x303300B4, 0x3, 0x303305B4, 0x0, 0x30330314
#define IOMUXC_SD1_RESET_B_UART3_RTS_B                      0x303300B4, 0x4, 0x303305F4, 0x0, 0x30330314
#define IOMUXC_SD1_RESET_B_UART3_CTS_B                      0x303300B4, 0x4, 0x00000000, 0x0, 0x30330314
#define IOMUXC_SD1_RESET_B_GPIO2_IO10                       0x303300B4, 0x5, 0x00000000, 0x0, 0x30330314
#define IOMUXC_SD1_STROBE_USDHC1_STROBE                     0x303300B8, 0x0, 0x00000000, 0x0, 0x30330318
#define IOMUXC_SD1_STROBE_I2C3_SDA                          0x303300B8, 0x3, 0x303305B8, 0x0, 0x30330318
#define IOMUXC_SD1_STROBE_UART3_CTS_B                       0x303300B8, 0x4, 0x00000000, 0x0, 0x30330318
#define IOMUXC_SD1_STROBE_UART3_RTS_B                       0x303300B8, 0x4, 0x303305F4, 0x1, 0x30330318
#define IOMUXC_SD1_STROBE_GPIO2_IO11                        0x303300B8, 0x5, 0x00000000, 0x0, 0x30330318
#define IOMUXC_SD2_CD_B_USDHC2_CD_B                         0x303300BC, 0x0, 0x00000000, 0x0, 0x3033031C
#define IOMUXC_SD2_CD_B_GPIO2_IO12                          0x303300BC, 0x5, 0x00000000, 0x0, 0x3033031C
#define IOMUXC_SD2_CLK_USDHC2_CLK                           0x303300C0, 0x0, 0x00000000, 0x0, 0x30330320
#define IOMUXC_SD2_CLK_ECSPI2_SCLK                          0x303300C0, 0x2, 0x30330568, 0x0, 0x30330320
#define IOMUXC_SD2_CLK_UART4_RX                             0x303300C0, 0x3, 0x30330600, 0x0, 0x30330320
#define IOMUXC_SD2_CLK_UART4_TX                             0x303300C0, 0x3, 0x00000000, 0x0, 0x30330320
#define IOMUXC_SD2_CLK_GPIO2_IO13                           0x303300C0, 0x5, 0x00000000, 0x0, 0x30330320
#define IOMUXC_SD2_CMD_USDHC2_CMD                           0x303300C4, 0x0, 0x00000000, 0x0, 0x30330324
#define IOMUXC_SD2_CMD_ECSPI2_MOSI                          0x303300C4, 0x2, 0x30330570, 0x0, 0x30330324
#define IOMUXC_SD2_CMD_UART4_TX                             0x303300C4, 0x3, 0x00000000, 0x0, 0x30330324
#define IOMUXC_SD2_CMD_UART4_RX                             0x303300C4, 0x3, 0x30330600, 0x1, 0x30330324
#define IOMUXC_SD2_CMD_AUDIOMIX_PDM_CLK                     0x303300C4, 0x4, 0x00000000, 0x0, 0x30330324
#define IOMUXC_SD2_CMD_GPIO2_IO14                           0x303300C4, 0x5, 0x00000000, 0x0, 0x30330324
#define IOMUXC_SD2_DATA0_USDHC2_DATA0                       0x303300C8, 0x0, 0x00000000, 0x0, 0x30330328
#define IOMUXC_SD2_DATA0_I2C4_SDA                           0x303300C8, 0x2, 0x303305C0, 0x1, 0x30330328
#define IOMUXC_SD2_DATA0_UART2_RX                           0x303300C8, 0x3, 0x303305F0, 0x2, 0x30330328
#define IOMUXC_SD2_DATA0_UART2_TX                           0x303300C8, 0x3, 0x00000000, 0x0, 0x30330328
#define IOMUXC_SD2_DATA0_AUDIOMIX_PDM_BIT_STREAM0           0x303300C8, 0x4, 0x303304C0, 0x2, 0x30330328
#define IOMUXC_SD2_DATA0_GPIO2_IO15                         0x303300C8, 0x5, 0x00000000, 0x0, 0x30330328
#define IOMUXC_SD2_DATA1_USDHC2_DATA1                       0x303300CC, 0x0, 0x00000000, 0x0, 0x3033032C
#define IOMUXC_SD2_DATA1_I2C4_SCL                           0x303300CC, 0x2, 0x303305BC, 0x1, 0x3033032C
#define IOMUXC_SD2_DATA1_UART2_TX                           0x303300CC, 0x3, 0x00000000, 0x0, 0x3033032C
#define IOMUXC_SD2_DATA1_UART2_RX                           0x303300CC, 0x3, 0x303305F0, 0x3, 0x3033032C
#define IOMUXC_SD2_DATA1_AUDIOMIX_PDM_BIT_STREAM1           0x303300CC, 0x4, 0x303304C4, 0x2, 0x3033032C
#define IOMUXC_SD2_DATA1_GPIO2_IO16                         0x303300CC, 0x5, 0x00000000, 0x0, 0x3033032C
#define IOMUXC_SD2_DATA2_USDHC2_DATA2                       0x303300D0, 0x0, 0x00000000, 0x0, 0x30330330
#define IOMUXC_SD2_DATA2_ECSPI2_SS0                         0x303300D0, 0x2, 0x30330574, 0x0, 0x30330330
#define IOMUXC_SD2_DATA2_AUDIOMIX_SPDIF1_OUT                0x303300D0, 0x3, 0x00000000, 0x0, 0x30330330
#define IOMUXC_SD2_DATA2_AUDIOMIX_PDM_BIT_STREAM2           0x303300D0, 0x4, 0x303304C8, 0x2, 0x30330330
#define IOMUXC_SD2_DATA2_GPIO2_IO17                         0x303300D0, 0x5, 0x00000000, 0x0, 0x30330330
#define IOMUXC_SD2_DATA3_USDHC2_DATA3                       0x303300D4, 0x0, 0x00000000, 0x0, 0x30330334
#define IOMUXC_SD2_DATA3_ECSPI2_MISO                        0x303300D4, 0x2, 0x3033056C, 0x0, 0x30330334
#define IOMUXC_SD2_DATA3_AUDIOMIX_SPDIF1_IN                 0x303300D4, 0x3, 0x30330544, 0x1, 0x30330334
#define IOMUXC_SD2_DATA3_AUDIOMIX_PDM_BIT_STREAM3           0x303300D4, 0x4, 0x303304CC, 0x2, 0x30330334
#define IOMUXC_SD2_DATA3_GPIO2_IO18                         0x303300D4, 0x5, 0x00000000, 0x0, 0x30330334
#define IOMUXC_SD2_RESET_B_USDHC2_RESET_B                   0x303300D8, 0x0, 0x00000000, 0x0, 0x30330338
#define IOMUXC_SD2_RESET_B_GPIO2_IO19                       0x303300D8, 0x5, 0x00000000, 0x0, 0x30330338
#define IOMUXC_SD2_WP_USDHC2_WP                             0x303300DC, 0x0, 0x00000000, 0x0, 0x3033033C
#define IOMUXC_SD2_WP_GPIO2_IO20                            0x303300DC, 0x5, 0x00000000, 0x0, 0x3033033C
#define IOMUXC_SD2_WP_CORESIGHT_EVENTI                      0x303300DC, 0x6, 0x00000000, 0x0, 0x3033033C
#define IOMUXC_NAND_ALE_NAND_ALE                            0x303300E0, 0x0, 0x00000000, 0x0, 0x30330340
#define IOMUXC_NAND_ALE_FLEXSPI_A_SCLK                      0x303300E0, 0x1, 0x00000000, 0x0, 0x30330340
#define IOMUXC_NAND_ALE_AUDIOMIX_SAI3_TX_BCLK               0x303300E0, 0x2, 0x303304E8, 0x0, 0x30330340
#define IOMUXC_NAND_ALE_ISP_FL_TRIG_0                       0x303300E0, 0x3, 0x303305D4, 0x1, 0x30330340
#define IOMUXC_NAND_ALE_UART3_RX                            0x303300E0, 0x4, 0x303305F8, 0x2, 0x30330340
#define IOMUXC_NAND_ALE_UART3_TX                            0x303300E0, 0x4, 0x00000000, 0x0, 0x30330340
#define IOMUXC_NAND_ALE_GPIO3_IO00                          0x303300E0, 0x5, 0x00000000, 0x0, 0x30330340
#define IOMUXC_NAND_ALE_CORESIGHT_TRACE_CLK                 0x303300E0, 0x6, 0x00000000, 0x0, 0x30330340
#define IOMUXC_NAND_CE0_B_NAND_CE0_B                        0x303300E4, 0x0, 0x00000000, 0x0, 0x30330344
#define IOMUXC_NAND_CE0_B_FLEXSPI_A_SS0_B                   0x303300E4, 0x1, 0x00000000, 0x0, 0x30330344
#define IOMUXC_NAND_CE0_B_AUDIOMIX_SAI3_TX_DATA0            0x303300E4, 0x2, 0x00000000, 0x0, 0x30330344
#define IOMUXC_NAND_CE0_B_ISP_SHUTTER_TRIG_0                0x303300E4, 0x3, 0x303305DC, 0x1, 0x30330344
#define IOMUXC_NAND_CE0_B_UART3_TX                          0x303300E4, 0x4, 0x00000000, 0x0, 0x30330344
#define IOMUXC_NAND_CE0_B_UART3_RX                          0x303300E4, 0x4, 0x303305F8, 0x3, 0x30330344
#define IOMUXC_NAND_CE0_B_GPIO3_IO01                        0x303300E4, 0x5, 0x00000000, 0x0, 0x30330344
#define IOMUXC_NAND_CE0_B_CORESIGHT_TRACE_CTL               0x303300E4, 0x6, 0x00000000, 0x0, 0x30330344
#define IOMUXC_NAND_CE1_B_NAND_CE1_B                        0x303300E8, 0x0, 0x00000000, 0x0, 0x30330348
#define IOMUXC_NAND_CE1_B_FLEXSPI_A_SS1_B                   0x303300E8, 0x1, 0x00000000, 0x0, 0x30330348
#define IOMUXC_NAND_CE1_B_USDHC3_STROBE                     0x303300E8, 0x2, 0x30330630, 0x1, 0x30330348
#define IOMUXC_NAND_CE1_B_I2C4_SCL                          0x303300E8, 0x4, 0x303305BC, 0x2, 0x30330348
#define IOMUXC_NAND_CE1_B_GPIO3_IO02                        0x303300E8, 0x5, 0x00000000, 0x0, 0x30330348
#define IOMUXC_NAND_CE1_B_CORESIGHT_TRACE00                 0x303300E8, 0x6, 0x00000000, 0x0, 0x30330348
#define IOMUXC_NAND_CE2_B_NAND_CE2_B                        0x303300EC, 0x0, 0x00000000, 0x0, 0x3033034C
#define IOMUXC_NAND_CE2_B_FLEXSPI_B_SS0_B                   0x303300EC, 0x1, 0x00000000, 0x0, 0x3033034C
#define IOMUXC_NAND_CE2_B_USDHC3_DATA5                      0x303300EC, 0x2, 0x30330624, 0x1, 0x3033034C
#define IOMUXC_NAND_CE2_B_I2C4_SDA                          0x303300EC, 0x4, 0x303305C0, 0x2, 0x3033034C
#define IOMUXC_NAND_CE2_B_GPIO3_IO03                        0x303300EC, 0x5, 0x00000000, 0x0, 0x3033034C
#define IOMUXC_NAND_CE2_B_CORESIGHT_TRACE01                 0x303300EC, 0x6, 0x00000000, 0x0, 0x3033034C
#define IOMUXC_NAND_CE3_B_NAND_CE3_B                        0x303300F0, 0x0, 0x00000000, 0x0, 0x30330350
#define IOMUXC_NAND_CE3_B_FLEXSPI_B_SS1_B                   0x303300F0, 0x1, 0x00000000, 0x0, 0x30330350
#define IOMUXC_NAND_CE3_B_USDHC3_DATA6                      0x303300F0, 0x2, 0x30330628, 0x1, 0x30330350
#define IOMUXC_NAND_CE3_B_I2C3_SDA                          0x303300F0, 0x4, 0x303305B8, 0x1, 0x30330350
#define IOMUXC_NAND_CE3_B_GPIO3_IO04                        0x303300F0, 0x5, 0x00000000, 0x0, 0x30330350
#define IOMUXC_NAND_CE3_B_CORESIGHT_TRACE02                 0x303300F0, 0x6, 0x00000000, 0x0, 0x30330350
#define IOMUXC_NAND_CLE_NAND_CLE                            0x303300F4, 0x0, 0x00000000, 0x0, 0x30330354
#define IOMUXC_NAND_CLE_FLEXSPI_B_SCLK                      0x303300F4, 0x1, 0x00000000, 0x0, 0x30330354
#define IOMUXC_NAND_CLE_USDHC3_DATA7                        0x303300F4, 0x2, 0x3033062C, 0x1, 0x30330354
#define IOMUXC_NAND_CLE_UART4_RX                            0x303300F4, 0x4, 0x30330600, 0x2, 0x30330354
#define IOMUXC_NAND_CLE_UART4_TX                            0x303300F4, 0x4, 0x00000000, 0x0, 0x30330354
#define IOMUXC_NAND_CLE_GPIO3_IO05                          0x303300F4, 0x5, 0x00000000, 0x0, 0x30330354
#define IOMUXC_NAND_CLE_CORESIGHT_TRACE03                   0x303300F4, 0x6, 0x00000000, 0x0, 0x30330354
#define IOMUXC_NAND_DATA00_NAND_DATA00                      0x303300F8, 0x0, 0x00000000, 0x0, 0x30330358
#define IOMUXC_NAND_DATA00_FLEXSPI_A_DATA0                  0x303300F8, 0x1, 0x00000000, 0x0, 0x30330358
#define IOMUXC_NAND_DATA00_AUDIOMIX_SAI3_RX_DATA0           0x303300F8, 0x2, 0x303304E4, 0x0, 0x30330358
#define IOMUXC_NAND_DATA00_ISP_FLASH_TRIG_0                 0x303300F8, 0x3, 0x00000000, 0x0, 0x30330358
#define IOMUXC_NAND_DATA00_UART4_RX                         0x303300F8, 0x4, 0x30330600, 0x3, 0x30330358
#define IOMUXC_NAND_DATA00_UART4_TX                         0x303300F8, 0x4, 0x00000000, 0x0, 0x30330358
#define IOMUXC_NAND_DATA00_GPIO3_IO06                       0x303300F8, 0x5, 0x00000000, 0x0, 0x30330358
#define IOMUXC_NAND_DATA00_CORESIGHT_TRACE04                0x303300F8, 0x6, 0x00000000, 0x0, 0x30330358
#define IOMUXC_NAND_DATA01_NAND_DATA01                      0x303300FC, 0x0, 0x00000000, 0x0, 0x3033035C
#define IOMUXC_NAND_DATA01_FLEXSPI_A_DATA1                  0x303300FC, 0x1, 0x00000000, 0x0, 0x3033035C
#define IOMUXC_NAND_DATA01_AUDIOMIX_SAI3_TX_SYNC            0x303300FC, 0x2, 0x303304EC, 0x0, 0x3033035C
#define IOMUXC_NAND_DATA01_ISP_PRELIGHT_TRIG_0              0x303300FC, 0x3, 0x00000000, 0x0, 0x3033035C
#define IOMUXC_NAND_DATA01_UART4_TX                         0x303300FC, 0x4, 0x00000000, 0x0, 0x3033035C
#define IOMUXC_NAND_DATA01_UART4_RX                         0x303300FC, 0x4, 0x30330600, 0x4, 0x3033035C
#define IOMUXC_NAND_DATA01_GPIO3_IO07                       0x303300FC, 0x5, 0x00000000, 0x0, 0x3033035C
#define IOMUXC_NAND_DATA01_CORESIGHT_TRACE05                0x303300FC, 0x6, 0x00000000, 0x0, 0x3033035C
#define IOMUXC_NAND_DATA02_NAND_DATA02                      0x30330100, 0x0, 0x00000000, 0x0, 0x30330360
#define IOMUXC_NAND_DATA02_FLEXSPI_A_DATA2                  0x30330100, 0x1, 0x00000000, 0x0, 0x30330360
#define IOMUXC_NAND_DATA02_USDHC3_CD_B                      0x30330100, 0x2, 0x30330608, 0x2, 0x30330360
#define IOMUXC_NAND_DATA02_UART4_CTS_B                      0x30330100, 0x3, 0x00000000, 0x0, 0x30330360
#define IOMUXC_NAND_DATA02_UART4_RTS_B                      0x30330100, 0x3, 0x303305FC, 0x0, 0x30330360
#define IOMUXC_NAND_DATA02_I2C4_SDA                         0x30330100, 0x4, 0x303305C0, 0x3, 0x30330360
#define IOMUXC_NAND_DATA02_GPIO3_IO08                       0x30330100, 0x5, 0x00000000, 0x0, 0x30330360
#define IOMUXC_NAND_DATA02_CORESIGHT_TRACE06                0x30330100, 0x6, 0x00000000, 0x0, 0x30330360
#define IOMUXC_NAND_DATA03_NAND_DATA03                      0x30330104, 0x0, 0x00000000, 0x0, 0x30330364
#define IOMUXC_NAND_DATA03_FLEXSPI_A_DATA3                  0x30330104, 0x1, 0x00000000, 0x0, 0x30330364
#define IOMUXC_NAND_DATA03_USDHC3_WP                        0x30330104, 0x2, 0x30330634, 0x2, 0x30330364
#define IOMUXC_NAND_DATA03_UART4_RTS_B                      0x30330104, 0x3, 0x303305FC, 0x1, 0x30330364
#define IOMUXC_NAND_DATA03_UART4_CTS_B                      0x30330104, 0x3, 0x00000000, 0x0, 0x30330364
#define IOMUXC_NAND_DATA03_ISP_FL_TRIG_1                    0x30330104, 0x4, 0x303305D8, 0x1, 0x30330364
#define IOMUXC_NAND_DATA03_GPIO3_IO09                       0x30330104, 0x5, 0x00000000, 0x0, 0x30330364
#define IOMUXC_NAND_DATA03_CORESIGHT_TRACE07                0x30330104, 0x6, 0x00000000, 0x0, 0x30330364
#define IOMUXC_NAND_DATA04_NAND_DATA04                      0x30330108, 0x0, 0x00000000, 0x0, 0x30330368
#define IOMUXC_NAND_DATA04_FLEXSPI_B_DATA0                  0x30330108, 0x1, 0x00000000, 0x0, 0x30330368
#define IOMUXC_NAND_DATA04_USDHC3_DATA0                     0x30330108, 0x2, 0x30330610, 0x1, 0x30330368
#define IOMUXC_NAND_DATA04_FLEXSPI_A_DATA4                  0x30330108, 0x3, 0x00000000, 0x0, 0x30330368
#define IOMUXC_NAND_DATA04_ISP_SHUTTER_TRIG_1               0x30330108, 0x4, 0x303305E0, 0x1, 0x30330368
#define IOMUXC_NAND_DATA04_GPIO3_IO10                       0x30330108, 0x5, 0x00000000, 0x0, 0x30330368
#define IOMUXC_NAND_DATA04_CORESIGHT_TRACE08                0x30330108, 0x6, 0x00000000, 0x0, 0x30330368
#define IOMUXC_NAND_DATA05_NAND_DATA05                      0x3033010C, 0x0, 0x00000000, 0x0, 0x3033036C
#define IOMUXC_NAND_DATA05_FLEXSPI_B_DATA1                  0x3033010C, 0x1, 0x00000000, 0x0, 0x3033036C
#define IOMUXC_NAND_DATA05_USDHC3_DATA1                     0x3033010C, 0x2, 0x30330614, 0x1, 0x3033036C
#define IOMUXC_NAND_DATA05_FLEXSPI_A_DATA5                  0x3033010C, 0x3, 0x00000000, 0x0, 0x3033036C
#define IOMUXC_NAND_DATA05_ISP_FLASH_TRIG_1                 0x3033010C, 0x4, 0x00000000, 0x0, 0x3033036C
#define IOMUXC_NAND_DATA05_GPIO3_IO11                       0x3033010C, 0x5, 0x00000000, 0x0, 0x3033036C
#define IOMUXC_NAND_DATA05_CORESIGHT_TRACE09                0x3033010C, 0x6, 0x00000000, 0x0, 0x3033036C
#define IOMUXC_NAND_DATA06_NAND_DATA06                      0x30330110, 0x0, 0x00000000, 0x0, 0x30330370
#define IOMUXC_NAND_DATA06_FLEXSPI_B_DATA2                  0x30330110, 0x1, 0x00000000, 0x0, 0x30330370
#define IOMUXC_NAND_DATA06_USDHC3_DATA2                     0x30330110, 0x2, 0x30330618, 0x1, 0x30330370
#define IOMUXC_NAND_DATA06_FLEXSPI_A_DATA6                  0x30330110, 0x3, 0x00000000, 0x0, 0x30330370
#define IOMUXC_NAND_DATA06_ISP_PRELIGHT_TRIG_1              0x30330110, 0x4, 0x00000000, 0x0, 0x30330370
#define IOMUXC_NAND_DATA06_GPIO3_IO12                       0x30330110, 0x5, 0x00000000, 0x0, 0x30330370
#define IOMUXC_NAND_DATA06_CORESIGHT_TRACE10                0x30330110, 0x6, 0x00000000, 0x0, 0x30330370
#define IOMUXC_NAND_DATA07_NAND_DATA07                      0x30330114, 0x0, 0x00000000, 0x0, 0x30330374
#define IOMUXC_NAND_DATA07_FLEXSPI_B_DATA3                  0x30330114, 0x1, 0x00000000, 0x0, 0x30330374
#define IOMUXC_NAND_DATA07_USDHC3_DATA3                     0x30330114, 0x2, 0x3033061C, 0x1, 0x30330374
#define IOMUXC_NAND_DATA07_FLEXSPI_A_DATA7                  0x30330114, 0x3, 0x00000000, 0x0, 0x30330374
#define IOMUXC_NAND_DATA07_ISP_SHUTTER_OPEN_1               0x30330114, 0x4, 0x00000000, 0x0, 0x30330374
#define IOMUXC_NAND_DATA07_GPIO3_IO13                       0x30330114, 0x5, 0x00000000, 0x0, 0x30330374
#define IOMUXC_NAND_DATA07_CORESIGHT_TRACE11                0x30330114, 0x6, 0x00000000, 0x0, 0x30330374
#define IOMUXC_NAND_DQS_NAND_DQS                            0x30330118, 0x0, 0x00000000, 0x0, 0x30330378
#define IOMUXC_NAND_DQS_FLEXSPI_A_DQS                       0x30330118, 0x1, 0x00000000, 0x0, 0x30330378
#define IOMUXC_NAND_DQS_AUDIOMIX_SAI3_MCLK                  0x30330118, 0x2, 0x303304E0, 0x0, 0x30330378
#define IOMUXC_NAND_DQS_ISP_SHUTTER_OPEN_0                  0x30330118, 0x3, 0x00000000, 0x0, 0x30330378
#define IOMUXC_NAND_DQS_I2C3_SCL                            0x30330118, 0x4, 0x303305B4, 0x1, 0x30330378
#define IOMUXC_NAND_DQS_GPIO3_IO14                          0x30330118, 0x5, 0x00000000, 0x0, 0x30330378
#define IOMUXC_NAND_DQS_CORESIGHT_TRACE12                   0x30330118, 0x6, 0x00000000, 0x0, 0x30330378
#define IOMUXC_NAND_RE_B_NAND_RE_B                          0x3033011C, 0x0, 0x00000000, 0x0, 0x3033037C
#define IOMUXC_NAND_RE_B_FLEXSPI_B_DQS                      0x3033011C, 0x1, 0x00000000, 0x0, 0x3033037C
#define IOMUXC_NAND_RE_B_USDHC3_DATA4                       0x3033011C, 0x2, 0x30330620, 0x1, 0x3033037C
#define IOMUXC_NAND_RE_B_UART4_TX                           0x3033011C, 0x4, 0x00000000, 0x0, 0x3033037C
#define IOMUXC_NAND_RE_B_UART4_RX                           0x3033011C, 0x4, 0x30330600, 0x5, 0x3033037C
#define IOMUXC_NAND_RE_B_GPIO3_IO15                         0x3033011C, 0x5, 0x00000000, 0x0, 0x3033037C
#define IOMUXC_NAND_RE_B_CORESIGHT_TRACE13                  0x3033011C, 0x6, 0x00000000, 0x0, 0x3033037C
#define IOMUXC_NAND_READY_B_NAND_READY_B                    0x30330120, 0x0, 0x00000000, 0x0, 0x30330380
#define IOMUXC_NAND_READY_B_USDHC3_RESET_B                  0x30330120, 0x2, 0x00000000, 0x0, 0x30330380
#define IOMUXC_NAND_READY_B_I2C3_SCL                        0x30330120, 0x4, 0x303305B4, 0x2, 0x30330380
#define IOMUXC_NAND_READY_B_GPIO3_IO16                      0x30330120, 0x5, 0x00000000, 0x0, 0x30330380
#define IOMUXC_NAND_READY_B_CORESIGHT_TRACE14               0x30330120, 0x6, 0x00000000, 0x0, 0x30330380
#define IOMUXC_NAND_WE_B_NAND_WE_B                          0x30330124, 0x0, 0x00000000, 0x0, 0x30330384
#define IOMUXC_NAND_WE_B_USDHC3_CLK                         0x30330124, 0x2, 0x30330604, 0x1, 0x30330384
#define IOMUXC_NAND_WE_B_I2C3_SDA                           0x30330124, 0x4, 0x303305B8, 0x2, 0x30330384
#define IOMUXC_NAND_WE_B_GPIO3_IO17                         0x30330124, 0x5, 0x00000000, 0x0, 0x30330384
#define IOMUXC_NAND_WE_B_CORESIGHT_TRACE15                  0x30330124, 0x6, 0x00000000, 0x0, 0x30330384
#define IOMUXC_NAND_WP_B_NAND_WP_B                          0x30330128, 0x0, 0x00000000, 0x0, 0x30330388
#define IOMUXC_NAND_WP_B_USDHC3_CMD                         0x30330128, 0x2, 0x3033060C, 0x1, 0x30330388
#define IOMUXC_NAND_WP_B_I2C4_SCL                           0x30330128, 0x4, 0x303305BC, 0x3, 0x30330388
#define IOMUXC_NAND_WP_B_GPIO3_IO18                         0x30330128, 0x5, 0x00000000, 0x0, 0x30330388
#define IOMUXC_NAND_WP_B_CORESIGHT_EVENTO                   0x30330128, 0x6, 0x00000000, 0x0, 0x30330388
#define IOMUXC_SAI5_RXFS_AUDIOMIX_SAI5_RX_SYNC              0x3033012C, 0x0, 0x30330508, 0x0, 0x3033038C
#define IOMUXC_SAI5_RXFS_AUDIOMIX_SAI1_TX_DATA0             0x3033012C, 0x1, 0x00000000, 0x0, 0x3033038C
#define IOMUXC_SAI5_RXFS_PWM4_OUT                           0x3033012C, 0x2, 0x00000000, 0x0, 0x3033038C
#define IOMUXC_SAI5_RXFS_I2C6_SCL                           0x3033012C, 0x3, 0x303305CC, 0x1, 0x3033038C
#define IOMUXC_SAI5_RXFS_GPIO3_IO19                         0x3033012C, 0x5, 0x00000000, 0x0, 0x3033038C
#define IOMUXC_SAI5_RXC_AUDIOMIX_SAI5_RX_BCLK               0x30330130, 0x0, 0x303304F4, 0x0, 0x30330390
#define IOMUXC_SAI5_RXC_AUDIOMIX_SAI1_TX_DATA1              0x30330130, 0x1, 0x00000000, 0x0, 0x30330390
#define IOMUXC_SAI5_RXC_PWM3_OUT                            0x30330130, 0x2, 0x00000000, 0x0, 0x30330390
#define IOMUXC_SAI5_RXC_I2C6_SDA                            0x30330130, 0x3, 0x303305D0, 0x1, 0x30330390
#define IOMUXC_SAI5_RXC_AUDIOMIX_PDM_CLK                    0x30330130, 0x4, 0x00000000, 0x0, 0x30330390
#define IOMUXC_SAI5_RXC_GPIO3_IO20                          0x30330130, 0x5, 0x00000000, 0x0, 0x30330390
#define IOMUXC_SAI5_RXD0_AUDIOMIX_SAI5_RX_DATA0             0x30330134, 0x0, 0x303304F8, 0x0, 0x30330394
#define IOMUXC_SAI5_RXD0_AUDIOMIX_SAI1_TX_DATA2             0x30330134, 0x1, 0x00000000, 0x0, 0x30330394
#define IOMUXC_SAI5_RXD0_PWM2_OUT                           0x30330134, 0x2, 0x00000000, 0x0, 0x30330394
#define IOMUXC_SAI5_RXD0_I2C5_SCL                           0x30330134, 0x3, 0x303305C4, 0x1, 0x30330394
#define IOMUXC_SAI5_RXD0_AUDIOMIX_PDM_BIT_STREAM0           0x30330134, 0x4, 0x303304C0, 0x3, 0x30330394
#define IOMUXC_SAI5_RXD0_GPIO3_IO21                         0x30330134, 0x5, 0x00000000, 0x0, 0x30330394
#define IOMUXC_SAI5_RXD1_AUDIOMIX_SAI5_RX_DATA1             0x30330138, 0x0, 0x303304FC, 0x0, 0x30330398
#define IOMUXC_SAI5_RXD1_AUDIOMIX_SAI1_TX_DATA3             0x30330138, 0x1, 0x00000000, 0x0, 0x30330398
#define IOMUXC_SAI5_RXD1_AUDIOMIX_SAI1_TX_SYNC              0x30330138, 0x2, 0x303304D8, 0x0, 0x30330398
#define IOMUXC_SAI5_RXD1_AUDIOMIX_SAI5_TX_SYNC              0x30330138, 0x3, 0x30330510, 0x0, 0x30330398
#define IOMUXC_SAI5_RXD1_AUDIOMIX_PDM_BIT_STREAM1           0x30330138, 0x4, 0x303304C4, 0x3, 0x30330398
#define IOMUXC_SAI5_RXD1_GPIO3_IO22                         0x30330138, 0x5, 0x00000000, 0x0, 0x30330398
#define IOMUXC_SAI5_RXD1_CAN1_TX                            0x30330138, 0x6, 0x00000000, 0x0, 0x30330398
#define IOMUXC_SAI5_RXD2_AUDIOMIX_SAI5_RX_DATA2             0x3033013C, 0x0, 0x30330500, 0x0, 0x3033039C
#define IOMUXC_SAI5_RXD2_AUDIOMIX_SAI1_TX_DATA4             0x3033013C, 0x1, 0x00000000, 0x0, 0x3033039C
#define IOMUXC_SAI5_RXD2_AUDIOMIX_SAI1_TX_SYNC              0x3033013C, 0x2, 0x303304D8, 0x1, 0x3033039C
#define IOMUXC_SAI5_RXD2_AUDIOMIX_SAI5_TX_BCLK              0x3033013C, 0x3, 0x3033050C, 0x0, 0x3033039C
#define IOMUXC_SAI5_RXD2_AUDIOMIX_PDM_BIT_STREAM2           0x3033013C, 0x4, 0x303304C8, 0x3, 0x3033039C
#define IOMUXC_SAI5_RXD2_GPIO3_IO23                         0x3033013C, 0x5, 0x00000000, 0x0, 0x3033039C
#define IOMUXC_SAI5_RXD2_CAN1_RX                            0x3033013C, 0x6, 0x3033054C, 0x0, 0x3033039C
#define IOMUXC_SAI5_RXD3_AUDIOMIX_SAI5_RX_DATA3             0x30330140, 0x0, 0x30330504, 0x0, 0x303303A0
#define IOMUXC_SAI5_RXD3_AUDIOMIX_SAI1_TX_DATA5             0x30330140, 0x1, 0x00000000, 0x0, 0x303303A0
#define IOMUXC_SAI5_RXD3_AUDIOMIX_SAI1_TX_SYNC              0x30330140, 0x2, 0x303304D8, 0x2, 0x303303A0
#define IOMUXC_SAI5_RXD3_AUDIOMIX_SAI5_TX_DATA0             0x30330140, 0x3, 0x00000000, 0x0, 0x303303A0
#define IOMUXC_SAI5_RXD3_AUDIOMIX_PDM_BIT_STREAM3           0x30330140, 0x4, 0x303304CC, 0x3, 0x303303A0
#define IOMUXC_SAI5_RXD3_GPIO3_IO24                         0x30330140, 0x5, 0x00000000, 0x0, 0x303303A0
#define IOMUXC_SAI5_RXD3_CAN2_TX                            0x30330140, 0x6, 0x00000000, 0x0, 0x303303A0
#define IOMUXC_SAI5_MCLK_AUDIOMIX_SAI5_MCLK                 0x30330144, 0x0, 0x303304F0, 0x0, 0x303303A4
#define IOMUXC_SAI5_MCLK_AUDIOMIX_SAI1_TX_BCLK              0x30330144, 0x1, 0x303304D4, 0x0, 0x303303A4
#define IOMUXC_SAI5_MCLK_PWM1_OUT                           0x30330144, 0x2, 0x00000000, 0x0, 0x303303A4
#define IOMUXC_SAI5_MCLK_I2C5_SDA                           0x30330144, 0x3, 0x303305C8, 0x1, 0x303303A4
#define IOMUXC_SAI5_MCLK_GPIO3_IO25                         0x30330144, 0x5, 0x00000000, 0x0, 0x303303A4
#define IOMUXC_SAI5_MCLK_CAN2_RX                            0x30330144, 0x6, 0x30330550, 0x0, 0x303303A4
#define IOMUXC_SAI1_RXFS_AUDIOMIX_SAI1_RX_SYNC              0x30330148, 0x0, 0x303304D0, 0x0, 0x303303A8
#define IOMUXC_SAI1_RXFS_ENET1_1588_EVENT0_IN               0x30330148, 0x4, 0x00000000, 0x0, 0x303303A8
#define IOMUXC_SAI1_RXFS_GPIO4_IO00                         0x30330148, 0x5, 0x00000000, 0x0, 0x303303A8
#define IOMUXC_SAI1_RXC_AUDIOMIX_SAI1_RX_BCLK               0x3033014C, 0x0, 0x00000000, 0x0, 0x303303AC
#define IOMUXC_SAI1_RXC_AUDIOMIX_PDM_CLK                    0x3033014C, 0x3, 0x00000000, 0x0, 0x303303AC
#define IOMUXC_SAI1_RXC_ENET1_1588_EVENT0_OUT               0x3033014C, 0x4, 0x00000000, 0x0, 0x303303AC
#define IOMUXC_SAI1_RXC_GPIO4_IO01                          0x3033014C, 0x5, 0x00000000, 0x0, 0x303303AC
#define IOMUXC_SAI1_RXD0_AUDIOMIX_SAI1_RX_DATA0             0x30330150, 0x0, 0x00000000, 0x0, 0x303303B0
#define IOMUXC_SAI1_RXD0_AUDIOMIX_SAI1_TX_DATA1             0x30330150, 0x2, 0x00000000, 0x0, 0x303303B0
#define IOMUXC_SAI1_RXD0_AUDIOMIX_PDM_BIT_STREAM0           0x30330150, 0x3, 0x303304C0, 0x4, 0x303303B0
#define IOMUXC_SAI1_RXD0_ENET1_1588_EVENT1_IN               0x30330150, 0x4, 0x00000000, 0x0, 0x303303B0
#define IOMUXC_SAI1_RXD0_GPIO4_IO02                         0x30330150, 0x5, 0x00000000, 0x0, 0x303303B0
#define IOMUXC_SAI1_RXD1_AUDIOMIX_SAI1_RX_DATA1             0x30330154, 0x0, 0x00000000, 0x0, 0x303303B4
#define IOMUXC_SAI1_RXD1_AUDIOMIX_PDM_BIT_STREAM1           0x30330154, 0x3, 0x303304C4, 0x4, 0x303303B4
#define IOMUXC_SAI1_RXD1_ENET1_1588_EVENT1_OUT              0x30330154, 0x4, 0x00000000, 0x0, 0x303303B4
#define IOMUXC_SAI1_RXD1_GPIO4_IO03                         0x30330154, 0x5, 0x00000000, 0x0, 0x303303B4
#define IOMUXC_SAI1_RXD2_AUDIOMIX_SAI1_RX_DATA2             0x30330158, 0x0, 0x00000000, 0x0, 0x303303B8
#define IOMUXC_SAI1_RXD2_AUDIOMIX_PDM_BIT_STREAM2           0x30330158, 0x3, 0x303304C8, 0x4, 0x303303B8
#define IOMUXC_SAI1_RXD2_ENET1_MDC                          0x30330158, 0x4, 0x00000000, 0x0, 0x303303B8
#define IOMUXC_SAI1_RXD2_GPIO4_IO04                         0x30330158, 0x5, 0x00000000, 0x0, 0x303303B8
#define IOMUXC_SAI1_RXD3_AUDIOMIX_SAI1_RX_DATA3             0x3033015C, 0x0, 0x00000000, 0x0, 0x303303BC
#define IOMUXC_SAI1_RXD3_AUDIOMIX_PDM_BIT_STREAM3           0x3033015C, 0x3, 0x303304CC, 0x4, 0x303303BC
#define IOMUXC_SAI1_RXD3_ENET1_MDIO                         0x3033015C, 0x4, 0x3033057C, 0x1, 0x303303BC
#define IOMUXC_SAI1_RXD3_GPIO4_IO05                         0x3033015C, 0x5, 0x00000000, 0x0, 0x303303BC
#define IOMUXC_SAI1_RXD4_AUDIOMIX_SAI1_RX_DATA4             0x30330160, 0x0, 0x00000000, 0x0, 0x303303C0
#define IOMUXC_SAI1_RXD4_AUDIOMIX_SAI6_TX_BCLK              0x30330160, 0x1, 0x30330524, 0x1, 0x303303C0
#define IOMUXC_SAI1_RXD4_AUDIOMIX_SAI6_RX_BCLK              0x30330160, 0x2, 0x30330518, 0x1, 0x303303C0
#define IOMUXC_SAI1_RXD4_ENET1_RGMII_RD0                    0x30330160, 0x4, 0x30330580, 0x1, 0x303303C0
#define IOMUXC_SAI1_RXD4_GPIO4_IO06                         0x30330160, 0x5, 0x00000000, 0x0, 0x303303C0
#define IOMUXC_SAI1_RXD5_AUDIOMIX_SAI1_RX_DATA5             0x30330164, 0x0, 0x00000000, 0x0, 0x303303C4
#define IOMUXC_SAI1_RXD5_AUDIOMIX_SAI6_TX_DATA0             0x30330164, 0x1, 0x00000000, 0x0, 0x303303C4
#define IOMUXC_SAI1_RXD5_AUDIOMIX_SAI6_RX_DATA0             0x30330164, 0x2, 0x3033051C, 0x1, 0x303303C4
#define IOMUXC_SAI1_RXD5_AUDIOMIX_SAI1_RX_SYNC              0x30330164, 0x3, 0x303304D0, 0x1, 0x303303C4
#define IOMUXC_SAI1_RXD5_ENET1_RGMII_RD1                    0x30330164, 0x4, 0x30330584, 0x1, 0x303303C4
#define IOMUXC_SAI1_RXD5_GPIO4_IO07                         0x30330164, 0x5, 0x00000000, 0x0, 0x303303C4
#define IOMUXC_SAI1_RXD6_AUDIOMIX_SAI1_RX_DATA6             0x30330168, 0x0, 0x00000000, 0x0, 0x303303C8
#define IOMUXC_SAI1_RXD6_AUDIOMIX_SAI6_TX_SYNC              0x30330168, 0x1, 0x30330528, 0x1, 0x303303C8
#define IOMUXC_SAI1_RXD6_AUDIOMIX_SAI6_RX_SYNC              0x30330168, 0x2, 0x30330520, 0x1, 0x303303C8
#define IOMUXC_SAI1_RXD6_ENET1_RGMII_RD2                    0x30330168, 0x4, 0x00000000, 0x0, 0x303303C8
#define IOMUXC_SAI1_RXD6_GPIO4_IO08                         0x30330168, 0x5, 0x00000000, 0x0, 0x303303C8
#define IOMUXC_SAI1_RXD7_AUDIOMIX_SAI1_RX_DATA7             0x3033016C, 0x0, 0x00000000, 0x0, 0x303303CC
#define IOMUXC_SAI1_RXD7_AUDIOMIX_SAI6_MCLK                 0x3033016C, 0x1, 0x30330514, 0x1, 0x303303CC
#define IOMUXC_SAI1_RXD7_AUDIOMIX_SAI1_TX_SYNC              0x3033016C, 0x2, 0x303304D8, 0x3, 0x303303CC
#define IOMUXC_SAI1_RXD7_AUDIOMIX_SAI1_TX_DATA4             0x3033016C, 0x3, 0x00000000, 0x0, 0x303303CC
#define IOMUXC_SAI1_RXD7_ENET1_RGMII_RD3                    0x3033016C, 0x4, 0x00000000, 0x0, 0x303303CC
#define IOMUXC_SAI1_RXD7_GPIO4_IO09                         0x3033016C, 0x5, 0x00000000, 0x0, 0x303303CC
#define IOMUXC_SAI1_TXFS_AUDIOMIX_SAI1_TX_SYNC              0x30330170, 0x0, 0x303304D8, 0x4, 0x303303D0
#define IOMUXC_SAI1_TXFS_ENET1_RGMII_RX_CTL                 0x30330170, 0x4, 0x30330588, 0x1, 0x303303D0
#define IOMUXC_SAI1_TXFS_GPIO4_IO10                         0x30330170, 0x5, 0x00000000, 0x0, 0x303303D0
#define IOMUXC_SAI1_TXC_AUDIOMIX_SAI1_TX_BCLK               0x30330174, 0x0, 0x303304D4, 0x1, 0x303303D4
#define IOMUXC_SAI1_TXC_ENET1_RGMII_RXC                     0x30330174, 0x4, 0x00000000, 0x0, 0x303303D4
#define IOMUXC_SAI1_TXC_GPIO4_IO11                          0x30330174, 0x5, 0x00000000, 0x0, 0x303303D4
#define IOMUXC_SAI1_TXD0_AUDIOMIX_SAI1_TX_DATA0             0x30330178, 0x0, 0x00000000, 0x0, 0x303303D8
#define IOMUXC_SAI1_TXD0_ENET1_RGMII_TD0                    0x30330178, 0x4, 0x00000000, 0x0, 0x303303D8
#define IOMUXC_SAI1_TXD0_GPIO4_IO12                         0x30330178, 0x5, 0x00000000, 0x0, 0x303303D8
#define IOMUXC_SAI1_TXD1_AUDIOMIX_SAI1_TX_DATA1             0x3033017C, 0x0, 0x00000000, 0x0, 0x303303DC
#define IOMUXC_SAI1_TXD1_ENET1_RGMII_TD1                    0x3033017C, 0x4, 0x00000000, 0x0, 0x303303DC
#define IOMUXC_SAI1_TXD1_GPIO4_IO13                         0x3033017C, 0x5, 0x00000000, 0x0, 0x303303DC
#define IOMUXC_SAI1_TXD2_AUDIOMIX_SAI1_TX_DATA2             0x30330180, 0x0, 0x00000000, 0x0, 0x303303E0
#define IOMUXC_SAI1_TXD2_ENET1_RGMII_TD2                    0x30330180, 0x4, 0x00000000, 0x0, 0x303303E0
#define IOMUXC_SAI1_TXD2_GPIO4_IO14                         0x30330180, 0x5, 0x00000000, 0x0, 0x303303E0
#define IOMUXC_SAI1_TXD3_AUDIOMIX_SAI1_TX_DATA3             0x30330184, 0x0, 0x00000000, 0x0, 0x303303E4
#define IOMUXC_SAI1_TXD3_ENET1_RGMII_TD3                    0x30330184, 0x4, 0x00000000, 0x0, 0x303303E4
#define IOMUXC_SAI1_TXD3_GPIO4_IO15                         0x30330184, 0x5, 0x00000000, 0x0, 0x303303E4
#define IOMUXC_SAI1_TXD4_AUDIOMIX_SAI1_TX_DATA4             0x30330188, 0x0, 0x00000000, 0x0, 0x303303E8
#define IOMUXC_SAI1_TXD4_AUDIOMIX_SAI6_RX_BCLK              0x30330188, 0x1, 0x30330518, 0x2, 0x303303E8
#define IOMUXC_SAI1_TXD4_AUDIOMIX_SAI6_TX_BCLK              0x30330188, 0x2, 0x30330524, 0x2, 0x303303E8
#define IOMUXC_SAI1_TXD4_ENET1_RGMII_TX_CTL                 0x30330188, 0x4, 0x00000000, 0x0, 0x303303E8
#define IOMUXC_SAI1_TXD4_GPIO4_IO16                         0x30330188, 0x5, 0x00000000, 0x0, 0x303303E8
#define IOMUXC_SAI1_TXD5_AUDIOMIX_SAI1_TX_DATA5             0x3033018C, 0x0, 0x00000000, 0x0, 0x303303EC
#define IOMUXC_SAI1_TXD5_AUDIOMIX_SAI6_RX_DATA0             0x3033018C, 0x1, 0x3033051C, 0x2, 0x303303EC
#define IOMUXC_SAI1_TXD5_AUDIOMIX_SAI6_TX_DATA0             0x3033018C, 0x2, 0x00000000, 0x0, 0x303303EC
#define IOMUXC_SAI1_TXD5_ENET1_RGMII_TXC                    0x3033018C, 0x4, 0x00000000, 0x0, 0x303303EC
#define IOMUXC_SAI1_TXD5_GPIO4_IO17                         0x3033018C, 0x5, 0x00000000, 0x0, 0x303303EC
#define IOMUXC_SAI1_TXD6_AUDIOMIX_SAI1_TX_DATA6             0x30330190, 0x0, 0x00000000, 0x0, 0x303303F0
#define IOMUXC_SAI1_TXD6_AUDIOMIX_SAI6_RX_SYNC              0x30330190, 0x1, 0x30330520, 0x2, 0x303303F0
#define IOMUXC_SAI1_TXD6_AUDIOMIX_SAI6_TX_SYNC              0x30330190, 0x2, 0x30330528, 0x2, 0x303303F0
#define IOMUXC_SAI1_TXD6_ENET1_RX_ER                        0x30330190, 0x4, 0x3033058C, 0x1, 0x303303F0
#define IOMUXC_SAI1_TXD6_GPIO4_IO18                         0x30330190, 0x5, 0x00000000, 0x0, 0x303303F0
#define IOMUXC_SAI1_TXD7_AUDIOMIX_SAI1_TX_DATA7             0x30330194, 0x0, 0x00000000, 0x0, 0x303303F4
#define IOMUXC_SAI1_TXD7_AUDIOMIX_SAI6_MCLK                 0x30330194, 0x1, 0x30330514, 0x2, 0x303303F4
#define IOMUXC_SAI1_TXD7_AUDIOMIX_PDM_CLK                   0x30330194, 0x3, 0x00000000, 0x0, 0x303303F4
#define IOMUXC_SAI1_TXD7_ENET1_TX_ER                        0x30330194, 0x4, 0x00000000, 0x0, 0x303303F4
#define IOMUXC_SAI1_TXD7_GPIO4_IO19                         0x30330194, 0x5, 0x00000000, 0x0, 0x303303F4
#define IOMUXC_SAI1_MCLK_AUDIOMIX_SAI1_MCLK                 0x30330198, 0x0, 0x00000000, 0x0, 0x303303F8
#define IOMUXC_SAI1_MCLK_AUDIOMIX_SAI1_TX_BCLK              0x30330198, 0x2, 0x303304D4, 0x2, 0x303303F8
#define IOMUXC_SAI1_MCLK_ENET1_TX_CLK                       0x30330198, 0x4, 0x30330578, 0x1, 0x303303F8
#define IOMUXC_SAI1_MCLK_GPIO4_IO20                         0x30330198, 0x5, 0x00000000, 0x0, 0x303303F8
#define IOMUXC_SAI2_RXFS_AUDIOMIX_SAI2_RX_SYNC              0x3033019C, 0x0, 0x00000000, 0x0, 0x303303FC
#define IOMUXC_SAI2_RXFS_AUDIOMIX_SAI5_TX_SYNC              0x3033019C, 0x1, 0x30330510, 0x2, 0x303303FC
#define IOMUXC_SAI2_RXFS_AUDIOMIX_SAI5_TX_DATA1             0x3033019C, 0x2, 0x00000000, 0x0, 0x303303FC
#define IOMUXC_SAI2_RXFS_AUDIOMIX_SAI2_RX_DATA1             0x3033019C, 0x3, 0x303304DC, 0x0, 0x303303FC
#define IOMUXC_SAI2_RXFS_UART1_TX                           0x3033019C, 0x4, 0x00000000, 0x0, 0x303303FC
#define IOMUXC_SAI2_RXFS_UART1_RX                           0x3033019C, 0x4, 0x303305E8, 0x2, 0x303303FC
#define IOMUXC_SAI2_RXFS_GPIO4_IO21                         0x3033019C, 0x5, 0x00000000, 0x0, 0x303303FC
#define IOMUXC_SAI2_RXFS_AUDIOMIX_PDM_BIT_STREAM2           0x3033019C, 0x6, 0x303304C8, 0x5, 0x303303FC
#define IOMUXC_SAI2_RXC_AUDIOMIX_SAI2_RX_BCLK               0x303301A0, 0x0, 0x00000000, 0x0, 0x30330400
#define IOMUXC_SAI2_RXC_AUDIOMIX_SAI5_TX_BCLK               0x303301A0, 0x1, 0x3033050C, 0x2, 0x30330400
#define IOMUXC_SAI2_RXC_CAN1_TX                             0x303301A0, 0x3, 0x00000000, 0x0, 0x30330400
#define IOMUXC_SAI2_RXC_UART1_RX                            0x303301A0, 0x4, 0x303305E8, 0x3, 0x30330400
#define IOMUXC_SAI2_RXC_UART1_TX                            0x303301A0, 0x4, 0x00000000, 0x0, 0x30330400
#define IOMUXC_SAI2_RXC_GPIO4_IO22                          0x303301A0, 0x5, 0x00000000, 0x0, 0x30330400
#define IOMUXC_SAI2_RXC_AUDIOMIX_PDM_BIT_STREAM1            0x303301A0, 0x6, 0x303304C4, 0x5, 0x30330400
#define IOMUXC_SAI2_RXD0_AUDIOMIX_SAI2_RX_DATA0             0x303301A4, 0x0, 0x00000000, 0x0, 0x30330404
#define IOMUXC_SAI2_RXD0_AUDIOMIX_SAI5_TX_DATA0             0x303301A4, 0x1, 0x00000000, 0x0, 0x30330404
#define IOMUXC_SAI2_RXD0_ENET_QOS_1588_EVENT2_OUT           0x303301A4, 0x2, 0x00000000, 0x0, 0x30330404
#define IOMUXC_SAI2_RXD0_AUDIOMIX_SAI2_TX_DATA1             0x303301A4, 0x3, 0x00000000, 0x0, 0x30330404
#define IOMUXC_SAI2_RXD0_UART1_RTS_B                        0x303301A4, 0x4, 0x303305E4, 0x2, 0x30330404
#define IOMUXC_SAI2_RXD0_UART1_CTS_B                        0x303301A4, 0x4, 0x00000000, 0x0, 0x30330404
#define IOMUXC_SAI2_RXD0_GPIO4_IO23                         0x303301A4, 0x5, 0x00000000, 0x0, 0x30330404
#define IOMUXC_SAI2_RXD0_AUDIOMIX_PDM_BIT_STREAM3           0x303301A4, 0x6, 0x303304CC, 0x5, 0x30330404
#define IOMUXC_SAI2_TXFS_AUDIOMIX_SAI2_TX_SYNC              0x303301A8, 0x0, 0x00000000, 0x0, 0x30330408
#define IOMUXC_SAI2_TXFS_AUDIOMIX_SAI5_TX_DATA1             0x303301A8, 0x1, 0x00000000, 0x0, 0x30330408
#define IOMUXC_SAI2_TXFS_ENET_QOS_1588_EVENT3_OUT           0x303301A8, 0x2, 0x00000000, 0x0, 0x30330408
#define IOMUXC_SAI2_TXFS_AUDIOMIX_SAI2_TX_DATA1             0x303301A8, 0x3, 0x00000000, 0x0, 0x30330408
#define IOMUXC_SAI2_TXFS_UART1_CTS_B                        0x303301A8, 0x4, 0x00000000, 0x0, 0x30330408
#define IOMUXC_SAI2_TXFS_UART1_RTS_B                        0x303301A8, 0x4, 0x303305E4, 0x3, 0x30330408
#define IOMUXC_SAI2_TXFS_GPIO4_IO24                         0x303301A8, 0x5, 0x00000000, 0x0, 0x30330408
#define IOMUXC_SAI2_TXFS_AUDIOMIX_PDM_BIT_STREAM2           0x303301A8, 0x6, 0x303304C8, 0x6, 0x30330408
#define IOMUXC_SAI2_TXC_AUDIOMIX_SAI2_TX_BCLK               0x303301AC, 0x0, 0x00000000, 0x0, 0x3033040C
#define IOMUXC_SAI2_TXC_AUDIOMIX_SAI5_TX_DATA2              0x303301AC, 0x1, 0x00000000, 0x0, 0x3033040C
#define IOMUXC_SAI2_TXC_CAN1_RX                             0x303301AC, 0x3, 0x3033054C, 0x1, 0x3033040C
#define IOMUXC_SAI2_TXC_GPIO4_IO25                          0x303301AC, 0x5, 0x00000000, 0x0, 0x3033040C
#define IOMUXC_SAI2_TXC_AUDIOMIX_PDM_BIT_STREAM1            0x303301AC, 0x6, 0x303304C4, 0x6, 0x3033040C
#define IOMUXC_SAI2_TXD0_AUDIOMIX_SAI2_TX_DATA0             0x303301B0, 0x0, 0x00000000, 0x0, 0x30330410
#define IOMUXC_SAI2_TXD0_AUDIOMIX_SAI5_TX_DATA3             0x303301B0, 0x1, 0x00000000, 0x0, 0x30330410
#define IOMUXC_SAI2_TXD0_ENET_QOS_1588_EVENT2_IN            0x303301B0, 0x2, 0x00000000, 0x0, 0x30330410
#define IOMUXC_SAI2_TXD0_CAN2_TX                            0x303301B0, 0x3, 0x00000000, 0x0, 0x30330410
#define IOMUXC_SAI2_TXD0_ENET_QOS_1588_EVENT2_AUX_IN        0x303301B0, 0x4, 0x00000000, 0x0, 0x30330410
#define IOMUXC_SAI2_TXD0_GPIO4_IO26                         0x303301B0, 0x5, 0x00000000, 0x0, 0x30330410
#define IOMUXC_SAI2_MCLK_AUDIOMIX_SAI2_MCLK                 0x303301B4, 0x0, 0x00000000, 0x0, 0x30330414
#define IOMUXC_SAI2_MCLK_AUDIOMIX_SAI5_MCLK                 0x303301B4, 0x1, 0x303304F0, 0x2, 0x30330414
#define IOMUXC_SAI2_MCLK_ENET_QOS_1588_EVENT3_IN            0x303301B4, 0x2, 0x00000000, 0x0, 0x30330414
#define IOMUXC_SAI2_MCLK_CAN2_RX                            0x303301B4, 0x3, 0x30330550, 0x1, 0x30330414
#define IOMUXC_SAI2_MCLK_ENET_QOS_1588_EVENT3_AUX_IN        0x303301B4, 0x4, 0x00000000, 0x0, 0x30330414
#define IOMUXC_SAI2_MCLK_GPIO4_IO27                         0x303301B4, 0x5, 0x00000000, 0x0, 0x30330414
#define IOMUXC_SAI2_MCLK_AUDIOMIX_SAI3_MCLK                 0x303301B4, 0x6, 0x303304E0, 0x1, 0x30330414
#define IOMUXC_SAI3_RXFS_AUDIOMIX_SAI3_RX_SYNC              0x303301B8, 0x0, 0x00000000, 0x0, 0x30330418
#define IOMUXC_SAI3_RXFS_AUDIOMIX_SAI2_RX_DATA1             0x303301B8, 0x1, 0x303304DC, 0x1, 0x30330418
#define IOMUXC_SAI3_RXFS_AUDIOMIX_SAI5_RX_SYNC              0x303301B8, 0x2, 0x30330508, 0x2, 0x30330418
#define IOMUXC_SAI3_RXFS_AUDIOMIX_SAI3_RX_DATA1             0x303301B8, 0x3, 0x00000000, 0x0, 0x30330418
#define IOMUXC_SAI3_RXFS_AUDIOMIX_SPDIF1_IN                 0x303301B8, 0x4, 0x30330544, 0x2, 0x30330418
#define IOMUXC_SAI3_RXFS_GPIO4_IO28                         0x303301B8, 0x5, 0x00000000, 0x0, 0x30330418
#define IOMUXC_SAI3_RXFS_AUDIOMIX_PDM_BIT_STREAM0           0x303301B8, 0x6, 0x303304C0, 0x5, 0x30330418
#define IOMUXC_SAI3_RXC_AUDIOMIX_SAI3_RX_BCLK               0x303301BC, 0x0, 0x00000000, 0x0, 0x3033041C
#define IOMUXC_SAI3_RXC_AUDIOMIX_SAI2_RX_DATA2              0x303301BC, 0x1, 0x00000000, 0x0, 0x3033041C
#define IOMUXC_SAI3_RXC_AUDIOMIX_SAI5_RX_BCLK               0x303301BC, 0x2, 0x303304F4, 0x2, 0x3033041C
#define IOMUXC_SAI3_RXC_GPT1_CLK                            0x303301BC, 0x3, 0x3033059C, 0x0, 0x3033041C
#define IOMUXC_SAI3_RXC_UART2_CTS_B                         0x303301BC, 0x4, 0x00000000, 0x0, 0x3033041C
#define IOMUXC_SAI3_RXC_UART2_RTS_B                         0x303301BC, 0x4, 0x303305EC, 0x2, 0x3033041C
#define IOMUXC_SAI3_RXC_GPIO4_IO29                          0x303301BC, 0x5, 0x00000000, 0x0, 0x3033041C
#define IOMUXC_SAI3_RXC_AUDIOMIX_PDM_CLK                    0x303301BC, 0x6, 0x00000000, 0x0, 0x3033041C
#define IOMUXC_SAI3_RXD_AUDIOMIX_SAI3_RX_DATA0              0x303301C0, 0x0, 0x303304E4, 0x1, 0x30330420
#define IOMUXC_SAI3_RXD_AUDIOMIX_SAI2_RX_DATA3              0x303301C0, 0x1, 0x00000000, 0x0, 0x30330420
#define IOMUXC_SAI3_RXD_AUDIOMIX_SAI5_RX_DATA0              0x303301C0, 0x2, 0x303304F8, 0x2, 0x30330420
#define IOMUXC_SAI3_RXD_UART2_RTS_B                         0x303301C0, 0x4, 0x303305EC, 0x3, 0x30330420
#define IOMUXC_SAI3_RXD_UART2_CTS_B                         0x303301C0, 0x4, 0x00000000, 0x0, 0x30330420
#define IOMUXC_SAI3_RXD_GPIO4_IO30                          0x303301C0, 0x5, 0x00000000, 0x0, 0x30330420
#define IOMUXC_SAI3_RXD_AUDIOMIX_PDM_BIT_STREAM1            0x303301C0, 0x6, 0x303304C4, 0x7, 0x30330420
#define IOMUXC_SAI3_TXFS_AUDIOMIX_SAI3_TX_SYNC              0x303301C4, 0x0, 0x303304EC, 0x1, 0x30330424
#define IOMUXC_SAI3_TXFS_AUDIOMIX_SAI2_TX_DATA1             0x303301C4, 0x1, 0x00000000, 0x0, 0x30330424
#define IOMUXC_SAI3_TXFS_AUDIOMIX_SAI5_RX_DATA1             0x303301C4, 0x2, 0x303304FC, 0x2, 0x30330424
#define IOMUXC_SAI3_TXFS_AUDIOMIX_SAI3_TX_DATA1             0x303301C4, 0x3, 0x00000000, 0x0, 0x30330424
#define IOMUXC_SAI3_TXFS_UART2_RX                           0x303301C4, 0x4, 0x303305F0, 0x4, 0x30330424
#define IOMUXC_SAI3_TXFS_UART2_TX                           0x303301C4, 0x4, 0x00000000, 0x0, 0x30330424
#define IOMUXC_SAI3_TXFS_GPIO4_IO31                         0x303301C4, 0x5, 0x00000000, 0x0, 0x30330424
#define IOMUXC_SAI3_TXFS_AUDIOMIX_PDM_BIT_STREAM3           0x303301C4, 0x6, 0x303304CC, 0x6, 0x30330424
#define IOMUXC_SAI3_TXC_AUDIOMIX_SAI3_TX_BCLK               0x303301C8, 0x0, 0x303304E8, 0x1, 0x30330428
#define IOMUXC_SAI3_TXC_AUDIOMIX_SAI2_TX_DATA2              0x303301C8, 0x1, 0x00000000, 0x0, 0x30330428
#define IOMUXC_SAI3_TXC_AUDIOMIX_SAI5_RX_DATA2              0x303301C8, 0x2, 0x30330500, 0x2, 0x30330428
#define IOMUXC_SAI3_TXC_GPT1_CAPTURE1                       0x303301C8, 0x3, 0x30330594, 0x0, 0x30330428
#define IOMUXC_SAI3_TXC_UART2_TX                            0x303301C8, 0x4, 0x00000000, 0x0, 0x30330428
#define IOMUXC_SAI3_TXC_UART2_RX                            0x303301C8, 0x4, 0x303305F0, 0x5, 0x30330428
#define IOMUXC_SAI3_TXC_GPIO5_IO00                          0x303301C8, 0x5, 0x00000000, 0x0, 0x30330428
#define IOMUXC_SAI3_TXC_AUDIOMIX_PDM_BIT_STREAM2            0x303301C8, 0x6, 0x303304C8, 0x7, 0x30330428
#define IOMUXC_SAI3_TXD_AUDIOMIX_SAI3_TX_DATA0              0x303301CC, 0x0, 0x00000000, 0x0, 0x3033042C
#define IOMUXC_SAI3_TXD_AUDIOMIX_SAI2_TX_DATA3              0x303301CC, 0x1, 0x00000000, 0x0, 0x3033042C
#define IOMUXC_SAI3_TXD_AUDIOMIX_SAI5_RX_DATA3              0x303301CC, 0x2, 0x30330504, 0x2, 0x3033042C
#define IOMUXC_SAI3_TXD_GPT1_CAPTURE2                       0x303301CC, 0x3, 0x30330598, 0x0, 0x3033042C
#define IOMUXC_SAI3_TXD_AUDIOMIX_SPDIF1_EXT_CLK             0x303301CC, 0x4, 0x30330548, 0x0, 0x3033042C
#define IOMUXC_SAI3_TXD_GPIO5_IO01                          0x303301CC, 0x5, 0x00000000, 0x0, 0x3033042C
#define IOMUXC_SAI3_MCLK_AUDIOMIX_SAI3_MCLK                 0x303301D0, 0x0, 0x303304E0, 0x2, 0x30330430
#define IOMUXC_SAI3_MCLK_PWM4_OUT                           0x303301D0, 0x1, 0x00000000, 0x0, 0x30330430
#define IOMUXC_SAI3_MCLK_AUDIOMIX_SAI5_MCLK                 0x303301D0, 0x2, 0x303304F0, 0x3, 0x30330430
#define IOMUXC_SAI3_MCLK_AUDIOMIX_SPDIF1_OUT                0x303301D0, 0x4, 0x00000000, 0x0, 0x30330430
#define IOMUXC_SAI3_MCLK_GPIO5_IO02                         0x303301D0, 0x5, 0x00000000, 0x0, 0x30330430
#define IOMUXC_SAI3_MCLK_AUDIOMIX_SPDIF1_IN                 0x303301D0, 0x6, 0x30330544, 0x3, 0x30330430
#define IOMUXC_SPDIF_TX_AUDIOMIX_SPDIF1_OUT                 0x303301D4, 0x0, 0x00000000, 0x0, 0x30330434
#define IOMUXC_SPDIF_TX_PWM3_OUT                            0x303301D4, 0x1, 0x00000000, 0x0, 0x30330434
#define IOMUXC_SPDIF_TX_I2C5_SCL                            0x303301D4, 0x2, 0x303305C4, 0x2, 0x30330434
#define IOMUXC_SPDIF_TX_GPT1_COMPARE1                       0x303301D4, 0x3, 0x00000000, 0x0, 0x30330434
#define IOMUXC_SPDIF_TX_CAN1_TX                             0x303301D4, 0x4, 0x00000000, 0x0, 0x30330434
#define IOMUXC_SPDIF_TX_GPIO5_IO03                          0x303301D4, 0x5, 0x00000000, 0x0, 0x30330434
#define IOMUXC_SPDIF_RX_AUDIOMIX_SPDIF1_IN                  0x303301D8, 0x0, 0x30330544, 0x4, 0x30330438
#define IOMUXC_SPDIF_RX_PWM2_OUT                            0x303301D8, 0x1, 0x00000000, 0x0, 0x30330438
#define IOMUXC_SPDIF_RX_I2C5_SDA                            0x303301D8, 0x2, 0x303305C8, 0x2, 0x30330438
#define IOMUXC_SPDIF_RX_GPT1_COMPARE2                       0x303301D8, 0x3, 0x00000000, 0x0, 0x30330438
#define IOMUXC_SPDIF_RX_CAN1_RX                             0x303301D8, 0x4, 0x3033054C, 0x2, 0x30330438
#define IOMUXC_SPDIF_RX_GPIO5_IO04                          0x303301D8, 0x5, 0x00000000, 0x0, 0x30330438
#define IOMUXC_SPDIF_EXT_CLK_AUDIOMIX_SPDIF1_EXT_CLK        0x303301DC, 0x0, 0x30330548, 0x1, 0x3033043C
#define IOMUXC_SPDIF_EXT_CLK_PWM1_OUT                       0x303301DC, 0x1, 0x00000000, 0x0, 0x3033043C
#define IOMUXC_SPDIF_EXT_CLK_GPT1_COMPARE3                  0x303301DC, 0x3, 0x00000000, 0x0, 0x3033043C
#define IOMUXC_SPDIF_EXT_CLK_GPIO5_IO05                     0x303301DC, 0x5, 0x00000000, 0x0, 0x3033043C
#define IOMUXC_ECSPI1_SCLK_ECSPI1_SCLK                      0x303301E0, 0x0, 0x30330558, 0x0, 0x30330440
#define IOMUXC_ECSPI1_SCLK_UART3_RX                         0x303301E0, 0x1, 0x303305F8, 0x4, 0x30330440
#define IOMUXC_ECSPI1_SCLK_UART3_TX                         0x303301E0, 0x1, 0x00000000, 0x0, 0x30330440
#define IOMUXC_ECSPI1_SCLK_I2C1_SCL                         0x303301E0, 0x2, 0x303305A4, 0x1, 0x30330440
#define IOMUXC_ECSPI1_SCLK_AUDIOMIX_SAI7_RX_SYNC            0x303301E0, 0x3, 0x30330538, 0x1, 0x30330440
#define IOMUXC_ECSPI1_SCLK_GPIO5_IO06                       0x303301E0, 0x5, 0x00000000, 0x0, 0x30330440
#define IOMUXC_ECSPI1_MOSI_ECSPI1_MOSI                      0x303301E4, 0x0, 0x30330560, 0x0, 0x30330444
#define IOMUXC_ECSPI1_MOSI_UART3_TX                         0x303301E4, 0x1, 0x00000000, 0x0, 0x30330444
#define IOMUXC_ECSPI1_MOSI_UART3_RX                         0x303301E4, 0x1, 0x303305F8, 0x5, 0x30330444
#define IOMUXC_ECSPI1_MOSI_I2C1_SDA                         0x303301E4, 0x2, 0x303305A8, 0x1, 0x30330444
#define IOMUXC_ECSPI1_MOSI_AUDIOMIX_SAI7_RX_BCLK            0x303301E4, 0x3, 0x30330530, 0x1, 0x30330444
#define IOMUXC_ECSPI1_MOSI_GPIO5_IO07                       0x303301E4, 0x5, 0x00000000, 0x0, 0x30330444
#define IOMUXC_ECSPI1_MISO_ECSPI1_MISO                      0x303301E8, 0x0, 0x3033055C, 0x0, 0x30330448
#define IOMUXC_ECSPI1_MISO_UART3_CTS_B                      0x303301E8, 0x1, 0x00000000, 0x0, 0x30330448
#define IOMUXC_ECSPI1_MISO_UART3_RTS_B                      0x303301E8, 0x1, 0x303305F4, 0x2, 0x30330448
#define IOMUXC_ECSPI1_MISO_I2C2_SCL                         0x303301E8, 0x2, 0x303305AC, 0x1, 0x30330448
#define IOMUXC_ECSPI1_MISO_AUDIOMIX_SAI7_RX_DATA0           0x303301E8, 0x3, 0x30330534, 0x1, 0x30330448
#define IOMUXC_ECSPI1_MISO_GPIO5_IO08                       0x303301E8, 0x5, 0x00000000, 0x0, 0x30330448
#define IOMUXC_ECSPI1_SS0_ECSPI1_SS0                        0x303301EC, 0x0, 0x30330564, 0x0, 0x3033044C
#define IOMUXC_ECSPI1_SS0_UART3_RTS_B                       0x303301EC, 0x1, 0x303305F4, 0x3, 0x3033044C
#define IOMUXC_ECSPI1_SS0_UART3_CTS_B                       0x303301EC, 0x1, 0x00000000, 0x0, 0x3033044C
#define IOMUXC_ECSPI1_SS0_I2C2_SDA                          0x303301EC, 0x2, 0x303305B0, 0x1, 0x3033044C
#define IOMUXC_ECSPI1_SS0_AUDIOMIX_SAI7_TX_SYNC             0x303301EC, 0x3, 0x30330540, 0x1, 0x3033044C
#define IOMUXC_ECSPI1_SS0_GPIO5_IO09                        0x303301EC, 0x5, 0x00000000, 0x0, 0x3033044C
#define IOMUXC_ECSPI2_SCLK_ECSPI2_SCLK                      0x303301F0, 0x0, 0x30330568, 0x1, 0x30330450
#define IOMUXC_ECSPI2_SCLK_UART4_RX                         0x303301F0, 0x1, 0x30330600, 0x6, 0x30330450
#define IOMUXC_ECSPI2_SCLK_UART4_TX                         0x303301F0, 0x1, 0x00000000, 0x0, 0x30330450
#define IOMUXC_ECSPI2_SCLK_I2C3_SCL                         0x303301F0, 0x2, 0x303305B4, 0x3, 0x30330450
#define IOMUXC_ECSPI2_SCLK_AUDIOMIX_SAI7_TX_BCLK            0x303301F0, 0x3, 0x3033053C, 0x1, 0x30330450
#define IOMUXC_ECSPI2_SCLK_GPIO5_IO10                       0x303301F0, 0x5, 0x00000000, 0x0, 0x30330450
#define IOMUXC_ECSPI2_MOSI_ECSPI2_MOSI                      0x303301F4, 0x0, 0x30330570, 0x1, 0x30330454
#define IOMUXC_ECSPI2_MOSI_UART4_TX                         0x303301F4, 0x1, 0x00000000, 0x0, 0x30330454
#define IOMUXC_ECSPI2_MOSI_UART4_RX                         0x303301F4, 0x1, 0x30330600, 0x7, 0x30330454
#define IOMUXC_ECSPI2_MOSI_I2C3_SDA                         0x303301F4, 0x2, 0x303305B8, 0x3, 0x30330454
#define IOMUXC_ECSPI2_MOSI_AUDIOMIX_SAI7_TX_DATA0           0x303301F4, 0x3, 0x00000000, 0x0, 0x30330454
#define IOMUXC_ECSPI2_MOSI_GPIO5_IO11                       0x303301F4, 0x5, 0x00000000, 0x0, 0x30330454
#define IOMUXC_ECSPI2_MISO_ECSPI2_MISO                      0x303301F8, 0x0, 0x3033056C, 0x1, 0x30330458
#define IOMUXC_ECSPI2_MISO_UART4_CTS_B                      0x303301F8, 0x1, 0x00000000, 0x0, 0x30330458
#define IOMUXC_ECSPI2_MISO_UART4_RTS_B                      0x303301F8, 0x1, 0x303305FC, 0x2, 0x30330458
#define IOMUXC_ECSPI2_MISO_I2C4_SCL                         0x303301F8, 0x2, 0x303305BC, 0x4, 0x30330458
#define IOMUXC_ECSPI2_MISO_AUDIOMIX_SAI7_MCLK               0x303301F8, 0x3, 0x3033052C, 0x1, 0x30330458
#define IOMUXC_ECSPI2_MISO_CCM_CLKO1                        0x303301F8, 0x4, 0x00000000, 0x0, 0x30330458
#define IOMUXC_ECSPI2_MISO_GPIO5_IO12                       0x303301F8, 0x5, 0x00000000, 0x0, 0x30330458
#define IOMUXC_ECSPI2_SS0_ECSPI2_SS0                        0x303301FC, 0x0, 0x30330574, 0x1, 0x3033045C
#define IOMUXC_ECSPI2_SS0_UART4_RTS_B                       0x303301FC, 0x1, 0x303305FC, 0x3, 0x3033045C
#define IOMUXC_ECSPI2_SS0_UART4_CTS_B                       0x303301FC, 0x1, 0x00000000, 0x0, 0x3033045C
#define IOMUXC_ECSPI2_SS0_I2C4_SDA                          0x303301FC, 0x2, 0x303305C0, 0x4, 0x3033045C
#define IOMUXC_ECSPI2_SS0_CCM_CLKO2                         0x303301FC, 0x4, 0x00000000, 0x0, 0x3033045C
#define IOMUXC_ECSPI2_SS0_GPIO5_IO13                        0x303301FC, 0x5, 0x00000000, 0x0, 0x3033045C
#define IOMUXC_I2C1_SCL_I2C1_SCL                            0x30330200, 0x0, 0x303305A4, 0x2, 0x30330460
#define IOMUXC_I2C1_SCL_ENET_QOS_MDC                        0x30330200, 0x1, 0x00000000, 0x0, 0x30330460
#define IOMUXC_I2C1_SCL_ECSPI1_SCLK                         0x30330200, 0x3, 0x30330558, 0x1, 0x30330460
#define IOMUXC_I2C1_SCL_GPIO5_IO14                          0x30330200, 0x5, 0x00000000, 0x0, 0x30330460
#define IOMUXC_I2C1_SDA_I2C1_SDA                            0x30330204, 0x0, 0x303305A8, 0x2, 0x30330464
#define IOMUXC_I2C1_SDA_ENET_QOS_MDIO                       0x30330204, 0x1, 0x30330590, 0x2, 0x30330464
#define IOMUXC_I2C1_SDA_ECSPI1_MOSI                         0x30330204, 0x3, 0x30330560, 0x1, 0x30330464
#define IOMUXC_I2C1_SDA_GPIO5_IO15                          0x30330204, 0x5, 0x00000000, 0x0, 0x30330464
#define IOMUXC_I2C2_SCL_I2C2_SCL                            0x30330208, 0x0, 0x303305AC, 0x2, 0x30330468
#define IOMUXC_I2C2_SCL_ENET_QOS_1588_EVENT1_IN             0x30330208, 0x1, 0x00000000, 0x0, 0x30330468
#define IOMUXC_I2C2_SCL_USDHC3_CD_B                         0x30330208, 0x2, 0x30330608, 0x3, 0x30330468
#define IOMUXC_I2C2_SCL_ECSPI1_MISO                         0x30330208, 0x3, 0x3033055C, 0x1, 0x30330468
#define IOMUXC_I2C2_SCL_ENET_QOS_1588_EVENT1_AUX_IN         0x30330208, 0x4, 0x00000000, 0x0, 0x30330468
#define IOMUXC_I2C2_SCL_GPIO5_IO16                          0x30330208, 0x5, 0x00000000, 0x0, 0x30330468
#define IOMUXC_I2C2_SDA_I2C2_SDA                            0x3033020C, 0x0, 0x303305B0, 0x2, 0x3033046C
#define IOMUXC_I2C2_SDA_ENET_QOS_1588_EVENT1_OUT            0x3033020C, 0x1, 0x00000000, 0x0, 0x3033046C
#define IOMUXC_I2C2_SDA_USDHC3_WP                           0x3033020C, 0x2, 0x30330634, 0x3, 0x3033046C
#define IOMUXC_I2C2_SDA_ECSPI1_SS0                          0x3033020C, 0x3, 0x30330564, 0x1, 0x3033046C
#define IOMUXC_I2C2_SDA_GPIO5_IO17                          0x3033020C, 0x5, 0x00000000, 0x0, 0x3033046C
#define IOMUXC_I2C3_SCL_I2C3_SCL                            0x30330210, 0x0, 0x303305B4, 0x4, 0x30330470
#define IOMUXC_I2C3_SCL_PWM4_OUT                            0x30330210, 0x1, 0x00000000, 0x0, 0x30330470
#define IOMUXC_I2C3_SCL_GPT2_CLK                            0x30330210, 0x2, 0x00000000, 0x0, 0x30330470
#define IOMUXC_I2C3_SCL_ECSPI2_SCLK                         0x30330210, 0x3, 0x30330568, 0x2, 0x30330470
#define IOMUXC_I2C3_SCL_GPIO5_IO18                          0x30330210, 0x5, 0x00000000, 0x0, 0x30330470
#define IOMUXC_I2C3_SDA_I2C3_SDA                            0x30330214, 0x0, 0x303305B8, 0x4, 0x30330474
#define IOMUXC_I2C3_SDA_PWM3_OUT                            0x30330214, 0x1, 0x00000000, 0x0, 0x30330474
#define IOMUXC_I2C3_SDA_GPT3_CLK                            0x30330214, 0x2, 0x00000000, 0x0, 0x30330474
#define IOMUXC_I2C3_SDA_ECSPI2_MOSI                         0x30330214, 0x3, 0x30330570, 0x2, 0x30330474
#define IOMUXC_I2C3_SDA_GPIO5_IO19                          0x30330214, 0x5, 0x00000000, 0x0, 0x30330474
#define IOMUXC_I2C4_SCL_I2C4_SCL                            0x30330218, 0x0, 0x303305BC, 0x5, 0x30330478
#define IOMUXC_I2C4_SCL_PWM2_OUT                            0x30330218, 0x1, 0x00000000, 0x0, 0x30330478
#define IOMUXC_I2C4_SCL_PCIE_CLKREQ_B                       0x30330218, 0x2, 0x303305A0, 0x0, 0x30330478
#define IOMUXC_I2C4_SCL_ECSPI2_MISO                         0x30330218, 0x3, 0x3033056C, 0x2, 0x30330478
#define IOMUXC_I2C4_SCL_GPIO5_IO20                          0x30330218, 0x5, 0x00000000, 0x0, 0x30330478
#define IOMUXC_I2C4_SDA_I2C4_SDA                            0x3033021C, 0x0, 0x303305C0, 0x5, 0x3033047C
#define IOMUXC_I2C4_SDA_PWM1_OUT                            0x3033021C, 0x1, 0x00000000, 0x0, 0x3033047C
#define IOMUXC_I2C4_SDA_ECSPI2_SS0                          0x3033021C, 0x3, 0x30330574, 0x2, 0x3033047C
#define IOMUXC_I2C4_SDA_GPIO5_IO21                          0x3033021C, 0x5, 0x00000000, 0x0, 0x3033047C
#define IOMUXC_UART1_RXD_UART1_RX                           0x30330220, 0x0, 0x303305E8, 0x4, 0x30330480
#define IOMUXC_UART1_RXD_UART1_TX                           0x30330220, 0x0, 0x00000000, 0x0, 0x30330480
#define IOMUXC_UART1_RXD_ECSPI3_SCLK                        0x30330220, 0x1, 0x00000000, 0x0, 0x30330480
#define IOMUXC_UART1_RXD_GPIO5_IO22                         0x30330220, 0x5, 0x00000000, 0x0, 0x30330480
#define IOMUXC_UART1_TXD_UART1_TX                           0x30330224, 0x0, 0x00000000, 0x0, 0x30330484
#define IOMUXC_UART1_TXD_UART1_RX                           0x30330224, 0x0, 0x303305E8, 0x5, 0x30330484
#define IOMUXC_UART1_TXD_ECSPI3_MOSI                        0x30330224, 0x1, 0x00000000, 0x0, 0x30330484
#define IOMUXC_UART1_TXD_GPIO5_IO23                         0x30330224, 0x5, 0x00000000, 0x0, 0x30330484
#define IOMUXC_UART2_RXD_UART2_RX                           0x30330228, 0x0, 0x303305F0, 0x6, 0x30330488
#define IOMUXC_UART2_RXD_UART2_TX                           0x30330228, 0x0, 0x00000000, 0x0, 0x30330488
#define IOMUXC_UART2_RXD_ECSPI3_MISO                        0x30330228, 0x1, 0x00000000, 0x0, 0x30330488
#define IOMUXC_UART2_RXD_GPT1_COMPARE3                      0x30330228, 0x3, 0x00000000, 0x0, 0x30330488
#define IOMUXC_UART2_RXD_GPIO5_IO24                         0x30330228, 0x5, 0x00000000, 0x0, 0x30330488
#define IOMUXC_UART2_TXD_UART2_TX                           0x3033022C, 0x0, 0x00000000, 0x0, 0x3033048C
#define IOMUXC_UART2_TXD_UART2_RX                           0x3033022C, 0x0, 0x303305F0, 0x7, 0x3033048C
#define IOMUXC_UART2_TXD_ECSPI3_SS0                         0x3033022C, 0x1, 0x00000000, 0x0, 0x3033048C
#define IOMUXC_UART2_TXD_GPT1_COMPARE2                      0x3033022C, 0x3, 0x00000000, 0x0, 0x3033048C
#define IOMUXC_UART2_TXD_GPIO5_IO25                         0x3033022C, 0x5, 0x00000000, 0x0, 0x3033048C
#define IOMUXC_UART3_RXD_UART3_RX                           0x30330230, 0x0, 0x303305F8, 0x6, 0x30330490
#define IOMUXC_UART3_RXD_UART3_TX                           0x30330230, 0x0, 0x00000000, 0x0, 0x30330490
#define IOMUXC_UART3_RXD_UART1_CTS_B                        0x30330230, 0x1, 0x00000000, 0x0, 0x30330490
#define IOMUXC_UART3_RXD_UART1_RTS_B                        0x30330230, 0x1, 0x303305E4, 0x4, 0x30330490
#define IOMUXC_UART3_RXD_USDHC3_RESET_B                     0x30330230, 0x2, 0x00000000, 0x0, 0x30330490
#define IOMUXC_UART3_RXD_GPT1_CAPTURE2                      0x30330230, 0x3, 0x30330598, 0x1, 0x30330490
#define IOMUXC_UART3_RXD_CAN2_TX                            0x30330230, 0x4, 0x00000000, 0x0, 0x30330490
#define IOMUXC_UART3_RXD_GPIO5_IO26                         0x30330230, 0x5, 0x00000000, 0x0, 0x30330490
#define IOMUXC_UART3_TXD_UART3_TX                           0x30330234, 0x0, 0x00000000, 0x0, 0x30330494
#define IOMUXC_UART3_TXD_UART3_RX                           0x30330234, 0x0, 0x303305F8, 0x7, 0x30330494
#define IOMUXC_UART3_TXD_UART1_RTS_B                        0x30330234, 0x1, 0x303305E4, 0x5, 0x30330494
#define IOMUXC_UART3_TXD_UART1_CTS_B                        0x30330234, 0x1, 0x00000000, 0x0, 0x30330494
#define IOMUXC_UART3_TXD_USDHC3_VSELECT                     0x30330234, 0x2, 0x00000000, 0x0, 0x30330494
#define IOMUXC_UART3_TXD_GPT1_CLK                           0x30330234, 0x3, 0x3033059C, 0x1, 0x30330494
#define IOMUXC_UART3_TXD_CAN2_RX                            0x30330234, 0x4, 0x30330550, 0x2, 0x30330494
#define IOMUXC_UART3_TXD_GPIO5_IO27                         0x30330234, 0x5, 0x00000000, 0x0, 0x30330494
#define IOMUXC_UART4_RXD_UART4_RX                           0x30330238, 0x0, 0x30330600, 0x8, 0x30330498
#define IOMUXC_UART4_RXD_UART4_TX                           0x30330238, 0x0, 0x00000000, 0x0, 0x30330498
#define IOMUXC_UART4_RXD_UART2_CTS_B                        0x30330238, 0x1, 0x00000000, 0x0, 0x30330498
#define IOMUXC_UART4_RXD_UART2_RTS_B                        0x30330238, 0x1, 0x303305EC, 0x4, 0x30330498
#define IOMUXC_UART4_RXD_PCIE_CLKREQ_B                      0x30330238, 0x2, 0x303305A0, 0x1, 0x30330498
#define IOMUXC_UART4_RXD_GPT1_COMPARE1                      0x30330238, 0x3, 0x00000000, 0x0, 0x30330498
#define IOMUXC_UART4_RXD_I2C6_SCL                           0x30330238, 0x4, 0x303305CC, 0x2, 0x30330498
#define IOMUXC_UART4_RXD_GPIO5_IO28                         0x30330238, 0x5, 0x00000000, 0x0, 0x30330498
#define IOMUXC_UART4_TXD_UART4_TX                           0x3033023C, 0x0, 0x00000000, 0x0, 0x3033049C
#define IOMUXC_UART4_TXD_UART4_RX                           0x3033023C, 0x0, 0x30330600, 0x9, 0x3033049C
#define IOMUXC_UART4_TXD_UART2_RTS_B                        0x3033023C, 0x1, 0x303305EC, 0x5, 0x3033049C
#define IOMUXC_UART4_TXD_UART2_CTS_B                        0x3033023C, 0x1, 0x00000000, 0x0, 0x3033049C
#define IOMUXC_UART4_TXD_GPT1_CAPTURE1                      0x3033023C, 0x3, 0x30330594, 0x1, 0x3033049C
#define IOMUXC_UART4_TXD_I2C6_SDA                           0x3033023C, 0x4, 0x303305D0, 0x2, 0x3033049C
#define IOMUXC_UART4_TXD_GPIO5_IO29                         0x3033023C, 0x5, 0x00000000, 0x0, 0x3033049C
#define IOMUXC_HDMI_DDC_SCL_HDMIMIX_HDMI_SCL                0x30330240, 0x0, 0x00000000, 0x0, 0x303304A0
#define IOMUXC_HDMI_DDC_SCL_I2C5_SCL                        0x30330240, 0x3, 0x303305C4, 0x3, 0x303304A0
#define IOMUXC_HDMI_DDC_SCL_CAN1_TX                         0x30330240, 0x4, 0x00000000, 0x0, 0x303304A0
#define IOMUXC_HDMI_DDC_SCL_GPIO3_IO26                      0x30330240, 0x5, 0x00000000, 0x0, 0x303304A0
#define IOMUXC_HDMI_DDC_SCL_EARC_TEST_OUT0                  0x30330240, 0x6, 0x00000000, 0x0, 0x303304A0
#define IOMUXC_HDMI_DDC_SDA_HDMIMIX_HDMI_SDA                0x30330244, 0x0, 0x00000000, 0x0, 0x303304A4
#define IOMUXC_HDMI_DDC_SDA_I2C5_SDA                        0x30330244, 0x3, 0x303305C8, 0x3, 0x303304A4
#define IOMUXC_HDMI_DDC_SDA_CAN1_RX                         0x30330244, 0x4, 0x3033054C, 0x3, 0x303304A4
#define IOMUXC_HDMI_DDC_SDA_GPIO3_IO27                      0x30330244, 0x5, 0x00000000, 0x0, 0x303304A4
#define IOMUXC_HDMI_DDC_SDA_EARC_TEST_OUT1                  0x30330244, 0x6, 0x00000000, 0x0, 0x303304A4
#define IOMUXC_HDMI_CEC_HDMIMIX_HDMI_CEC                    0x30330248, 0x0, 0x00000000, 0x0, 0x303304A8
#define IOMUXC_HDMI_CEC_I2C6_SCL                            0x30330248, 0x3, 0x303305CC, 0x3, 0x303304A8
#define IOMUXC_HDMI_CEC_CAN2_TX                             0x30330248, 0x4, 0x00000000, 0x0, 0x303304A8
#define IOMUXC_HDMI_CEC_GPIO3_IO28                          0x30330248, 0x5, 0x00000000, 0x0, 0x303304A8
#define IOMUXC_HDMI_HPD_HDMIMIX_HDMI_HPD                    0x3033024C, 0x0, 0x00000000, 0x0, 0x303304AC
#define IOMUXC_HDMI_HPD_AUDIOMIX_HDMI_HPD_O                 0x3033024C, 0x1, 0x00000000, 0x0, 0x303304AC
#define IOMUXC_HDMI_HPD_I2C6_SDA                            0x3033024C, 0x3, 0x303305D0, 0x3, 0x303304AC
#define IOMUXC_HDMI_HPD_CAN2_RX                             0x3033024C, 0x4, 0x30330550, 0x3, 0x303304AC
#define IOMUXC_HDMI_HPD_GPIO3_IO29                          0x3033024C, 0x5, 0x00000000, 0x0, 0x303304AC

/* DSE - Drive Strength Field
 *  00   x1
 *  10   x2
 *  01   x4
 *  11   x6
 */
#define PAD_CTL_DSE1            (0 << 1)
#define PAD_CTL_DSE2            (2 << 1)
#define PAD_CTL_DSE4            (1 << 1)
#define PAD_CTL_DSE6            (3 << 1)

/* FSEL - Slew Rate Field
 *  0  Slow Slew Rate (SR=1)
 *  1  Fast Slew Rate (SR=0)
 */
#define PAD_CTL_FSEL            (1 << 4)

/* ODE - Open drain field
 *  0  Disable
 *  1  Enable
 */
#define PAD_CTL_ODE             (1 << 5)

/* PUE - Pull Up / Down Config. Field
 *  0  Weak pull down
 *  1  Weak pull up
 */
#define PAD_CTL_PUE             (1 << 6)

/* HYS - Input Select Field
 *  0  CMOS
 *  1  Schmitt
 */
#define PAD_CTL_HYS             (1 << 7)

/* PE - Pull Select Field
 *  0  Pull Disable
 *  1  Pull Enable
 */
#define PAD_CTL_PE              (1 << 8)

/* Helpers for common configurations */

#define GPIO_PAD_CTRL  (PAD_CTL_HYS | PAD_CTL_PUE | PAD_CTL_PE | PAD_CTL_DSE2)
#define UART_PAD_CTRL  (PAD_CTL_PUE | PAD_CTL_PE)
#define SPI_PAD_CTRL   (PAD_CTL_PUE)

#endif /* __ARCH_ARM_SRC_MX8MP_HARDWARE_MX8MP_PINMUX_H */
