/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.flow;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;
import org.apache.nifi.toolkit.client.ControllerClient;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;

public class CreateReportingTask
extends AbstractNiFiCommand<StringResult> {
    public CreateReportingTask() {
        super("create-reporting-task", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates a reporting task from a local file.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.INPUT_SOURCE.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String inputFile = this.getRequiredArg(properties, CommandOption.INPUT_SOURCE);
        URI uri = Paths.get(inputFile, new String[0]).toAbsolutePath().toUri();
        String contents = IOUtils.toString((URI)uri, (Charset)StandardCharsets.UTF_8);
        ObjectMapper objectMapper = JacksonUtils.getObjectMapper();
        ReportingTaskEntity deserializedTask = (ReportingTaskEntity)objectMapper.readValue(contents, ReportingTaskEntity.class);
        if (deserializedTask == null) {
            throw new IOException("Unable to deserialize reporting task from " + inputFile);
        }
        deserializedTask.setRevision(this.getInitialRevisionDTO());
        ControllerClient controllerClient = client.getControllerClient();
        ReportingTaskEntity createdEntity = controllerClient.createReportingTask(deserializedTask);
        return new StringResult(String.valueOf(createdEntity.getId()), this.getContext().isInteractive());
    }
}

