/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.servlets;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.pathmap.PathSpecSet;
import org.eclipse.jetty.util.IncludeExclude;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IncludeExcludeBasedFilter
implements Filter {
    private final IncludeExclude<String> _mimeTypes = new IncludeExclude();
    private final IncludeExclude<String> _httpMethods = new IncludeExclude();
    private final IncludeExclude<String> _paths = new IncludeExclude(PathSpecSet.class);
    private static final Logger LOG = LoggerFactory.getLogger(IncludeExcludeBasedFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        String includedPaths = filterConfig.getInitParameter("includedPaths");
        String excludedPaths = filterConfig.getInitParameter("excludedPaths");
        String includedMimeTypes = filterConfig.getInitParameter("includedMimeTypes");
        String excludedMimeTypes = filterConfig.getInitParameter("excludedMimeTypes");
        String includedHttpMethods = filterConfig.getInitParameter("includedHttpMethods");
        String excludedHttpMethods = filterConfig.getInitParameter("excludedHttpMethods");
        if (includedPaths != null) {
            this._paths.include((Object[])StringUtil.csvSplit((String)includedPaths));
        }
        if (excludedPaths != null) {
            this._paths.exclude((Object[])StringUtil.csvSplit((String)excludedPaths));
        }
        if (includedMimeTypes != null) {
            this._mimeTypes.include((Object[])StringUtil.csvSplit((String)includedMimeTypes));
        }
        if (excludedMimeTypes != null) {
            this._mimeTypes.exclude((Object[])StringUtil.csvSplit((String)excludedMimeTypes));
        }
        if (includedHttpMethods != null) {
            this._httpMethods.include((Object[])StringUtil.csvSplit((String)includedHttpMethods));
        }
        if (excludedHttpMethods != null) {
            this._httpMethods.exclude((Object[])StringUtil.csvSplit((String)excludedHttpMethods));
        }
    }

    protected String guessMimeType(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String mimeType;
        String contentType = httpResponse.getContentType();
        LOG.debug("Content Type is: {}", (Object)contentType);
        if (contentType != null) {
            mimeType = MimeTypes.getContentTypeWithoutCharset((String)contentType);
            LOG.debug("Mime Type is: {}", (Object)mimeType);
        } else {
            String requestUrl = httpRequest.getPathInfo();
            mimeType = Objects.requireNonNullElse(httpRequest.getServletContext().getMimeType(requestUrl), "");
            LOG.debug("Guessed mime type is {}", (Object)mimeType);
        }
        return mimeType;
    }

    protected boolean shouldFilter(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String httpMethod = httpRequest.getMethod();
        LOG.debug("HTTP method is: {}", (Object)httpMethod);
        if (!this._httpMethods.test((Object)httpMethod)) {
            LOG.debug("should not apply filter because HTTP method does not match");
            return false;
        }
        String mimeType = this.guessMimeType(httpRequest, httpResponse);
        if (!this._mimeTypes.test((Object)mimeType)) {
            LOG.debug("should not apply filter because mime type does not match");
            return false;
        }
        ServletContext context = httpRequest.getServletContext();
        String path = context == null ? httpRequest.getRequestURI() : URIUtil.addPaths((String)httpRequest.getServletPath(), (String)httpRequest.getPathInfo());
        LOG.debug("Path is: {}", (Object)path);
        if (!this._paths.test((Object)path)) {
            LOG.debug("should not apply filter because path does not match");
            return false;
        }
        return true;
    }

    public void destroy() {
    }

    public String toString() {
        return "filter configuration:\npaths:\n" + String.valueOf(this._paths) + "\nmime types:\n" + String.valueOf(this._mimeTypes) + "\nhttp methods:\n" + String.valueOf(this._httpMethods);
    }
}

