/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class RememberMeAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 620L;
    private final Object principal;
    private final int keyHash;

    public RememberMeAuthenticationToken(String key, Object principal, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        if (key == null || "".equals(key) || principal == null || "".equals(principal)) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.keyHash = key.hashCode();
        this.principal = principal;
        this.setAuthenticated(true);
    }

    private RememberMeAuthenticationToken(Integer keyHash, Object principal, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.keyHash = keyHash;
        this.principal = principal;
        this.setAuthenticated(true);
    }

    protected RememberMeAuthenticationToken(Builder<?> builder) {
        super(builder);
        this.keyHash = builder.keyHash;
        this.principal = builder.principal;
    }

    @Override
    public Object getCredentials() {
        return "";
    }

    public int getKeyHash() {
        return this.keyHash;
    }

    @Override
    public Object getPrincipal() {
        return this.principal;
    }

    public Builder<?> toBuilder() {
        return new Builder(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof RememberMeAuthenticationToken) {
            RememberMeAuthenticationToken other = (RememberMeAuthenticationToken)obj;
            return this.getKeyHash() == other.getKeyHash();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.keyHash;
        return result;
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAuthenticationToken.AbstractAuthenticationBuilder<B> {
        private Integer keyHash;
        private Object principal;

        protected Builder(RememberMeAuthenticationToken token) {
            super(token);
            this.keyHash = token.getKeyHash();
            this.principal = token.getPrincipal();
        }

        @Override
        public B principal(@Nullable Object principal) {
            Assert.notNull((Object)principal, (String)"principal cannot be null");
            this.principal = principal;
            return (B)this;
        }

        public B key(String key) {
            this.keyHash = key.hashCode();
            return (B)this;
        }

        @Override
        public RememberMeAuthenticationToken build() {
            return new RememberMeAuthenticationToken(this);
        }
    }
}

