/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authentication.single.user.encoder;

import at.favre.lib.crypto.bcrypt.BCrypt;
import org.apache.nifi.authentication.single.user.encoder.PasswordEncoder;

public class BCryptPasswordEncoder
implements PasswordEncoder {
    private static final int DEFAULT_COST = 12;
    private static final BCrypt.Version BCRYPT_VERSION = BCrypt.Version.VERSION_2B;
    private static final BCrypt.Hasher HASHER = BCrypt.with((BCrypt.Version)BCRYPT_VERSION);
    private static final BCrypt.Verifyer VERIFYER = BCrypt.verifyer((BCrypt.Version)BCRYPT_VERSION);

    @Override
    public String encode(char[] password) {
        return HASHER.hashToString(12, password);
    }

    @Override
    public boolean matches(char[] password, String encodedPassword) {
        BCrypt.Result result = VERIFYER.verifyStrict(password, encodedPassword.toCharArray());
        return result.verified;
    }
}

