/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.AbstractClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;

public final class SimpleClientHttpRequestFactoryBuilder
extends AbstractClientHttpRequestFactoryBuilder<SimpleClientHttpRequestFactory> {
    SimpleClientHttpRequestFactoryBuilder() {
        this((List<Consumer<SimpleClientHttpRequestFactory>>)null);
    }

    private SimpleClientHttpRequestFactoryBuilder(List<Consumer<SimpleClientHttpRequestFactory>> customizers) {
        super(customizers);
    }

    public SimpleClientHttpRequestFactoryBuilder withCustomizer(Consumer<SimpleClientHttpRequestFactory> customizer) {
        return new SimpleClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizer));
    }

    public SimpleClientHttpRequestFactoryBuilder withCustomizers(Collection<Consumer<SimpleClientHttpRequestFactory>> customizers) {
        return new SimpleClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizers));
    }

    @Override
    protected SimpleClientHttpRequestFactory createClientHttpRequestFactory(ClientHttpRequestFactorySettings settings) {
        SslBundle sslBundle = settings.sslBundle();
        SimpleClientHttpsRequestFactory requestFactory = new SimpleClientHttpsRequestFactory(settings);
        Assert.state((sslBundle == null || !sslBundle.getOptions().isSpecified() ? 1 : 0) != 0, (String)"SSL Options cannot be specified with Java connections");
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::readTimeout).asInt(Duration::toMillis).to(arg_0 -> ((SimpleClientHttpRequestFactory)requestFactory).setReadTimeout(arg_0));
        map.from(settings::connectTimeout).asInt(Duration::toMillis).to(arg_0 -> ((SimpleClientHttpRequestFactory)requestFactory).setConnectTimeout(arg_0));
        return requestFactory;
    }

    private static class SimpleClientHttpsRequestFactory
    extends SimpleClientHttpRequestFactory {
        private final ClientHttpRequestFactorySettings settings;

        SimpleClientHttpsRequestFactory(ClientHttpRequestFactorySettings settings) {
            this.settings = settings;
        }

        protected void prepareConnection(HttpURLConnection connection, String httpMethod) throws IOException {
            super.prepareConnection(connection, httpMethod);
            if (this.settings.sslBundle() != null && connection instanceof HttpsURLConnection) {
                HttpsURLConnection secureConnection = (HttpsURLConnection)connection;
                SSLSocketFactory socketFactory = this.settings.sslBundle().createSslContext().getSocketFactory();
                secureConnection.setSSLSocketFactory(socketFactory);
            }
            if (this.settings.redirects() == ClientHttpRequestFactorySettings.Redirects.DONT_FOLLOW) {
                connection.setInstanceFollowRedirects(false);
            }
        }
    }
}

