/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.nifi.remote.io.InterruptableOutputStream;
import org.apache.nifi.remote.protocol.CommunicationsOutput;
import org.apache.nifi.stream.io.ByteCountingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketOutput
implements CommunicationsOutput {
    private static final Logger LOG = LoggerFactory.getLogger(SocketOutput.class);
    private final Socket socket;
    private final ByteCountingOutputStream countingOut;
    private final OutputStream bufferedOut;
    private final InterruptableOutputStream interruptableOut;

    public SocketOutput(Socket socket) throws IOException {
        this.socket = socket;
        this.countingOut = new ByteCountingOutputStream(socket.getOutputStream());
        this.bufferedOut = new BufferedOutputStream((OutputStream)this.countingOut);
        this.interruptableOut = new InterruptableOutputStream(this.bufferedOut);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.interruptableOut;
    }

    public void setTimeout(int timeout) {
        try {
            this.socket.setSoTimeout(timeout);
        }
        catch (SocketException e) {
            LOG.warn("Failed to set socket timeout.", (Throwable)e);
        }
    }

    @Override
    public long getBytesWritten() {
        return this.countingOut.getBytesWritten();
    }

    public void interrupt() {
        this.interruptableOut.interrupt();
    }
}

