/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.apache.netbeans.nbpackage.Configuration;
import org.apache.netbeans.nbpackage.ExecutionContext;
import org.apache.netbeans.nbpackage.Option;

public final class Template {
    private final Option<Path> option;
    private final String name;
    private final Supplier<Reader> readerProvider;

    private Template(Option<Path> option, String name, Supplier<Reader> readerSupplier) {
        this.name = name;
        this.option = option;
        this.readerProvider = readerSupplier;
    }

    public String name() {
        return this.name;
    }

    public Option<Path> option() {
        return this.option;
    }

    public String load(ExecutionContext context) throws IOException {
        Path file = context.getValue(this.option).orElse(null);
        return this.loadImpl(file);
    }

    String load(Configuration config) throws IOException {
        String optionValue = config.getValue(this.option);
        if (!optionValue.isBlank()) {
            return this.loadImpl(Path.of(optionValue, new String[0]));
        }
        return this.loadImpl(null);
    }

    private String loadImpl(Path file) throws IOException {
        if (file != null) {
            return Files.readString(file);
        }
        try (Reader in = this.readerProvider.get();){
            String string;
            try (StringWriter out = new StringWriter();){
                in.transferTo(out);
                string = out.toString();
            }
            return string;
        }
    }

    public static Template of(Option<Path> option, String name, Supplier<InputStream> defaultSourceSupplier) {
        return new Template(option, name, () -> new InputStreamReader((InputStream)defaultSourceSupplier.get(), StandardCharsets.UTF_8));
    }
}

