/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.openide.util.Lookup;

public final class NbPreferences {
    private static Provider PREFS_IMPL;

    private NbPreferences() {
    }

    public static Preferences forModule(Class cls) {
        if (PREFS_IMPL == null) {
            PREFS_IMPL = NbPreferences.getPreferencesProvider();
        }
        return PREFS_IMPL.preferencesForModule(cls);
    }

    public static Preferences root() {
        if (PREFS_IMPL == null) {
            PREFS_IMPL = NbPreferences.getPreferencesProvider();
        }
        return PREFS_IMPL.preferencesRoot();
    }

    private static Provider getPreferencesProvider() {
        Provider retval = Lookup.getDefault().lookup(Provider.class);
        if (retval == null) {
            retval = new Provider(){

                @Override
                public Preferences preferencesForModule(Class cls) {
                    return Preferences.userNodeForPackage(cls);
                }

                @Override
                public Preferences preferencesRoot() {
                    return Preferences.userRoot();
                }
            };
            String prefsFactory = System.getProperty("java.util.prefs.PreferencesFactory");
            if (!"org.netbeans.junit.internal.MemoryPreferencesFactory".equals(prefsFactory)) {
                Logger logger = Logger.getLogger(NbPreferences.class.getName());
                logger.log(prefsFactory == null ? Level.WARNING : Level.FINE, "NetBeans implementation of Preferences not found");
            }
        }
        return retval;
    }

    public static interface Provider {
        public Preferences preferencesForModule(Class var1);

        public Preferences preferencesRoot();
    }
}

