/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import jakarta.faces.component.UIColumn;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIData;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.html.HtmlColumn;
import jakarta.faces.component.html.HtmlDataTable;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonHtmlAttributesUtil;
import org.apache.myfaces.renderkit.html.util.CommonHtmlEventsUtil;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.util.lang.ArrayUtils;
import org.apache.myfaces.util.lang.StringUtils;

public class HtmlTableRendererBase
extends HtmlRenderer {
    protected static final String HEADER_FACET_NAME = "header";
    protected static final String FOOTER_FACET_NAME = "footer";
    protected static final String CAPTION_FACET_NAME = "caption";
    private static final Logger log = Logger.getLogger(HtmlTableRendererBase.class.getName());
    private static final Integer[] ZERO_INT_ARRAY = new Integer[]{0};

    protected int getNewspaperColumns(UIComponent component) {
        return 1;
    }

    protected UIComponent getNewspaperTableSpacer(UIComponent component) {
        return null;
    }

    protected boolean hasNewspaperTableSpacer(UIComponent component) {
        return false;
    }

    protected boolean isNewspaperHorizontalOrientation(UIComponent component) {
        return false;
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Map<String, List<ClientBehavior>> behaviors;
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIData.class);
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)((Object)uiComponent)).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        this.beforeTable(facesContext, (UIData)uiComponent);
        this.startTable(facesContext, uiComponent);
    }

    protected void startTable(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", uiComponent);
        Map<String, List<ClientBehavior>> behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)((Object)uiComponent)).getClientBehaviors();
            if (!behaviors.isEmpty()) {
                HtmlRendererUtils.writeIdAndName(writer, uiComponent, facesContext);
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonHtmlAttributesUtil.renderEventProperties(writer, CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent), uiComponent);
            } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                CommonHtmlEventsUtil.renderBehaviorizedEventHandlers(facesContext, writer, CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent), CommonHtmlEventsUtil.getMarkedEvents(uiComponent), uiComponent, behaviors);
            } else {
                HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
            }
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.TABLE_ATTRIBUTES);
                CommonHtmlAttributesUtil.renderCommonPassthroughPropertiesWithoutEvents(writer, CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent), uiComponent);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.TABLE_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
            }
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.TABLE_ATTRIBUTES);
                CommonHtmlAttributesUtil.renderCommonPassthroughProperties(writer, CommonHtmlAttributesUtil.getMarkedAttributes(uiComponent), uiComponent);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
            }
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, UIData.class);
        this.beforeBody(facesContext, (UIData)component);
        this.encodeInnerHtml(facesContext, component);
        this.afterBody(facesContext, (UIData)component);
    }

    protected void renderCaptionFacet(FacesContext facesContext, ResponseWriter writer, UIComponent component) throws IOException {
        HtmlRendererUtils.renderTableCaption(facesContext, writer, component);
    }

    protected void renderColgroupsFacet(FacesContext facesContext, ResponseWriter writer, UIComponent component) throws IOException {
        UIComponent colgroupsFacet = component.getFacet("colgroups");
        if (colgroupsFacet == null) {
            return;
        }
        colgroupsFacet.encodeAll(facesContext);
    }

    protected static Styles getStyles(UIData uiData) {
        String columnClasses;
        String rowClasses;
        if (uiData instanceof HtmlDataTable) {
            rowClasses = ((HtmlDataTable)uiData).getRowClasses();
            columnClasses = ((HtmlDataTable)uiData).getColumnClasses();
        } else {
            rowClasses = (String)uiData.getAttributes().get("rowClasses");
            columnClasses = (String)uiData.getAttributes().get("columnClasses");
        }
        return new Styles(rowClasses, columnClasses);
    }

    private Integer[] getBodyRows(FacesContext facesContext, UIComponent component) {
        Integer[] bodyrows = null;
        String bodyrowsAttr = (String)component.getAttributes().get("bodyrows");
        if (bodyrowsAttr != null && !bodyrowsAttr.isEmpty()) {
            String[] bodyrowsString = StringUtils.trim(StringUtils.splitShortString(bodyrowsAttr, ','));
            bodyrows = new Integer[bodyrowsString.length];
            for (int i = 0; i < bodyrowsString.length; ++i) {
                bodyrows[i] = Integer.valueOf(bodyrowsString[i]);
            }
        } else {
            bodyrows = ZERO_INT_ARRAY;
        }
        return bodyrows;
    }

    public void encodeInnerHtml(FacesContext facesContext, UIComponent component) throws IOException {
        int last;
        UIData uiData = (UIData)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        int rowCount = uiData.getRowCount();
        int newspaperColumns = this.getNewspaperColumns(component);
        if (rowCount == -1 && newspaperColumns == 1) {
            this.encodeInnerHtmlUnknownRowCount(facesContext, component);
            return;
        }
        if (rowCount == 0) {
            writer.startElement("tbody", null);
            writer.writeAttribute("id", component.getClientId(facesContext) + ":tbody_element", null);
            writer.startElement("tr", null);
            writer.startElement("td", null);
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("tbody");
            return;
        }
        Styles styles = HtmlTableRendererBase.getStyles(uiData);
        int first = uiData.getFirst();
        int rows = uiData.getRows();
        if (rows <= 0) {
            last = rowCount;
        } else {
            last = first + rows;
            if (last > rowCount) {
                last = rowCount;
            }
        }
        int newspaperRows = (last - first) % newspaperColumns == 0 ? (last - first) / newspaperColumns : (last - first) / newspaperColumns + 1;
        boolean newspaperHorizontalOrientation = this.isNewspaperHorizontalOrientation(component);
        Object[] bodyrows = this.getBodyRows(facesContext, component);
        int bodyrowsCount = 0;
        for (int nr = 0; nr < newspaperRows; ++nr) {
            boolean rowStartRendered = false;
            for (int nc = 0; nc < newspaperColumns; ++nc) {
                int currentRow = newspaperHorizontalOrientation ? nr * newspaperColumns + nc + first : nc * newspaperRows + nr + first;
                if (currentRow >= last) continue;
                uiData.setRowIndex(currentRow);
                if (!uiData.isRowAvailable()) {
                    log.severe("Row is not available. Rowindex = " + currentRow);
                    break;
                }
                if (nc == 0) {
                    this.beforeRow(facesContext, uiData);
                    if (ArrayUtils.contains(bodyrows, currentRow)) {
                        if (bodyrowsCount != 0) {
                            writer.endElement("tbody");
                        }
                        writer.startElement("tbody", null);
                        writer.writeAttribute("id", component.getClientId(facesContext) + ":tbody_element" + String.valueOf(bodyrowsCount == 0 ? "" : Integer.valueOf(bodyrowsCount)), null);
                        ++bodyrowsCount;
                    }
                    this.renderRowStart(facesContext, writer, uiData, styles, nr);
                    rowStartRendered = true;
                }
                List<UIComponent> children = null;
                int columnStyleIndex = 0;
                int size = this.getChildCount(component);
                for (int j = 0; j < size; ++j) {
                    UIComponent child;
                    if (children == null) {
                        children = this.getChildren(component);
                    }
                    if (!(child = (UIComponent)children.get(j)).isRendered()) continue;
                    boolean columnRendering = child instanceof UIColumn;
                    if (columnRendering) {
                        this.beforeColumn(facesContext, uiData, columnStyleIndex);
                    }
                    this.encodeColumnChild(facesContext, writer, uiData, child, styles, nc * uiData.getChildCount() + columnStyleIndex);
                    if (columnRendering) {
                        this.afterColumn(facesContext, uiData, columnStyleIndex);
                    }
                    columnStyleIndex += this.getColumnCountForComponent(facesContext, uiData, child);
                }
                if (!this.hasNewspaperTableSpacer(uiData) || nc >= newspaperColumns - 1) continue;
                this.renderSpacerCell(facesContext, writer, uiData);
            }
            if (!rowStartRendered) continue;
            this.renderRowEnd(facesContext, writer, uiData);
            this.afterRow(facesContext, uiData);
        }
        if (bodyrowsCount != 0) {
            writer.endElement("tbody");
        }
    }

    private void encodeInnerHtmlUnknownRowCount(FacesContext facesContext, UIComponent component) throws IOException {
        UIData uiData = (UIData)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        Styles styles = HtmlTableRendererBase.getStyles(uiData);
        Object[] bodyrows = this.getBodyRows(facesContext, component);
        int bodyrowsCount = 0;
        int first = uiData.getFirst();
        int rows = uiData.getRows();
        int currentRow = first;
        boolean isRowRendered = false;
        do {
            uiData.setRowIndex(currentRow);
            if (!uiData.isRowAvailable()) break;
            isRowRendered = true;
            this.beforeRow(facesContext, uiData);
            if (ArrayUtils.contains(bodyrows, currentRow)) {
                if (bodyrowsCount != 0) {
                    writer.endElement("tbody");
                }
                writer.startElement("tbody", null);
                writer.writeAttribute("id", component.getClientId(facesContext) + ":tbody_element" + String.valueOf(bodyrowsCount == 0 ? "" : Integer.valueOf(bodyrowsCount)), null);
                ++bodyrowsCount;
            }
            this.renderRowStart(facesContext, writer, uiData, styles, currentRow);
            List<UIComponent> children = null;
            int columnStyleIndex = 0;
            int size = this.getChildCount(component);
            for (int j = 0; j < size; ++j) {
                UIComponent child;
                if (children == null) {
                    children = this.getChildren(component);
                }
                if (!(child = (UIComponent)children.get(j)).isRendered()) continue;
                boolean columnRendering = child instanceof UIColumn;
                if (columnRendering) {
                    this.beforeColumn(facesContext, uiData, columnStyleIndex);
                }
                this.encodeColumnChild(facesContext, writer, uiData, child, styles, columnStyleIndex);
                if (columnRendering) {
                    this.afterColumn(facesContext, uiData, columnStyleIndex);
                }
                columnStyleIndex += this.getColumnCountForComponent(facesContext, uiData, child);
            }
            this.renderRowEnd(facesContext, writer, uiData);
            this.afterRow(facesContext, uiData);
        } while (rows <= 0 || ++currentRow - first <= rows);
        if (!isRowRendered) {
            writer.startElement("tbody", null);
            writer.writeAttribute("id", component.getClientId(facesContext) + ":tbody_element", null);
            writer.startElement("tr", null);
            writer.startElement("td", null);
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("tbody");
            return;
        }
        if (bodyrowsCount != 0) {
            writer.endElement("tbody");
        }
    }

    protected void encodeColumnChild(FacesContext facesContext, ResponseWriter writer, UIData uiData, UIComponent component, Styles styles, int columnStyleIndex) throws IOException {
        if (component instanceof UIColumn) {
            this.renderColumnBody(facesContext, writer, uiData, component, styles, columnStyleIndex);
        }
    }

    protected void renderColumnBody(FacesContext facesContext, ResponseWriter writer, UIData uiData, UIComponent component, Styles styles, int columnStyleIndex) throws IOException {
        boolean rowHeader;
        Object rowHeaderAttr = component.getAttributes().get("rowHeader");
        boolean bl = rowHeader = rowHeaderAttr != null && (Boolean)rowHeaderAttr != false;
        if (rowHeader) {
            writer.startElement("th", null);
            writer.writeAttribute("scope", "row", null);
        } else {
            writer.startElement("td", null);
        }
        Object styleClass = null;
        if (component instanceof HtmlColumn) {
            styleClass = ((HtmlColumn)component).getStyleClass();
        }
        if (styles.hasColumnStyle()) {
            styleClass = styleClass == null ? styles.getColumnStyle(columnStyleIndex) : (String)styleClass + " " + styles.getColumnStyle(columnStyleIndex);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, null);
        }
        component.encodeAll(facesContext);
        if (rowHeader) {
            writer.endElement("th");
        } else {
            writer.endElement("td");
        }
    }

    protected void renderRowStart(FacesContext facesContext, ResponseWriter writer, UIData uiData, Styles styles, int rowStyleIndex) throws IOException {
        writer.startElement("tr", null);
        this.renderRowStyle(facesContext, writer, uiData, styles, rowStyleIndex);
        Object rowId = uiData.getAttributes().get("rowId");
        if (rowId != null) {
            writer.writeAttribute("id", rowId.toString(), null);
        }
    }

    protected void renderRowStyle(FacesContext facesContext, ResponseWriter writer, UIData uiData, Styles styles, int rowStyleIndex) throws IOException {
        Object rowClass = null;
        if (uiData instanceof HtmlDataTable) {
            rowClass = ((HtmlDataTable)uiData).getRowClass();
        }
        if (styles.hasRowStyle()) {
            rowClass = rowClass == null ? styles.getRowStyle(rowStyleIndex) : (String)rowClass + " " + styles.getRowStyle(rowStyleIndex);
        }
        if (rowClass != null) {
            writer.writeAttribute("class", rowClass, null);
        }
    }

    protected void renderRowEnd(FacesContext facesContext, ResponseWriter writer, UIData uiData) throws IOException {
        writer.endElement("tr");
    }

    protected void beforeTable(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void beforeBody(FacesContext facesContext, UIData uiData) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        this.renderCaptionFacet(facesContext, writer, uiData);
        this.renderColgroupsFacet(facesContext, writer, uiData);
        this.renderFacet(facesContext, writer, uiData, true);
        this.renderFacet(facesContext, writer, uiData, false);
    }

    protected void beforeRow(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void afterRow(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void beforeColumn(FacesContext facesContext, UIData uiData, int columnIndex) throws IOException {
    }

    protected void afterColumn(FacesContext facesContext, UIData uiData, int columnIndex) throws IOException {
    }

    protected int getColumnCountForComponent(FacesContext facesContext, UIData uiData, UIComponent child) {
        if (child instanceof UIColumn) {
            return 1;
        }
        return 0;
    }

    protected void beforeColumnHeaderOrFooter(FacesContext facesContext, UIData uiData, boolean header, int columnIndex) throws IOException {
    }

    protected void afterColumnHeaderOrFooter(FacesContext facesContext, UIData uiData, boolean header, int columnIndex) throws IOException {
    }

    protected void inBodyStart(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void afterBody(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void afterTable(FacesContext facesContext, UIData uiData) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIData.class);
        this.endTable(facesContext, uiComponent);
        this.afterTable(facesContext, (UIData)uiComponent);
    }

    protected void endTable(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("table");
    }

    protected void renderFacet(FacesContext facesContext, ResponseWriter writer, UIComponent component, boolean header) throws IOException {
        int colspan = 0;
        boolean hasColumnFacet = false;
        int childCount = component.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent uiComponent = component.getChildren().get(i);
            if (!uiComponent.isRendered()) continue;
            colspan += this.determineChildColSpan(uiComponent);
            if (hasColumnFacet) continue;
            hasColumnFacet = this.hasFacet(header, uiComponent);
        }
        UIComponent facet = null;
        if (component.getFacetCount() > 0) {
            UIComponent uIComponent = facet = header ? component.getFacets().get(HEADER_FACET_NAME) : component.getFacets().get(FOOTER_FACET_NAME);
        }
        if (facet != null || hasColumnFacet) {
            String elemName = this.determineHeaderFooterTag(facesContext, component, header);
            if (elemName != null) {
                writer.startElement(elemName, null);
            }
            if (header) {
                String headerStyleClass = HtmlTableRendererBase.getHeaderClass(component);
                if (facet != null) {
                    this.renderTableHeaderRow(facesContext, writer, component, facet, headerStyleClass, colspan);
                }
                if (hasColumnFacet) {
                    this.renderColumnHeaderRow(facesContext, writer, component, headerStyleClass);
                }
            } else {
                String footerStyleClass = HtmlTableRendererBase.getFooterClass(component);
                if (hasColumnFacet) {
                    this.renderColumnFooterRow(facesContext, writer, component, footerStyleClass);
                }
                if (facet != null) {
                    this.renderTableFooterRow(facesContext, writer, component, facet, footerStyleClass, colspan);
                }
            }
            if (elemName != null) {
                writer.endElement(elemName);
            }
        }
    }

    protected String determineHeaderFooterTag(FacesContext facesContext, UIComponent component, boolean header) {
        return header ? "thead" : "tfoot";
    }

    protected boolean hasFacet(boolean header, UIComponent uiComponent) {
        if (uiComponent instanceof UIColumn) {
            UIColumn uiColumn = (UIColumn)uiComponent;
            return header ? uiColumn.getHeader() != null : uiColumn.getFooter() != null;
        }
        return false;
    }

    protected int determineChildColSpan(UIComponent uiComponent) {
        if (uiComponent instanceof UIColumn) {
            return 1;
        }
        return 0;
    }

    protected void renderTableHeaderRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, UIComponent headerFacet, String headerStyleClass, int colspan) throws IOException {
        this.renderTableHeaderOrFooterRow(facesContext, writer, component, headerFacet, headerStyleClass, this.determineHeaderCellTag(facesContext, component), colspan, true);
    }

    protected void renderTableFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, UIComponent footerFacet, String footerStyleClass, int colspan) throws IOException {
        this.renderTableHeaderOrFooterRow(facesContext, writer, component, footerFacet, footerStyleClass, "td", colspan, false);
    }

    protected void renderColumnHeaderRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String headerStyleClass) throws IOException {
        this.renderColumnHeaderOrFooterRow(facesContext, writer, component, headerStyleClass, true);
    }

    protected void renderColumnFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String footerStyleClass) throws IOException {
        this.renderColumnHeaderOrFooterRow(facesContext, writer, component, footerStyleClass, false);
    }

    protected void renderTableHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, UIComponent facet, String styleClass, String colElementName, int colspan, boolean isHeader) throws IOException {
        writer.startElement("tr", null);
        writer.startElement(colElementName, null);
        if (colElementName.equals(this.determineHeaderCellTag(facesContext, component)) && isHeader) {
            writer.writeAttribute("scope", "colgroup", null);
        }
        int newsPaperColumns = this.getNewspaperColumns(component);
        int totalColumns = colspan * newsPaperColumns;
        if (this.hasNewspaperTableSpacer(component)) {
            totalColumns = totalColumns + newsPaperColumns - 1;
        }
        if (totalColumns > 0) {
            writer.writeAttribute("colspan", totalColumns, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, null);
        }
        if (facet != null) {
            facet.encodeAll(facesContext);
        }
        writer.endElement(colElementName);
        writer.endElement("tr");
    }

    private void renderColumnHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String styleClass, boolean header) throws IOException {
        writer.startElement("tr", null);
        int columnIndex = 0;
        int newspaperColumns = this.getNewspaperColumns(component);
        for (int nc = 0; nc < newspaperColumns; ++nc) {
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent uiComponent = component.getChildren().get(i);
                if (uiComponent.isRendered()) {
                    if (component instanceof UIData && uiComponent instanceof UIColumn) {
                        this.beforeColumnHeaderOrFooter(facesContext, (UIData)component, header, columnIndex);
                    }
                    this.renderColumnChildHeaderOrFooterRow(facesContext, writer, uiComponent, styleClass, header);
                    if (component instanceof UIData && uiComponent instanceof UIColumn) {
                        this.afterColumnHeaderOrFooter(facesContext, (UIData)component, header, columnIndex);
                    }
                }
                ++columnIndex;
            }
            if (!this.hasNewspaperTableSpacer(component) || nc >= newspaperColumns - 1) continue;
            this.renderSpacerCell(facesContext, writer, component);
        }
        writer.endElement("tr");
    }

    protected void renderSpacerCell(FacesContext facesContext, ResponseWriter writer, UIComponent component) throws IOException {
        UIComponent spacer = this.getNewspaperTableSpacer(component);
        if (spacer == null) {
            return;
        }
        writer.startElement("td", null);
        spacer.encodeAll(facesContext);
        writer.endElement("td");
    }

    protected void renderColumnChildHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, String styleClass, boolean isHeader) throws IOException {
        if (uiComponent instanceof UIColumn) {
            if (uiComponent instanceof HtmlColumn) {
                HtmlColumn column = (HtmlColumn)uiComponent;
                if (isHeader && column.getHeaderClass() != null) {
                    styleClass = column.getHeaderClass();
                } else if (!isHeader && column.getFooterClass() != null) {
                    styleClass = column.getFooterClass();
                }
            } else {
                UIColumn column = (UIColumn)uiComponent;
                if (isHeader) {
                    String headerClass = (String)column.getAttributes().get("headerClass");
                    if (headerClass != null) {
                        styleClass = headerClass;
                    }
                } else {
                    String footerClass = (String)column.getAttributes().get("footerClass");
                    if (footerClass != null) {
                        styleClass = footerClass;
                    }
                }
            }
            if (isHeader) {
                this.renderColumnHeaderCell(facesContext, writer, uiComponent, ((UIColumn)uiComponent).getHeader(), styleClass, 0);
            } else {
                this.renderColumnFooterCell(facesContext, writer, uiComponent, ((UIColumn)uiComponent).getFooter(), styleClass, 0);
            }
        }
    }

    protected void renderColumnHeaderCell(FacesContext facesContext, ResponseWriter writer, UIColumn uiColumn, String headerStyleClass, int colspan) throws IOException {
        this.renderColumnHeaderCell(facesContext, writer, uiColumn, uiColumn.getHeader(), headerStyleClass, colspan);
    }

    protected void renderColumnHeaderCell(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, UIComponent facet, String headerStyleClass, int colspan) throws IOException {
        writer.startElement(this.determineHeaderCellTag(facesContext, uiComponent.getParent()), null);
        if (colspan > 1) {
            writer.writeAttribute("colspan", colspan, null);
        }
        if (headerStyleClass != null) {
            writer.writeAttribute("class", headerStyleClass, null);
        }
        writer.writeAttribute("scope", "col", null);
        if (facet != null) {
            facet.encodeAll(facesContext);
        }
        writer.endElement(this.determineHeaderCellTag(facesContext, uiComponent.getParent()));
    }

    protected String determineHeaderCellTag(FacesContext facesContext, UIComponent uiComponent) {
        return "th";
    }

    protected void renderColumnFooterCell(FacesContext facesContext, ResponseWriter writer, UIColumn uiColumn, String footerStyleClass, int colspan) throws IOException {
        this.renderColumnFooterCell(facesContext, writer, uiColumn, uiColumn.getFooter(), footerStyleClass, colspan);
    }

    protected void renderColumnFooterCell(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, UIComponent facet, String footerStyleClass, int colspan) throws IOException {
        writer.startElement("td", null);
        if (colspan > 1) {
            writer.writeAttribute("colspan", colspan, null);
        }
        if (footerStyleClass != null) {
            writer.writeAttribute("class", footerStyleClass, null);
        }
        if (facet != null) {
            facet.encodeAll(facesContext);
        }
        writer.endElement("td");
    }

    protected static String getHeaderClass(UIComponent component) {
        if (component instanceof HtmlDataTable) {
            return ((HtmlDataTable)component).getHeaderClass();
        }
        return (String)component.getAttributes().get("headerClass");
    }

    protected static String getFooterClass(UIComponent component) {
        if (component instanceof HtmlDataTable) {
            return ((HtmlDataTable)component).getFooterClass();
        }
        return (String)component.getAttributes().get("footerClass");
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        ClientBehaviorRendererUtils.decodeClientBehaviors(context, component);
    }

    protected static class Styles {
        private String[] _columnStyle;
        private String[] _rowStyle;

        Styles(String rowStyles, String columnStyles) {
            this._rowStyle = rowStyles == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(rowStyles, ','));
            this._columnStyle = columnStyles == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(columnStyles, ','));
        }

        public String getRowStyle(int idx) {
            if (!this.hasRowStyle()) {
                return null;
            }
            return this._rowStyle[idx % this._rowStyle.length];
        }

        public String getColumnStyle(int idx) {
            if (!this.hasColumnStyle()) {
                return null;
            }
            if (idx < this._columnStyle.length) {
                return this._columnStyle[idx];
            }
            return null;
        }

        public boolean hasRowStyle() {
            return this._rowStyle.length > 0;
        }

        public boolean hasColumnStyle() {
            return this._columnStyle.length > 0;
        }
    }
}

